/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.renderinstruction;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Cap;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.XmlUtils;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Area
extends RenderInstruction {
    private boolean bitmapInvalid;
    private final Paint fill;
    private final int level;
    private final String relativePathPrefix;
    private Bitmap shaderBitmap;
    private String src;
    private final Paint stroke;
    private final Map<Byte, Paint> strokes;
    private float strokeWidth;

    public Area(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser, int level, String relativePathPrefix) throws IOException, XmlPullParserException {
        super(graphicFactory, displayModel);
        this.level = level;
        this.relativePathPrefix = relativePathPrefix;
        this.fill = graphicFactory.createPaint();
        this.fill.setColor(Color.TRANSPARENT);
        this.fill.setStyle(Style.FILL);
        this.fill.setStrokeCap(Cap.ROUND);
        this.stroke = graphicFactory.createPaint();
        this.stroke.setColor(Color.TRANSPARENT);
        this.stroke.setStyle(Style.STROKE);
        this.stroke.setStrokeCap(Cap.ROUND);
        this.strokes = new HashMap<Byte, Paint>();
        this.extractValues(elementName, pullParser);
    }

    @Override
    public void destroy() {
    }

    private void extractValues(String elementName, XmlPullParser pullParser) throws IOException, XmlPullParserException {
        for (int i = 0; i < pullParser.getAttributeCount(); ++i) {
            String name = pullParser.getAttributeName(i);
            String value = pullParser.getAttributeValue(i);
            if ("src".equals(name)) {
                this.src = value;
                continue;
            }
            if ("cat".equals(name)) {
                this.category = value;
                continue;
            }
            if ("fill".equals(name)) {
                this.fill.setColor(XmlUtils.getColor(this.graphicFactory, value));
                continue;
            }
            if ("stroke".equals(name)) {
                this.stroke.setColor(XmlUtils.getColor(this.graphicFactory, value));
                continue;
            }
            if ("symbol-height".equals(name)) {
                this.height = (float)XmlUtils.parseNonNegativeInteger(name, value) * this.displayModel.getScaleFactor();
                continue;
            }
            if ("symbol-percent".equals(name)) {
                this.percent = XmlUtils.parseNonNegativeInteger(name, value);
                continue;
            }
            if ("symbol-scaling".equals(name)) {
                this.scaling = this.fromValue(value);
                continue;
            }
            if ("symbol-width".equals(name)) {
                this.width = (float)XmlUtils.parseNonNegativeInteger(name, value) * this.displayModel.getScaleFactor();
                continue;
            }
            if ("stroke-width".equals(name)) {
                this.strokeWidth = XmlUtils.parseNonNegativeFloat(name, value) * this.displayModel.getScaleFactor();
                continue;
            }
            throw XmlUtils.createXmlPullParserException(elementName, name, value, i);
        }
    }

    @Override
    public void renderNode(RenderCallback renderCallback, RenderContext renderContext, PointOfInterest poi) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
        Area area = this;
        synchronized (area) {
            Paint fillPaint = this.getFillPaint(renderContext.rendererJob.tile.zoomLevel);
            if (this.shaderBitmap == null && !this.bitmapInvalid) {
                try {
                    this.shaderBitmap = this.createBitmap(this.relativePathPrefix, this.src);
                    if (this.shaderBitmap != null) {
                        fillPaint.setBitmapShader(this.shaderBitmap);
                        this.shaderBitmap.decrementRefCount();
                    }
                }
                catch (IOException ioException) {
                    this.bitmapInvalid = true;
                }
            }
            fillPaint.setBitmapShaderShift(way.getTile().getOrigin());
            renderCallback.renderArea(renderContext, fillPaint, this.getStrokePaint(renderContext.rendererJob.tile.zoomLevel), this.level, way);
        }
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor, byte zoomLevel) {
        if (this.stroke != null) {
            Paint zlPaint = this.graphicFactory.createPaint(this.stroke);
            zlPaint.setStrokeWidth(this.strokeWidth * scaleFactor);
            this.strokes.put(zoomLevel, zlPaint);
        }
    }

    @Override
    public void scaleTextSize(float scaleFactor, byte zoomLevel) {
    }

    private Paint getFillPaint(byte zoomLevel) {
        return this.fill;
    }

    private Paint getStrokePaint(byte zoomLevel) {
        Paint paint = this.strokes.get(zoomLevel);
        if (paint == null) {
            paint = this.stroke;
        }
        return paint;
    }
}

