/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.renderinstruction;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Cap;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Join;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.XmlUtils;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Line
extends RenderInstruction {
    private static final Pattern SPLIT_PATTERN = Pattern.compile(",");
    private boolean bitmapCreated;
    private float dy;
    private final Map<Byte, Float> dyScaled;
    private final int level;
    private final String relativePathPrefix;
    private Bitmap shaderBitmap;
    private String src;
    private final Paint stroke;
    private final Map<Byte, Paint> strokes;
    private float strokeWidth;

    public Line(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser, int level, String relativePathPrefix) throws IOException, XmlPullParserException {
        super(graphicFactory, displayModel);
        this.level = level;
        this.relativePathPrefix = relativePathPrefix;
        this.stroke = graphicFactory.createPaint();
        this.stroke.setColor(Color.BLACK);
        this.stroke.setStyle(Style.STROKE);
        this.stroke.setStrokeCap(Cap.ROUND);
        this.stroke.setStrokeJoin(Join.ROUND);
        this.strokes = new HashMap<Byte, Paint>();
        this.dyScaled = new HashMap<Byte, Float>();
        this.extractValues(graphicFactory, displayModel, elementName, pullParser, relativePathPrefix);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void renderNode(RenderCallback renderCallback, RenderContext renderContext, PointOfInterest poi) {
    }

    @Override
    public synchronized void renderWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
        Float dyScale;
        if (!this.bitmapCreated) {
            try {
                this.shaderBitmap = this.createBitmap(this.relativePathPrefix, this.src);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bitmapCreated = true;
        }
        Paint strokePaint = this.getStrokePaint(renderContext.rendererJob.tile.zoomLevel);
        if (this.shaderBitmap != null) {
            strokePaint.setBitmapShader(this.shaderBitmap);
            strokePaint.setBitmapShaderShift(way.getTile().getOrigin());
        }
        if ((dyScale = this.dyScaled.get(renderContext.rendererJob.tile.zoomLevel)) == null) {
            dyScale = Float.valueOf(this.dy);
        }
        renderCallback.renderWay(renderContext, strokePaint, dyScale.floatValue(), this.level, way);
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor, byte zoomLevel) {
        if (this.stroke != null) {
            Paint s = this.graphicFactory.createPaint(this.stroke);
            s.setStrokeWidth(this.strokeWidth * scaleFactor);
            this.strokes.put(zoomLevel, s);
        }
        this.dyScaled.put(zoomLevel, Float.valueOf(this.dy * scaleFactor));
    }

    @Override
    public void scaleTextSize(float scaleFactor, byte zoomLevel) {
    }

    private void extractValues(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser, String relativePathPrefix) throws IOException, XmlPullParserException {
        for (int i = 0; i < pullParser.getAttributeCount(); ++i) {
            String name = pullParser.getAttributeName(i);
            String value = pullParser.getAttributeValue(i);
            if ("src".equals(name)) {
                this.src = value;
                continue;
            }
            if ("cat".equals(name)) {
                this.category = value;
                continue;
            }
            if ("dy".equals(name)) {
                this.dy = Float.parseFloat(value) * displayModel.getScaleFactor();
                continue;
            }
            if ("stroke".equals(name)) {
                this.stroke.setColor(XmlUtils.getColor(graphicFactory, value));
                continue;
            }
            if ("stroke-width".equals(name)) {
                this.strokeWidth = XmlUtils.parseNonNegativeFloat(name, value) * displayModel.getScaleFactor();
                continue;
            }
            if ("stroke-dasharray".equals(name)) {
                float[] floatArray = Line.parseFloatArray(name, value);
                for (int f = 0; f < floatArray.length; ++f) {
                    floatArray[f] = floatArray[f] * displayModel.getScaleFactor();
                }
                this.stroke.setDashPathEffect(floatArray);
                continue;
            }
            if ("stroke-linecap".equals(name)) {
                this.stroke.setStrokeCap(Cap.fromString(value));
                continue;
            }
            if ("stroke-linejoin".equals(name)) {
                this.stroke.setStrokeJoin(Join.fromString(value));
                continue;
            }
            if ("symbol-height".equals(name)) {
                this.height = (float)XmlUtils.parseNonNegativeInteger(name, value) * displayModel.getScaleFactor();
                continue;
            }
            if ("symbol-percent".equals(name)) {
                this.percent = XmlUtils.parseNonNegativeInteger(name, value);
                continue;
            }
            if ("symbol-scaling".equals(name)) {
                this.scaling = this.fromValue(value);
                continue;
            }
            if ("symbol-width".equals(name)) {
                this.width = (float)XmlUtils.parseNonNegativeInteger(name, value) * displayModel.getScaleFactor();
                continue;
            }
            throw XmlUtils.createXmlPullParserException(elementName, name, value, i);
        }
    }

    private static float[] parseFloatArray(String name, String dashString) throws XmlPullParserException {
        String[] dashEntries = SPLIT_PATTERN.split(dashString);
        float[] dashIntervals = new float[dashEntries.length];
        for (int i = 0; i < dashEntries.length; ++i) {
            dashIntervals[i] = XmlUtils.parseNonNegativeFloat(name, dashEntries[i]);
        }
        return dashIntervals;
    }

    private Paint getStrokePaint(byte zoomLevel) {
        Paint paint = this.strokes.get(zoomLevel);
        if (paint == null) {
            paint = this.stroke;
        }
        return paint;
    }
}

