/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.rule;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapsforge.core.model.Tag;
import org.mapsforge.map.rendertheme.rule.Closed;

class MatchingCacheKey {
    private final Closed closed;
    private final List<Tag> tags;
    private final Set<Tag> tagsWithoutName;
    private final byte zoomLevel;

    MatchingCacheKey(List<Tag> tags, byte zoomLevel, Closed closed) {
        this.tags = tags;
        this.zoomLevel = zoomLevel;
        this.closed = closed;
        this.tagsWithoutName = new HashSet<Tag>();
        if (this.tags != null) {
            for (Tag tag : tags) {
                if ("name".equals(tag.key)) continue;
                this.tagsWithoutName.add(tag);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MatchingCacheKey)) {
            return false;
        }
        MatchingCacheKey other = (MatchingCacheKey)obj;
        if (this.closed != other.closed) {
            return false;
        }
        if (this.tagsWithoutName == null && other.tagsWithoutName != null) {
            return false;
        }
        if (!this.tagsWithoutName.equals(other.tagsWithoutName)) {
            return false;
        }
        return this.zoomLevel == other.zoomLevel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.closed == null ? 0 : this.closed.hashCode());
        result = 31 * result + this.tagsWithoutName.hashCode();
        result = 31 * result + this.zoomLevel;
        return result;
    }
}

