/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.rule;

import java.util.List;
import org.mapsforge.core.model.Tag;
import org.mapsforge.map.rendertheme.rule.AttributeMatcher;

class NegativeMatcher
implements AttributeMatcher {
    private final List<String> keyList;
    private final List<String> valueList;

    NegativeMatcher(List<String> keyList, List<String> valueList) {
        this.keyList = keyList;
        this.valueList = valueList;
    }

    @Override
    public boolean isCoveredBy(AttributeMatcher attributeMatcher) {
        return false;
    }

    @Override
    public boolean matches(List<Tag> tags) {
        if (this.keyListDoesNotContainKeys(tags)) {
            return true;
        }
        int n = tags.size();
        for (int i = 0; i < n; ++i) {
            if (!this.valueList.contains(tags.get((int)i).value)) continue;
            return true;
        }
        return false;
    }

    private boolean keyListDoesNotContainKeys(List<Tag> tags) {
        int n = tags.size();
        for (int i = 0; i < n; ++i) {
            if (!this.keyList.contains(tags.get((int)i).key)) continue;
            return false;
        }
        return true;
    }
}

