/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapsforge.core.util.LRUCache;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.map.rendertheme.rule.Closed;
import org.mapsforge.map.rendertheme.rule.MatchingCacheKey;
import org.mapsforge.map.rendertheme.rule.RenderThemeBuilder;
import org.mapsforge.map.rendertheme.rule.Rule;

public class RenderTheme {
    private static final int MATCHING_CACHE_SIZE = 1024;
    private final float baseStrokeWidth;
    private final float baseTextSize;
    private final boolean hasBackgroundOutside;
    private int levels;
    private final int mapBackground;
    private final int mapBackgroundOutside;
    private final LRUCache<MatchingCacheKey, List<RenderInstruction>> wayMatchingCache;
    private final LRUCache<MatchingCacheKey, List<RenderInstruction>> poiMatchingCache;
    private final ArrayList<Rule> rulesList;
    private final Map<Byte, Float> strokeScales = new HashMap<Byte, Float>();
    private final Map<Byte, Float> textScales = new HashMap<Byte, Float>();

    RenderTheme(RenderThemeBuilder renderThemeBuilder) {
        this.baseStrokeWidth = renderThemeBuilder.baseStrokeWidth;
        this.baseTextSize = renderThemeBuilder.baseTextSize;
        this.hasBackgroundOutside = renderThemeBuilder.hasBackgroundOutside;
        this.mapBackground = renderThemeBuilder.mapBackground;
        this.mapBackgroundOutside = renderThemeBuilder.mapBackgroundOutside;
        this.rulesList = new ArrayList();
        this.poiMatchingCache = new LRUCache(1024);
        this.wayMatchingCache = new LRUCache(1024);
    }

    public void destroy() {
        this.poiMatchingCache.clear();
        this.wayMatchingCache.clear();
        for (Rule r : this.rulesList) {
            r.destroy();
        }
    }

    public int getLevels() {
        return this.levels;
    }

    public int getMapBackground() {
        return this.mapBackground;
    }

    public int getMapBackgroundOutside() {
        return this.mapBackgroundOutside;
    }

    public boolean hasMapBackgroundOutside() {
        return this.hasBackgroundOutside;
    }

    public void matchClosedWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
        this.matchWay(renderCallback, renderContext, Closed.YES, way);
    }

    public void matchLinearWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
        this.matchWay(renderCallback, renderContext, Closed.NO, way);
    }

    public synchronized void matchNode(RenderCallback renderCallback, RenderContext renderContext, PointOfInterest poi) {
        MatchingCacheKey matchingCacheKey = new MatchingCacheKey(poi.tags, renderContext.rendererJob.tile.zoomLevel, Closed.NO);
        ArrayList<RenderInstruction> matchingList = (ArrayList<RenderInstruction>)this.poiMatchingCache.get(matchingCacheKey);
        if (matchingList != null) {
            int n = matchingList.size();
            for (int i = 0; i < n; ++i) {
                ((RenderInstruction)matchingList.get(i)).renderNode(renderCallback, renderContext, poi);
            }
            return;
        }
        matchingList = new ArrayList<RenderInstruction>();
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).matchNode(renderCallback, renderContext, matchingList, poi);
        }
        this.poiMatchingCache.put(matchingCacheKey, matchingList);
    }

    public synchronized void scaleStrokeWidth(float scaleFactor, byte zoomLevel) {
        if (!this.strokeScales.containsKey(zoomLevel) || scaleFactor != this.strokeScales.get(zoomLevel).floatValue()) {
            int n = this.rulesList.size();
            for (int i = 0; i < n; ++i) {
                Rule rule = this.rulesList.get(i);
                if (rule.zoomMin > zoomLevel || rule.zoomMax < zoomLevel) continue;
                rule.scaleStrokeWidth(scaleFactor * this.baseStrokeWidth, zoomLevel);
            }
            this.strokeScales.put(zoomLevel, Float.valueOf(scaleFactor));
        }
    }

    public synchronized void scaleTextSize(float scaleFactor, byte zoomLevel) {
        if (!this.textScales.containsKey(zoomLevel) || scaleFactor != this.textScales.get(zoomLevel).floatValue()) {
            int n = this.rulesList.size();
            for (int i = 0; i < n; ++i) {
                Rule rule = this.rulesList.get(i);
                if (rule.zoomMin > zoomLevel || rule.zoomMax < zoomLevel) continue;
                rule.scaleTextSize(scaleFactor * this.baseTextSize, zoomLevel);
            }
            this.textScales.put(zoomLevel, Float.valueOf(scaleFactor));
        }
    }

    void addRule(Rule rule) {
        this.rulesList.add(rule);
    }

    void complete() {
        this.rulesList.trimToSize();
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).onComplete();
        }
    }

    void setLevels(int levels) {
        this.levels = levels;
    }

    private synchronized void matchWay(RenderCallback renderCallback, RenderContext renderContext, Closed closed, PolylineContainer way) {
        MatchingCacheKey matchingCacheKey = new MatchingCacheKey(way.getTags(), way.getTile().zoomLevel, closed);
        ArrayList<RenderInstruction> matchingList = (ArrayList<RenderInstruction>)this.wayMatchingCache.get(matchingCacheKey);
        if (matchingList != null) {
            int n = matchingList.size();
            for (int i = 0; i < n; ++i) {
                ((RenderInstruction)matchingList.get(i)).renderWay(renderCallback, renderContext, way);
            }
            return;
        }
        matchingList = new ArrayList<RenderInstruction>();
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).matchWay(renderCallback, way, way.getTile(), closed, matchingList, renderContext);
        }
        this.wayMatchingCache.put(matchingCacheKey, matchingList);
    }
}

