/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.rule;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.XmlRenderTheme;
import org.mapsforge.map.rendertheme.rule.RenderTheme;
import org.mapsforge.map.rendertheme.rule.RenderThemeHandler;
import org.xmlpull.v1.XmlPullParserException;

public class RenderThemeFuture
extends FutureTask<RenderTheme> {
    private final AtomicInteger refCount = new AtomicInteger(1);

    public RenderThemeFuture(GraphicFactory graphicFactory, XmlRenderTheme xmlRenderTheme, DisplayModel displayModel) {
        super(new RenderThemeCallable(graphicFactory, xmlRenderTheme, displayModel));
    }

    public void decrementRefCount() {
        int c = this.refCount.decrementAndGet();
        if (c <= 0) {
            try {
                if (this.isDone()) {
                    ((RenderTheme)this.get()).destroy();
                } else {
                    this.cancel(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void incrementRefCount() {
        this.refCount.incrementAndGet();
    }

    private static class RenderThemeCallable
    implements Callable<RenderTheme> {
        private final GraphicFactory graphicFactory;
        private final XmlRenderTheme xmlRenderTheme;
        private final DisplayModel displayModel;

        public RenderThemeCallable(GraphicFactory graphicFactory, XmlRenderTheme xmlRenderTheme, DisplayModel displayModel) {
            this.graphicFactory = graphicFactory;
            this.xmlRenderTheme = xmlRenderTheme;
            this.displayModel = displayModel;
        }

        @Override
        public RenderTheme call() {
            if (this.xmlRenderTheme == null || this.displayModel == null) {
                return null;
            }
            try {
                return RenderThemeHandler.getRenderTheme(this.graphicFactory, this.displayModel, this.xmlRenderTheme);
            }
            catch (XmlPullParserException e) {
                throw new IllegalArgumentException("Parse error for XML rendertheme", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("File error for XML rendertheme", e);
            }
        }
    }
}

