/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.rule;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.kxml2.io.KXmlParser;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.util.IOUtils;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.XmlRenderTheme;
import org.mapsforge.map.rendertheme.XmlRenderThemeStyleLayer;
import org.mapsforge.map.rendertheme.XmlRenderThemeStyleMenu;
import org.mapsforge.map.rendertheme.renderinstruction.Area;
import org.mapsforge.map.rendertheme.renderinstruction.Caption;
import org.mapsforge.map.rendertheme.renderinstruction.Circle;
import org.mapsforge.map.rendertheme.renderinstruction.Line;
import org.mapsforge.map.rendertheme.renderinstruction.LineSymbol;
import org.mapsforge.map.rendertheme.renderinstruction.PathText;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.map.rendertheme.renderinstruction.Symbol;
import org.mapsforge.map.rendertheme.rule.RenderTheme;
import org.mapsforge.map.rendertheme.rule.RenderThemeBuilder;
import org.mapsforge.map.rendertheme.rule.Rule;
import org.mapsforge.map.rendertheme.rule.RuleBuilder;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class RenderThemeHandler {
    private static final Logger LOGGER = Logger.getLogger(RenderThemeHandler.class.getName());
    private static final String ELEMENT_NAME_RULE = "rule";
    private static final String UNEXPECTED_ELEMENT = "unexpected element: ";
    private Set<String> categories;
    private Rule currentRule;
    private final DisplayModel displayModel;
    private final Stack<Element> elementStack = new Stack();
    private final GraphicFactory graphicFactory;
    private int level;
    private final XmlPullParser pullParser;
    private String qName;
    private final String relativePathPrefix;
    private RenderTheme renderTheme;
    private final Stack<Rule> ruleStack = new Stack();
    private Map<String, Symbol> symbols = new HashMap<String, Symbol>();
    private final XmlRenderTheme xmlRenderTheme;
    private XmlRenderThemeStyleMenu renderThemeStyleMenu;
    private XmlRenderThemeStyleLayer currentLayer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderTheme getRenderTheme(GraphicFactory graphicFactory, DisplayModel displayModel, XmlRenderTheme xmlRenderTheme) throws IOException, XmlPullParserException {
        KXmlParser pullParser = new KXmlParser();
        RenderThemeHandler renderThemeHandler = new RenderThemeHandler(graphicFactory, displayModel, xmlRenderTheme.getRelativePathPrefix(), xmlRenderTheme, pullParser);
        InputStream inputStream = null;
        try {
            inputStream = xmlRenderTheme.getRenderThemeAsStream();
            pullParser.setInput(inputStream, null);
            renderThemeHandler.processRenderTheme();
            RenderTheme renderTheme = renderThemeHandler.renderTheme;
            return renderTheme;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    private RenderThemeHandler(GraphicFactory graphicFactory, DisplayModel displayModel, String relativePathPrefix, XmlRenderTheme xmlRenderTheme, XmlPullParser pullParser) {
        this.pullParser = pullParser;
        this.graphicFactory = graphicFactory;
        this.displayModel = displayModel;
        this.relativePathPrefix = relativePathPrefix;
        this.xmlRenderTheme = xmlRenderTheme;
    }

    public void processRenderTheme() throws XmlPullParserException, IOException {
        int eventType = this.pullParser.getEventType();
        do {
            if (eventType == 0) continue;
            if (eventType == 2) {
                this.startElement();
                continue;
            }
            if (eventType == 3) {
                this.endElement();
                continue;
            }
            if (eventType != 4) continue;
        } while ((eventType = this.pullParser.next()) != 1);
        this.endDocument();
    }

    private void endDocument() {
        if (this.renderTheme == null) {
            throw new IllegalArgumentException("missing element: rules");
        }
        this.renderTheme.setLevels(this.level);
        this.renderTheme.complete();
    }

    private void endElement() {
        this.qName = this.pullParser.getName();
        this.elementStack.pop();
        if (ELEMENT_NAME_RULE.equals(this.qName)) {
            this.ruleStack.pop();
            if (this.ruleStack.empty()) {
                if (this.isVisible(this.currentRule)) {
                    this.renderTheme.addRule(this.currentRule);
                }
            } else {
                this.currentRule = this.ruleStack.peek();
            }
        } else if ("stylemenu".equals(this.qName)) {
            if (null != this.xmlRenderTheme.getMenuCallback()) {
                this.categories = this.xmlRenderTheme.getMenuCallback().getCategories(this.renderThemeStyleMenu);
            }
            return;
        }
    }

    private void startElement() throws XmlPullParserException {
        block29: {
            this.qName = this.pullParser.getName();
            try {
                if ("rendertheme".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDER_THEME);
                    this.renderTheme = new RenderThemeBuilder(this.graphicFactory, this.qName, this.pullParser).build();
                    break block29;
                }
                if (ELEMENT_NAME_RULE.equals(this.qName)) {
                    this.checkState(this.qName, Element.RULE);
                    Rule rule = new RuleBuilder(this.qName, this.pullParser, this.ruleStack).build();
                    if (!this.ruleStack.empty() && this.isVisible(rule)) {
                        this.currentRule.addSubRule(rule);
                    }
                    this.currentRule = rule;
                    this.ruleStack.push(this.currentRule);
                    break block29;
                }
                if ("area".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    Area area = new Area(this.graphicFactory, this.displayModel, this.qName, this.pullParser, this.level++, this.relativePathPrefix);
                    if (this.isVisible(area)) {
                        this.currentRule.addRenderingInstruction(area);
                    }
                    break block29;
                }
                if ("caption".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    Caption caption = new Caption(this.graphicFactory, this.displayModel, this.qName, this.pullParser, this.symbols);
                    if (this.isVisible(caption)) {
                        this.currentRule.addRenderingInstruction(caption);
                    }
                    break block29;
                }
                if ("cat".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_STYLE);
                    this.currentLayer.addCategory(this.getStringAttribute("id"));
                    break block29;
                }
                if ("circle".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    Circle circle = new Circle(this.graphicFactory, this.displayModel, this.qName, this.pullParser, this.level++);
                    if (this.isVisible(circle)) {
                        this.currentRule.addRenderingInstruction(circle);
                    }
                    break block29;
                }
                if ("layer".equals(this.qName)) {
                    XmlRenderThemeStyleLayer parentEntry;
                    this.checkState(this.qName, Element.RENDERING_STYLE);
                    boolean enabled = false;
                    if (this.getStringAttribute("enabled") != null) {
                        enabled = Boolean.valueOf(this.getStringAttribute("enabled"));
                    }
                    boolean visible = Boolean.valueOf(this.getStringAttribute("visible"));
                    this.currentLayer = this.renderThemeStyleMenu.createLayer(this.getStringAttribute("id"), visible, enabled);
                    String parent = this.getStringAttribute("parent");
                    if (null != parent && null != (parentEntry = this.renderThemeStyleMenu.getLayer(parent))) {
                        for (String cat : parentEntry.getCategories()) {
                            this.currentLayer.addCategory(cat);
                        }
                        for (XmlRenderThemeStyleLayer overlay : parentEntry.getOverlays()) {
                            this.currentLayer.addOverlay(overlay);
                        }
                    }
                    break block29;
                }
                if ("line".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    Line line = new Line(this.graphicFactory, this.displayModel, this.qName, this.pullParser, this.level++, this.relativePathPrefix);
                    if (this.isVisible(line)) {
                        this.currentRule.addRenderingInstruction(line);
                    }
                    break block29;
                }
                if ("lineSymbol".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    LineSymbol lineSymbol = new LineSymbol(this.graphicFactory, this.displayModel, this.qName, this.pullParser, this.relativePathPrefix);
                    if (this.isVisible(lineSymbol)) {
                        this.currentRule.addRenderingInstruction(lineSymbol);
                    }
                    break block29;
                }
                if ("name".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_STYLE);
                    this.currentLayer.addTranslation(this.getStringAttribute("lang"), this.getStringAttribute("value"));
                    break block29;
                }
                if ("overlay".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_STYLE);
                    XmlRenderThemeStyleLayer overlay = this.renderThemeStyleMenu.getLayer(this.getStringAttribute("id"));
                    if (overlay != null) {
                        this.currentLayer.addOverlay(overlay);
                    }
                    break block29;
                }
                if ("pathText".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    PathText pathText = new PathText(this.graphicFactory, this.displayModel, this.qName, this.pullParser);
                    if (this.isVisible(pathText)) {
                        this.currentRule.addRenderingInstruction(pathText);
                    }
                    break block29;
                }
                if ("stylemenu".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_STYLE);
                    this.renderThemeStyleMenu = new XmlRenderThemeStyleMenu(this.getStringAttribute("id"), this.getStringAttribute("defaultlang"), this.getStringAttribute("defaultvalue"));
                    break block29;
                }
                if ("symbol".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    Symbol symbol = new Symbol(this.graphicFactory, this.displayModel, this.qName, this.pullParser, this.relativePathPrefix);
                    this.currentRule.addRenderingInstruction(symbol);
                    String symbolId = symbol.getId();
                    if (symbolId != null) {
                        this.symbols.put(symbolId, symbol);
                    }
                    break block29;
                }
                throw new XmlPullParserException("unknown element: " + this.qName);
            }
            catch (IOException e) {
                LOGGER.warning("Rendertheme missing or invalid resource " + e.getMessage());
            }
        }
    }

    private void checkElement(String elementName, Element element) throws XmlPullParserException {
        switch (element) {
            case RENDER_THEME: {
                if (!this.elementStack.empty()) {
                    throw new XmlPullParserException(UNEXPECTED_ELEMENT + elementName);
                }
                return;
            }
            case RULE: {
                Element parentElement = this.elementStack.peek();
                if (parentElement != Element.RENDER_THEME && parentElement != Element.RULE) {
                    throw new XmlPullParserException(UNEXPECTED_ELEMENT + elementName);
                }
                return;
            }
            case RENDERING_INSTRUCTION: {
                if (this.elementStack.peek() != Element.RULE) {
                    throw new XmlPullParserException(UNEXPECTED_ELEMENT + elementName);
                }
                return;
            }
            case RENDERING_STYLE: {
                return;
            }
        }
        throw new XmlPullParserException("unknown enum value: " + (Object)((Object)element));
    }

    private void checkState(String elementName, Element element) throws XmlPullParserException {
        this.checkElement(elementName, element);
        this.elementStack.push(element);
    }

    private String getStringAttribute(String name) {
        int n = this.pullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (!this.pullParser.getAttributeName(i).equals(name)) continue;
            return this.pullParser.getAttributeValue(i);
        }
        return null;
    }

    private boolean isVisible(RenderInstruction renderInstruction) {
        return this.categories == null || renderInstruction.getCategory() == null || this.categories.contains(renderInstruction.getCategory());
    }

    private boolean isVisible(Rule rule) {
        return this.categories == null || rule.cat == null || this.categories.contains(rule.cat);
    }

    private static enum Element {
        RENDER_THEME,
        RENDERING_INSTRUCTION,
        RULE,
        RENDERING_STYLE;

    }
}

