/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapsforge.core.model.Tag;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.map.rendertheme.rule.AttributeMatcher;
import org.mapsforge.map.rendertheme.rule.Closed;
import org.mapsforge.map.rendertheme.rule.ClosedMatcher;
import org.mapsforge.map.rendertheme.rule.ElementMatcher;
import org.mapsforge.map.rendertheme.rule.RuleBuilder;

abstract class Rule {
    static final Map<List<String>, AttributeMatcher> MATCHERS_CACHE_KEY = new HashMap<List<String>, AttributeMatcher>();
    static final Map<List<String>, AttributeMatcher> MATCHERS_CACHE_VALUE = new HashMap<List<String>, AttributeMatcher>();
    String cat;
    final ClosedMatcher closedMatcher;
    final ElementMatcher elementMatcher;
    final byte zoomMax;
    final byte zoomMin;
    private final ArrayList<RenderInstruction> renderInstructions;
    private final ArrayList<Rule> subRules;

    Rule(RuleBuilder ruleBuilder) {
        this.cat = ruleBuilder.cat;
        this.closedMatcher = ruleBuilder.closedMatcher;
        this.elementMatcher = ruleBuilder.elementMatcher;
        this.zoomMax = ruleBuilder.zoomMax;
        this.zoomMin = ruleBuilder.zoomMin;
        this.renderInstructions = new ArrayList(4);
        this.subRules = new ArrayList(4);
    }

    void addRenderingInstruction(RenderInstruction renderInstruction) {
        this.renderInstructions.add(renderInstruction);
    }

    void addSubRule(Rule rule) {
        this.subRules.add(rule);
    }

    void destroy() {
        for (RenderInstruction ri : this.renderInstructions) {
            ri.destroy();
        }
        for (Rule sr : this.subRules) {
            sr.destroy();
        }
    }

    abstract boolean matchesNode(List<Tag> var1, byte var2);

    abstract boolean matchesWay(List<Tag> var1, byte var2, Closed var3);

    void matchNode(RenderCallback renderCallback, RenderContext renderContext, List<RenderInstruction> matchingList, PointOfInterest pointOfInterest) {
        if (this.matchesNode(pointOfInterest.tags, renderContext.rendererJob.tile.zoomLevel)) {
            int i;
            int n = this.renderInstructions.size();
            for (i = 0; i < n; ++i) {
                this.renderInstructions.get(i).renderNode(renderCallback, renderContext, pointOfInterest);
                matchingList.add(this.renderInstructions.get(i));
            }
            n = this.subRules.size();
            for (i = 0; i < n; ++i) {
                this.subRules.get(i).matchNode(renderCallback, renderContext, matchingList, pointOfInterest);
            }
        }
    }

    void matchWay(RenderCallback renderCallback, PolylineContainer way, Tile tile, Closed closed, List<RenderInstruction> matchingList, RenderContext renderContext) {
        if (this.matchesWay(way.getTags(), tile.zoomLevel, closed)) {
            int i;
            int n = this.renderInstructions.size();
            for (i = 0; i < n; ++i) {
                this.renderInstructions.get(i).renderWay(renderCallback, renderContext, way);
                matchingList.add(this.renderInstructions.get(i));
            }
            n = this.subRules.size();
            for (i = 0; i < n; ++i) {
                this.subRules.get(i).matchWay(renderCallback, way, tile, closed, matchingList, renderContext);
            }
        }
    }

    void onComplete() {
        MATCHERS_CACHE_KEY.clear();
        MATCHERS_CACHE_VALUE.clear();
        this.renderInstructions.trimToSize();
        this.subRules.trimToSize();
        int n = this.subRules.size();
        for (int i = 0; i < n; ++i) {
            this.subRules.get(i).onComplete();
        }
    }

    void scaleStrokeWidth(float scaleFactor, byte zoomLevel) {
        int i;
        int n = this.renderInstructions.size();
        for (i = 0; i < n; ++i) {
            this.renderInstructions.get(i).scaleStrokeWidth(scaleFactor, zoomLevel);
        }
        n = this.subRules.size();
        for (i = 0; i < n; ++i) {
            this.subRules.get(i).scaleStrokeWidth(scaleFactor, zoomLevel);
        }
    }

    void scaleTextSize(float scaleFactor, byte zoomLevel) {
        int i;
        int n = this.renderInstructions.size();
        for (i = 0; i < n; ++i) {
            this.renderInstructions.get(i).scaleTextSize(scaleFactor, zoomLevel);
        }
        n = this.subRules.size();
        for (i = 0; i < n; ++i) {
            this.subRules.get(i).scaleTextSize(scaleFactor, zoomLevel);
        }
    }
}

