/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.TilePosition;

public final class LayerUtil {
    public static List<TilePosition> getTilePositions(BoundingBox boundingBox, byte zoomLevel, Point topLeftPoint, int tileSize) {
        int tileLeft = MercatorProjection.longitudeToTileX(boundingBox.minLongitude, zoomLevel);
        int tileTop = MercatorProjection.latitudeToTileY(boundingBox.maxLatitude, zoomLevel);
        int tileRight = MercatorProjection.longitudeToTileX(boundingBox.maxLongitude, zoomLevel);
        int tileBottom = MercatorProjection.latitudeToTileY(boundingBox.minLatitude, zoomLevel);
        int initialCapacity = (tileRight - tileLeft + 1) * (tileBottom - tileTop + 1);
        ArrayList<TilePosition> tilePositions = new ArrayList<TilePosition>(initialCapacity);
        for (int tileY = tileTop; tileY <= tileBottom; ++tileY) {
            for (int tileX = tileLeft; tileX <= tileRight; ++tileX) {
                double pixelX = (double)MercatorProjection.tileToPixel(tileX, tileSize) - topLeftPoint.x;
                double pixelY = (double)MercatorProjection.tileToPixel(tileY, tileSize) - topLeftPoint.y;
                tilePositions.add(new TilePosition(new Tile(tileX, tileY, zoomLevel, tileSize), new Point(pixelX, pixelY)));
            }
        }
        return tilePositions;
    }

    public static Set<Tile> getTiles(BoundingBox boundingBox, byte zoomLevel, int tileSize) {
        int tileLeft = MercatorProjection.longitudeToTileX(boundingBox.minLongitude, zoomLevel);
        int tileTop = MercatorProjection.latitudeToTileY(boundingBox.maxLatitude, zoomLevel);
        int tileRight = MercatorProjection.longitudeToTileX(boundingBox.maxLongitude, zoomLevel);
        int tileBottom = MercatorProjection.latitudeToTileY(boundingBox.minLatitude, zoomLevel);
        HashSet<Tile> tiles = new HashSet<Tile>();
        for (int tileY = tileTop; tileY <= tileBottom; ++tileY) {
            for (int tileX = tileLeft; tileX <= tileRight; ++tileX) {
                tiles.add(new Tile(tileX, tileY, zoomLevel, tileSize));
            }
        }
        return tiles;
    }

    public static List<MapElementContainer> collisionFreeOrdered(List<MapElementContainer> input) {
        Collections.sort(input, Collections.reverseOrder());
        LinkedList<MapElementContainer> output = new LinkedList<MapElementContainer>();
        for (MapElementContainer item : input) {
            boolean hasSpace = true;
            for (MapElementContainer outputElement : output) {
                if (!outputElement.clashesWith(item)) continue;
                hasSpace = false;
                break;
            }
            if (!hasSpace) continue;
            output.add(item);
        }
        return output;
    }

    private LayerUtil() {
        throw new IllegalStateException();
    }
}

