/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.util;

import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.MercatorProjection;

public final class MapPositionUtil {
    public static BoundingBox getBoundingBox(MapPosition mapPosition, Dimension canvasDimension, int tileSize) {
        long mapSize = MercatorProjection.getMapSize(mapPosition.zoomLevel, tileSize);
        double pixelX = MercatorProjection.longitudeToPixelX(mapPosition.latLong.longitude, mapSize);
        double pixelY = MercatorProjection.latitudeToPixelY(mapPosition.latLong.latitude, mapSize);
        int halfCanvasWidth = canvasDimension.width / 2;
        int halfCanvasHeight = canvasDimension.height / 2;
        double pixelXMin = Math.max(0.0, pixelX - (double)halfCanvasWidth);
        double pixelYMin = Math.max(0.0, pixelY - (double)halfCanvasHeight);
        double pixelXMax = Math.min((double)mapSize, pixelX + (double)halfCanvasWidth);
        double pixelYMax = Math.min((double)mapSize, pixelY + (double)halfCanvasHeight);
        double minLatitude = MercatorProjection.pixelYToLatitude(pixelYMax, mapSize);
        double minLongitude = MercatorProjection.pixelXToLongitude(pixelXMin, mapSize);
        double maxLatitude = MercatorProjection.pixelYToLatitude(pixelYMin, mapSize);
        double maxLongitude = MercatorProjection.pixelXToLongitude(pixelXMax, mapSize);
        return new BoundingBox(minLatitude, minLongitude, maxLatitude, maxLongitude);
    }

    public static Point getTopLeftPoint(MapPosition mapPosition, Dimension canvasDimension, int tileSize) {
        LatLong centerPoint = mapPosition.latLong;
        int halfCanvasWidth = canvasDimension.width / 2;
        int halfCanvasHeight = canvasDimension.height / 2;
        long mapSize = MercatorProjection.getMapSize(mapPosition.zoomLevel, tileSize);
        double pixelX = Math.round(MercatorProjection.longitudeToPixelX(centerPoint.longitude, mapSize));
        double pixelY = Math.round(MercatorProjection.latitudeToPixelY(centerPoint.latitude, mapSize));
        return new Point((int)pixelX - halfCanvasWidth, (int)pixelY - halfCanvasHeight);
    }

    private MapPositionUtil() {
        throw new IllegalStateException();
    }
}

