/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.util;

import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.view.MapView;

public class MapViewProjection {
    private static final String INVALID_MAP_VIEW_DIMENSIONS = "invalid MapView dimensions";
    private final MapView mapView;

    public MapViewProjection(MapView mapView) {
        this.mapView = mapView;
    }

    public LatLong fromPixels(double x, double y) {
        if (this.mapView.getWidth() <= 0 || this.mapView.getHeight() <= 0) {
            return null;
        }
        MapPosition mapPosition = this.mapView.getModel().frameBufferModel.getMapPosition();
        if (mapPosition == null) {
            return null;
        }
        LatLong latLong = mapPosition.latLong;
        long mapSize = MercatorProjection.getMapSize(mapPosition.zoomLevel, this.mapView.getModel().displayModel.getTileSize());
        double pixelX = MercatorProjection.longitudeToPixelX(latLong.longitude, mapSize);
        double pixelY = MercatorProjection.latitudeToPixelY(latLong.latitude, mapSize);
        pixelX -= (double)(this.mapView.getWidth() >> 1);
        pixelY -= (double)(this.mapView.getHeight() >> 1);
        try {
            return new LatLong(MercatorProjection.pixelYToLatitude(pixelY + y, mapSize), MercatorProjection.pixelXToLongitude(pixelX + x, mapSize));
        }
        catch (Exception e) {
            return null;
        }
    }

    public double getLatitudeSpan() {
        if (this.mapView.getWidth() > 0 && this.mapView.getHeight() > 0) {
            LatLong top = this.fromPixels(0.0, 0.0);
            LatLong bottom = this.fromPixels(0.0, this.mapView.getHeight());
            return Math.abs(top.latitude - bottom.latitude);
        }
        throw new IllegalStateException(INVALID_MAP_VIEW_DIMENSIONS);
    }

    public double getLongitudeSpan() {
        if (this.mapView.getWidth() > 0 && this.mapView.getHeight() > 0) {
            LatLong left = this.fromPixels(0.0, 0.0);
            LatLong right = this.fromPixels(this.mapView.getWidth(), 0.0);
            return Math.abs(left.longitude - right.longitude);
        }
        throw new IllegalStateException(INVALID_MAP_VIEW_DIMENSIONS);
    }

    public Point toPixels(LatLong in) {
        if (in == null || this.mapView.getWidth() <= 0 || this.mapView.getHeight() <= 0) {
            return null;
        }
        MapPosition mapPosition = this.mapView.getModel().mapViewPosition.getMapPosition();
        if (mapPosition == null) {
            return null;
        }
        LatLong latLong = mapPosition.latLong;
        long mapSize = MercatorProjection.getMapSize(mapPosition.zoomLevel, this.mapView.getModel().displayModel.getTileSize());
        double pixelX = MercatorProjection.longitudeToPixelX(latLong.longitude, mapSize);
        double pixelY = MercatorProjection.latitudeToPixelY(latLong.latitude, mapSize);
        return new Point((int)(MercatorProjection.longitudeToPixelX(in.longitude, mapSize) - (pixelX -= (double)(this.mapView.getWidth() >> 1))), (int)(MercatorProjection.latitudeToPixelY(in.latitude, mapSize) - (pixelY -= (double)(this.mapView.getHeight() >> 1))));
    }
}

