/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.util;

public abstract class PausableThread
extends Thread {
    private boolean pausing;
    private boolean shouldPause;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitPausing() {
        PausableThread pausableThread = this;
        synchronized (pausableThread) {
            while (!this.isInterrupted() && !this.isPausing()) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        PausableThread pausableThread = this;
        synchronized (pausableThread) {
            super.interrupt();
        }
    }

    public final synchronized boolean isPausing() {
        return this.pausing;
    }

    public final synchronized void pause() {
        if (!this.shouldPause) {
            this.shouldPause = true;
            this.notify();
        }
    }

    public final synchronized void proceed() {
        if (this.shouldPause) {
            this.shouldPause = false;
            this.pausing = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.setName(this.getClass().getSimpleName());
        this.setPriority(this.getThreadPriority().priority);
        while (!this.isInterrupted()) {
            PausableThread pausableThread = this;
            synchronized (pausableThread) {
                while (!(this.isInterrupted() || !this.shouldPause && this.hasWork())) {
                    try {
                        if (this.shouldPause) {
                            this.pausing = true;
                        }
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                    }
                }
            }
            if (this.isInterrupted()) break;
            try {
                this.doWork();
            }
            catch (InterruptedException e) {
                this.interrupt();
            }
        }
        this.afterRun();
    }

    protected void afterRun() {
    }

    protected abstract void doWork() throws InterruptedException;

    protected abstract ThreadPriority getThreadPriority();

    protected abstract boolean hasWork();

    protected static enum ThreadPriority {
        ABOVE_NORMAL(7),
        BELOW_NORMAL(3),
        HIGHEST(10),
        LOWEST(1),
        NORMAL(5);

        final int priority;

        private ThreadPriority(int priority) {
            if (priority < 1 || priority > 10) {
                throw new IllegalArgumentException("invalid priority: " + priority);
            }
            this.priority = priority;
        }
    }
}

