/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.view;

import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.GraphicContext;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.FrameBufferModel;

public class FrameBuffer {
    private static final boolean IS_TRANSPARENT = false;
    private Bitmap bitmap1;
    private Bitmap bitmap2;
    private Dimension dimension;
    private final DisplayModel displayModel;
    private final FrameBufferModel frameBufferModel;
    private final GraphicFactory graphicFactory;
    private final Matrix matrix;

    public FrameBuffer(FrameBufferModel frameBufferModel, DisplayModel displayModel, GraphicFactory graphicFactory) {
        this.frameBufferModel = frameBufferModel;
        this.displayModel = displayModel;
        this.graphicFactory = graphicFactory;
        this.matrix = graphicFactory.createMatrix();
    }

    public synchronized void adjustMatrix(float diffX, float diffY, float scaleFactor, Dimension mapViewDimension, float pivotDistanceX, float pivotDistanceY) {
        if (this.dimension == null) {
            return;
        }
        this.matrix.reset();
        this.centerFrameBufferToMapView(mapViewDimension);
        if (pivotDistanceX == 0.0f && pivotDistanceY == 0.0f) {
            this.matrix.translate(diffX, diffY);
        }
        this.scale(scaleFactor, pivotDistanceX, pivotDistanceY);
    }

    public synchronized void destroy() {
        this.destroyBitmaps();
    }

    public synchronized void draw(GraphicContext graphicContext) {
        graphicContext.fillColor(this.displayModel.getBackgroundColor());
        if (this.bitmap1 != null) {
            graphicContext.drawBitmap(this.bitmap1, this.matrix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameFinished(MapPosition frameMapPosition) {
        FrameBuffer frameBuffer = this;
        synchronized (frameBuffer) {
            Bitmap bitmapTemp = this.bitmap1;
            this.bitmap1 = this.bitmap2;
            this.bitmap2 = bitmapTemp;
        }
        this.frameBufferModel.setMapPosition(frameMapPosition);
    }

    public synchronized Dimension getDimension() {
        return this.dimension;
    }

    public synchronized Bitmap getDrawingBitmap() {
        if (this.bitmap2 != null) {
            this.bitmap2.setBackgroundColor(this.displayModel.getBackgroundColor());
        }
        return this.bitmap2;
    }

    public synchronized void setDimension(Dimension dimension) {
        if (this.dimension != null && this.dimension.equals(dimension)) {
            return;
        }
        this.dimension = dimension;
        this.destroyBitmaps();
        if (dimension.width > 0 && dimension.height > 0) {
            this.bitmap1 = this.graphicFactory.createBitmap(dimension.width, dimension.height, false);
            this.bitmap2 = this.graphicFactory.createBitmap(dimension.width, dimension.height, false);
        }
    }

    private void centerFrameBufferToMapView(Dimension mapViewDimension) {
        float dx = (float)(this.dimension.width - mapViewDimension.width) / -2.0f;
        float dy = (float)(this.dimension.height - mapViewDimension.height) / -2.0f;
        this.matrix.translate(dx, dy);
    }

    private void destroyBitmaps() {
        if (this.bitmap1 != null) {
            this.bitmap1.decrementRefCount();
            this.bitmap1 = null;
        }
        if (this.bitmap2 != null) {
            this.bitmap2.decrementRefCount();
            this.bitmap2 = null;
        }
    }

    private void scale(float scaleFactor, float pivotDistanceX, float pivotDistanceY) {
        if (scaleFactor != 1.0f) {
            Point center = this.dimension.getCenter();
            float pivotX = (float)((double)pivotDistanceX + center.x);
            float pivotY = (float)((double)pivotDistanceY + center.y);
            this.matrix.scale(scaleFactor, scaleFactor, pivotX, pivotY);
        }
    }
}

