/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mappacks.region_oceania;

import java.net.HttpURLConnection;
import mobac.mapsources.AbstractHttpMapSource;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.interfaces.MapSourceTextAttribution;
import mobac.program.model.TileImageType;

public class NzTopoMaps
extends AbstractHttpMapSource
implements MapSourceTextAttribution {
    private final String[] SERVERS = new String[]{"nz1"};
    private int SERVER_NUM = 0;

    public NzTopoMaps() {
        super("New Zealand Topographic Maps", 6, 15, TileImageType.PNG, HttpMapSource.TileUpdate.IfNoneMatch);
    }

    public String getTileUrl(int zoom, int x, int y) {
        int nzy = (1 << zoom) - 1 - y;
        this.SERVER_NUM = (this.SERVER_NUM + 1) % this.SERVERS.length;
        String server = this.SERVERS[this.SERVER_NUM];
        return "http://" + server + ".nztopomaps.com/" + zoom + "/" + x + "/" + nzy + ".png";
    }

    protected void prepareTileUrlConnection(HttpURLConnection conn) {
        super.prepareTileUrlConnection(conn);
        conn.addRequestProperty("Referer", "http://m.nztopomaps.com");
    }

    public String toString() {
        return "nztopomaps.com (New Zealand only)";
    }

    public String getAttributionText() {
        return "Images sourced from NZTopo database";
    }

    public String getAttributionLinkURL() {
        return "http://nztopomaps.com";
    }
}

