/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mappacks.region_america_north;

import mobac.mapsources.AbstractHttpMapSource;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.model.TileImageType;

public class CanadaToporama
extends AbstractHttpMapSource {
    private static String BASE_URL = "http://wms.ess-ws.nrcan.gc.ca/wms/toporama_en?service=wms&request=GetMap&version=1.1.1&format=image/png&srs=epsg:4326&layers=WMS-Toporama&width=256&height=256&bbox=";

    public CanadaToporama() {
        super("CanadaToporama", 2, 18, TileImageType.PNG, HttpMapSource.TileUpdate.None);
    }

    private double tile2lon(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    private double tile2lat(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    public String getTileUrl(int zoom, int x, int y) {
        double north = this.tile2lat(y, zoom);
        double south = this.tile2lat(y + 1, zoom);
        double west = this.tile2lon(x, zoom);
        double east = this.tile2lon(x + 1, zoom);
        return BASE_URL + west + "," + south + "," + east + "," + north;
    }

    public String toString() {
        return "Canada Toporama";
    }
}

