/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mappacks.openstreetmap;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import mobac.exceptions.TileException;
import mobac.mapsources.AbstractMultiLayerMapSource;
import mobac.mapsources.mappacks.openstreetmap.AbstractOsmMapSource;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageType;

public class Hikebikemap
extends AbstractMultiLayerMapSource {
    private static final String[] SERVERS = new String[]{"a", "b", "c"};
    private static int SERVER_NUM = 0;
    private static final Color BACKGROUND = new Color(180, 180, 180);

    public Hikebikemap() {
        super("OpenStreetMap Hikebikemap.de", TileImageType.PNG);
        this.mapSources = new MapSource[]{new HikebikemapBase(), new HikebikemapRelief()};
        this.initializeValues();
    }

    public Color getBackgroundColor() {
        return BACKGROUND;
    }

    public static class HikebikemapRelief
    extends AbstractOsmMapSource {
        public HikebikemapRelief() {
            super("HikebikemapRelief");
            this.maxZoom = 17;
            this.tileUpdate = HttpMapSource.TileUpdate.IfNoneMatch;
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            String server = SERVERS[SERVER_NUM];
            SERVER_NUM = (SERVER_NUM + 1) % SERVERS.length;
            return String.format("http://%s.tiles.wmflabs.org/hillshading/%d/%d/%d.png", server, zoom, tilex, tiley);
        }

        public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
            if (zoom > 16) {
                return null;
            }
            return super.getTileImage(zoom, x, y, loadMethod);
        }
    }

    public static class HikebikemapBase
    extends AbstractOsmMapSource {
        public HikebikemapBase() {
            super("HikebikemapTiles");
            this.maxZoom = 17;
            this.tileUpdate = HttpMapSource.TileUpdate.IfNoneMatch;
        }

        public String toString() {
            return "OpenStreetMap Hikebikemap Map";
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            String server = SERVERS[SERVER_NUM];
            SERVER_NUM = (SERVER_NUM + 1) % SERVERS.length;
            return String.format("http://%s.tiles.wmflabs.org/hikebike/%d/%d/%d.png", server, zoom, tilex, tiley);
        }
    }
}

