/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mappacks.openstreetmap;

import com.sixlegs.png.PngImage;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import mobac.exceptions.TileException;
import mobac.exceptions.UnrecoverableDownloadException;
import mobac.mapsources.AbstractHttpMapSource;
import mobac.mapsources.AbstractMultiLayerMapSource;
import mobac.mapsources.mappacks.openstreetmap.Mapnik;
import mobac.program.Logging;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSourceTextAttribution;
import mobac.program.model.TileImageType;
import mobac.program.tilestore.TileStore;
import mobac.utilities.Utilities;

public class OpenSeaMap
extends AbstractMultiLayerMapSource
implements MapSourceTextAttribution {
    public static final String LAYER_OPENSEA = "http://tiles.openseamap.org/seamark/";

    public OpenSeaMap() {
        super("OpenSeaMap", TileImageType.PNG);
        this.mapSources = new MapSource[]{new Mapnik(), new OpenSeaMapLayer()};
        this.initializeValues();
    }

    public String getAttributionText() {
        return "\u00a9 OpenStreetMap contributors, CC-BY-SA";
    }

    public String getAttributionLinkURL() {
        return "http://openstreetmap.org";
    }

    public static Image makeColorTransparent(Image im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public static class OpenSeaMapLayer
    extends AbstractHttpMapSource {
        public OpenSeaMapLayer() {
            super("OpenSeaMapLayer", 11, 17, TileImageType.PNG, HttpMapSource.TileUpdate.LastModified);
        }

        public String getTileUrl(int zoom, int tilex, int tiley) {
            return OpenSeaMap.LAYER_OPENSEA + zoom + "/" + tilex + "/" + tiley + ".png";
        }

        public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, InterruptedException, TileException {
            byte[] data = super.getTileData(zoom, x, y, loadMethod);
            if (data != null && data.length == 0) {
                this.log.info((Object)"loaded non-existing tile");
                return null;
            }
            return data;
        }

        public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, UnrecoverableDownloadException, InterruptedException {
            try {
                byte[] data = this.getTileData(zoom, x, y, loadMethod);
                if (data == null) {
                    return null;
                }
                PngImage png = new PngImage();
                BufferedImage image = png.read((InputStream)new ByteArrayInputStream(data), true);
                return image;
            }
            catch (FileNotFoundException e) {
                TileStore ts = TileStore.getInstance();
                ts.putTile(ts.createNewEmptyEntry(x, y, zoom), (MapSource)this);
            }
            catch (Exception e) {
                Logging.LOG.error((Object)"Unknown error in OpenSeaMap", (Throwable)e);
            }
            return null;
        }

        public Color getBackgroundColor() {
            return Utilities.COLOR_TRANSPARENT;
        }
    }
}

