/*
 * Decompiled with CFR 0.152.
 */
package net.keraj.swarm;

import java.io.File;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config {
    public static int SWARM_PERIOD = 0;
    public static boolean DEBUG = false;
    public static boolean SWARM_EVERY_NIGHT = false;
    public static boolean CREEP_EXPLODE = false;
    public static boolean ENABLE_DIGGING = true;
    public static boolean ENABLE_BUILDING = true;
    public static boolean ENABLE_SOUNDS = true;
    public static boolean SHOOT_ROCKET = true;
    public static double ROCKET_FREQUENCY = 0.05f;
    public static boolean HARD_MOBS = true;
    public static boolean KILL_MOBS_DAYTIME = true;
    public static boolean ATTACK_ANIMALS = true;
    public static boolean ENABLE_SPRINTING = true;
    static Configuration config;

    public static void preInit(File conf) {
        config = new Configuration(conf);
        Config.reload();
        config.save();
    }

    private static void removeProperty(String category, String property) {
        Property prop;
        ConfigCategory cat = config.getCategory(category);
        if (cat != null && (prop = cat.get(property)) != null) {
            cat.remove((Object)prop);
        }
    }

    public static void reload() {
        config.load();
        config.getCategory("general").setComment("");
        Config.removeProperty("general", "Always Swarm");
        Property alwaysprop = config.get("general", "Days Until Swarm", 8);
        alwaysprop.comment = "How many days until monsters begin to swarm at night. Default is 8 - which is every full moon.";
        SWARM_PERIOD = alwaysprop.getInt();
        alwaysprop = config.get("general", "Swarm Every Night", false);
        alwaysprop.comment = "If set to true - monsters will swarm every night after X days. If false - they ill swarm periodically. (every X days)";
        SWARM_EVERY_NIGHT = alwaysprop.getBoolean();
        config.renameProperty("general", "Creepers Explode", "Creepers Explode By Themselves");
        Property prop = config.get("general", "Creepers Explode By Themselves", true);
        prop.comment = "If Set to True, creepers will explode by themselves if they get bored (stay in place for too long)";
        CREEP_EXPLODE = prop.getBoolean();
        prop = config.get("general", "Enable Digging", true);
        prop.comment = "If set to True, monsters will be able to digg through walls during swarm";
        ENABLE_DIGGING = prop.getBoolean();
        prop = config.get("general", "Enable Building", true);
        prop.comment = "If set to True, monsters will be able to build bridges and staircases to get higher up";
        ENABLE_BUILDING = prop.getBoolean();
        prop = config.get("general", "Enable Sprinting", true);
        prop.comment = "If set to True, monsters will occasionally sprint when you sprint";
        ENABLE_SPRINTING = prop.getBoolean();
        prop = config.get("general", "Enable Rockets", false);
        prop.comment = "If set to True, skeletons will occasionaly shoot a rocket at you from distance (like a mortar strike)";
        SHOOT_ROCKET = prop.getBoolean();
        prop = config.get("general", "All Mobs Burn", true);
        prop.comment = "If set to True, all swarming mobs will burn in daylight. (useful to get rid of creepers after a night)";
        KILL_MOBS_DAYTIME = prop.getBoolean();
        prop = config.get("general", "Attack Animals", true);
        prop.comment = "If set to True, mobs will be occasionally aggresive towards animals.";
        ATTACK_ANIMALS = prop.getBoolean();
        prop = config.get("general", "Enable Sounds", true);
        prop.comment = "If set to True, monsters digging will play an indicating sound (this is server side config)";
        ENABLE_SOUNDS = prop.getBoolean();
    }
}

