/*
 * Decompiled with CFR 0.152.
 */
package net.keraj.swarm;

import net.keraj.swarm.SwarmDigging;
import net.keraj.swarm.SwarmWorld;
import net.keraj.util.Vec3I;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.init.Blocks;

public class SwarmDiggingOld
extends SwarmDigging {
    static final Block quicksand = Block.func_149684_b((String)"BiomesOPlenty:mud");
    static final Block web = Blocks.field_150321_G;
    private EntityCreature cr;
    private SwarmDigging.Mob mob;
    private int damage = 2;
    private boolean isStill = false;

    public SwarmDiggingOld(SwarmWorld sw) {
        super(sw);
    }

    @Override
    public void update() {
        super.update();
    }

    private final int clamp(int val) {
        return val == 0 ? 0 : (val > 0 ? 1 : -1);
    }

    public final boolean tryAttack(int x, int y, int z) {
        Block type = this.sw.world.func_147439_a(x, y, z);
        if (type == null || type == Blocks.field_150350_a) {
            return false;
        }
        if (type.func_149688_o().func_76230_c() || type == web || type == quicksand) {
            return !this.damage(x, y, z, this.damage);
        }
        return false;
    }

    void build(int x, int y, int z) {
        this.build(x, y, z, 7);
    }

    void build(int x, int y, int z, int time) {
        Block type = this.sw.world.func_147439_a(x, y, z);
        if (type != null && type.func_149688_o().func_76220_a()) {
            return;
        }
        if (type != null && type != Blocks.field_150350_a) {
            this.damage(x, y, z, this.damage);
            return;
        }
        if (!this.bridge(x, y, z, time)) {
            return;
        }
        this.mob.set(x, y, z);
        if (this.cr.field_70163_u < (double)y + 1.1) {
            this.cr.func_70634_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
        }
    }

    static final boolean isFlowing(Block type, int data) {
        return type.func_149688_o().func_76224_d() && data != 0;
    }

    public final boolean isFree(int x, int y, int z) {
        Block t = this.sw.world.func_147439_a(x, y, z);
        return !t.func_149688_o().func_76220_a() && t.func_149688_o() != Material.field_151587_i;
    }

    public final boolean isFreeorLava(int x, int y, int z) {
        Block t = this.sw.world.func_147439_a(x, y, z);
        return !t.func_149688_o().func_76220_a();
    }

    public final boolean isFreePass(int x, int y, int z) {
        Block t = this.sw.world.func_147439_a(x, y, z);
        return !t.func_149688_o().func_76230_c() && t.func_149688_o() != Material.field_151586_h;
    }

    public final boolean isDouble(int x, int y, int z) {
        Block type = this.sw.world.func_147439_a(x, y, z);
        return type instanceof BlockFence;
    }

    private boolean tryWaterDown(int x, int y, int z) {
        Block type = this.sw.world.func_147439_a(x, y, z);
        if (type.func_149688_o().func_76224_d()) {
            if (this.sw.world.func_72805_g(x, y, z) != 0) {
                this.sw.world.func_147449_b(x, y, z, Blocks.field_150350_a);
            }
            return true;
        }
        return false;
    }

    protected final boolean isFreeDouble(int x, int y, int z) {
        return this.isFreePass(x, y, z) && this.isFreePass(x, y + 1, z) && !this.isDouble(x, y - 1, z);
    }

    protected final boolean isBackway(int x, int y, int z) {
        return this.isFree(x, y, z) && this.isFree(x, y + 1, z) && this.isFree(x, y - 1, z) && !this.isFreeorLava(x, y - 2, z);
    }

    protected final boolean isBackup(int x, int y, int z) {
        return !this.isFreeorLava(x, y, z) && this.isFree(x, y + 1, z) && this.isFree(x, y + 2, z);
    }

    protected final boolean tryBuildUp(int x, int y, int z, boolean checkway) {
        if (checkway && this.isBackway(x, y, z)) {
            return false;
        }
        if (!this.isFreeDouble(x, y + 1, z)) {
            return false;
        }
        if (this.isStill) {
            this.build(x, y, z, 90);
        }
        return true;
    }

    protected final boolean tryDigUp(int x, int y, int z) {
        if (this.isBackway(x, y, z)) {
            return false;
        }
        if (this.tryAttack(x, y + 1, z)) {
            return true;
        }
        if (this.tryAttack(x, y + 2, z)) {
            return true;
        }
        if (this.isDouble(x, y, z)) {
            this.tryAttack(x, y, z);
        }
        return false;
    }

    protected final boolean tryBuildDown(int x, int y, int z) {
        if (this.isBackup(x, y, z)) {
            return false;
        }
        if (!(this.isFreePass(x, y, z) && this.isFreePass(x, y + 1, z) && this.isFreePass(x, y - 1, z))) {
            return false;
        }
        if (this.isStill) {
            this.build(x, y - 2, z);
        }
        return true;
    }

    protected final boolean tryDigDown(int x, int y, int z) {
        if (this.isBackup(x, y, z)) {
            return false;
        }
        if (this.tryAttack(x, y, z)) {
            return true;
        }
        if (this.tryAttack(x, y - 1, z)) {
            return true;
        }
        if (this.tryAttack(x, y + 1, z)) {
            return true;
        }
        return true;
    }

    @Override
    public void process(EntityCreature entity, Vec3I to) {
        int tz;
        int tx;
        this.cr = entity;
        int height = 2;
        Vec3I from = new Vec3I((Entity)this.cr);
        this.mob = this.getMob(entity);
        if (this.mob.isNear(from)) {
            ++this.mob.time;
            this.isStill = this.mob.time > 5;
        } else {
            this.mob.time = 0;
            this.mob.set(from.x, from.y, from.z);
            this.isStill = false;
        }
        int x = from.x;
        int y = from.y;
        int z = from.z;
        int dx = to.x - x;
        int dy = to.y - y;
        int dz = to.z - z;
        boolean isx = Math.abs(dx) > Math.abs(dz);
        int horizontal = Math.max(Math.abs(dx), Math.abs(dz));
        boolean nearxz = Math.abs(dx) + Math.abs(dz) < 8 && Math.abs(dx) < 5 && Math.abs(dz) < 5;
        int n = this.damage = nearxz && dy > 2 ? 3 : 2;
        if (isx) {
            tx = this.clamp(dx);
            tz = 0;
        } else {
            tx = 0;
            tz = this.clamp(dz);
        }
        Block tp = this.sw.world.func_147439_a(x, (int)entity.field_70163_u, z);
        if (tp == quicksand || tp == web) {
            this.damage(x, (int)entity.field_70163_u, z, 1);
        }
        if (height > 2 && this.tryAttack(x, y + 2, z)) {
            return;
        }
        if (height > 1 && this.tryAttack(x, y + 1, z)) {
            return;
        }
        int tox = x + tx;
        int toz = z + tz;
        if (dy > 1 && (dy > horizontal + 9 || nearxz)) {
            this.damage = 2;
            if (this.tryAttack(x, y + 2, z)) {
                return;
            }
            if (this.isDouble(x, y, z)) {
                this.tryAttack(x, y, z);
                return;
            }
            if (this.isStill && this.isFreePass(x, y - 1, z) && !this.isBackway(x, y, z)) {
                this.build(x, y - 1, z);
                return;
            }
            if (tx == tz) {
                if (Math.random() < 0.5) {
                    tx = Math.random() < 0.5 ? 1 : -1;
                } else {
                    tz = Math.random() < 0.5 ? 1 : -1;
                }
                tox = x + tx;
                toz = z + tz;
            }
            if (tx != 0) {
                if (this.tryDigUp(x + tx, y, z)) {
                    return;
                }
                if (this.tryDigUp(x, y, z + (dz > 0 ? 1 : -1))) {
                    return;
                }
                if (this.tryDigUp(x, y, z + (dz > 0 ? -1 : 1))) {
                    return;
                }
                if (dy > 4 && this.tryDigUp(x - tx, y, z)) {
                    return;
                }
            } else if (tz != 0) {
                if (this.tryDigUp(x, y, z + tz)) {
                    return;
                }
                if (this.tryDigUp(x + (dx > 0 ? 1 : -1), y, z)) {
                    return;
                }
                if (this.tryDigUp(x + (dx > 0 ? -1 : 1), y, z)) {
                    return;
                }
                if (dy > 4 && this.tryDigUp(x, y, z - tz)) {
                    return;
                }
            }
            if (this.tryAttack(tox, y + 1, toz)) {
                return;
            }
            if (this.tryAttack(tox, y + 2, toz)) {
                return;
            }
            if (this.isDouble(tox, y, toz)) {
                this.tryAttack(tox, y, toz);
                return;
            }
            if (tx != 0) {
                if (this.tryBuildUp(x + tx, y, z, true)) {
                    return;
                }
                if (this.tryBuildUp(x, y, z + (dz > 0 ? 1 : -1), false)) {
                    return;
                }
                if (this.tryBuildUp(x, y, z + (dz > 0 ? -1 : 1), false)) {
                    return;
                }
                if (this.tryBuildUp(x + tx, y, z, false)) {
                    return;
                }
                if (dy > 2 && this.tryBuildUp(x - tx, y, z, false)) {
                    return;
                }
            } else if (tz != 0) {
                if (this.tryBuildUp(x, y, z + tz, true)) {
                    return;
                }
                if (this.tryBuildUp(x + (dx > 0 ? 1 : -1), y, z, false)) {
                    return;
                }
                if (this.tryBuildUp(x + (dx > 0 ? -1 : 1), y, z, false)) {
                    return;
                }
                if (this.tryBuildUp(x, y, z + tz, false)) {
                    return;
                }
                if (dy > 2 && this.tryBuildUp(x, y, z - tz, false)) {
                    return;
                }
            } else {
                this.tryBuildUp(x, y, z, false);
            }
            if (this.isStill) {
                this.build(tox, y, toz);
            }
        } else if (dy < -1 && (-dy > horizontal + 9 || nearxz)) {
            if (this.tryAttack(x, y, z)) {
                return;
            }
            this.tryWaterDown(x, y + 1, z);
            this.tryWaterDown(x, y + 2, z);
            if (this.tryWaterDown(x, y, z)) {
                this.damage = 9;
                this.tryWaterDown(x + 1, y, z);
                this.tryWaterDown(x, y, z + 1);
                this.tryWaterDown(x - 1, y, z);
                this.tryWaterDown(x, y, z - 1);
                this.cr.field_70181_x = -1.0;
            }
            if (this.tryWaterDown(x, y - 1, z)) {
                this.damage = 9;
                this.tryWaterDown(x + 1, y - 1, z);
                this.tryWaterDown(x, y - 1, z + 1);
                this.tryWaterDown(x - 1, y - 1, z);
                this.tryWaterDown(x, y - 1, z - 1);
                this.cr.field_70181_x = -1.0;
                if (Math.random() < 0.1) {
                    this.build(x, y + 2, z);
                }
            }
            if (tx == tz) {
                if (Math.random() < 0.5) {
                    tx = Math.random() < 0.5 ? 1 : -1;
                } else {
                    tz = Math.random() < 0.5 ? 1 : -1;
                }
                tox = x + tx;
                toz = z + tz;
            }
            if (tx != 0) {
                if (this.tryDigDown(x + tx, y, z)) {
                    return;
                }
                if (this.tryDigDown(x, y, z + (dz > 0 ? 1 : -1))) {
                    return;
                }
                if (this.tryDigDown(x, y, z + (dz > 0 ? -1 : 1))) {
                    return;
                }
                if (dy < -2 && this.tryDigDown(x - tx, y, z)) {
                    return;
                }
            } else if (tz != 0) {
                if (this.tryDigDown(x, y, z + tz)) {
                    return;
                }
                if (this.tryDigDown(x + (dx > 0 ? 1 : -1), y, z)) {
                    return;
                }
                if (this.tryDigDown(x + (dx > 0 ? -1 : 1), y, z)) {
                    return;
                }
                if (dy < -2 && this.tryDigDown(x, y, z - tz)) {
                    return;
                }
            }
            if (this.tryAttack(tox, y, toz)) {
                return;
            }
            if (this.tryAttack(tox, y - 1, toz)) {
                return;
            }
            if (this.tryAttack(x, y - 1, z)) {
                return;
            }
        } else {
            if (this.isStill && this.isFreePass(x, y - 1, z) && !this.isBackway(x, y, z)) {
                this.build(x, y - 1, z);
            }
            if (this.tryAttack(x, y, z)) {
                return;
            }
            if (!this.isFree(tox, y + 1, toz) && this.isFree(tox, y + 2, toz) && this.isFree(x, y + 2, z)) {
                if (this.isStill) {
                    this.build(x, y, z);
                }
                return;
            }
            if (this.tryAttack(tox, y + 1, toz)) {
                return;
            }
            if (this.isFree(tox, y, toz) && this.isDouble(tox, y - 1, toz)) {
                this.tryAttack(tox, y - 1, toz);
                return;
            }
            if (dy < 3 && this.tryAttack(tox, y, toz)) {
                return;
            }
            if (this.tryAttack(x, y + 2, z)) {
                return;
            }
            if (this.tryAttack(tox, y + 2, toz)) {
                return;
            }
            if (!this.isFree(tox, y, toz)) {
                return;
            }
            if (!this.isFreePass(tox, y - 1, toz)) {
                return;
            }
            if (!this.isFreeorLava(tox, y - 2, toz)) {
                return;
            }
            if (!this.isFreeorLava(tox, y - 3, toz)) {
                return;
            }
            if (dy < -5) {
                if (this.isStill) {
                    this.cr.field_70159_w = (float)tx * 0.6f;
                    this.cr.field_70179_y = (float)tz * 0.6f;
                }
            } else if (this.isStill) {
                if (horizontal < 16 && Math.random() < 0.8) {
                    this.build(tox, y - 1, toz);
                } else {
                    this.cr.field_70159_w = (float)tx * 0.6f;
                    this.cr.field_70179_y = (float)tz * 0.6f;
                }
            }
        }
    }
}

