/*
 * Decompiled with CFR 0.152.
 */
package net.keraj.swarm;

import java.util.ArrayList;
import java.util.List;
import net.keraj.swarm.Config;
import net.keraj.swarm.Log;
import net.keraj.swarm.MonsterSwarm;
import net.keraj.swarm.RocketEntity;
import net.keraj.swarm.SwarmDigging;
import net.keraj.swarm.SwarmDiggingOld;
import net.keraj.swarm.target.HellSelector;
import net.keraj.swarm.target.TargetSelector;
import net.keraj.util.Kurwektoria;
import net.keraj.util.Maths;
import net.keraj.util.Vec3D;
import net.keraj.util.Vec3I;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class SwarmWorld {
    public final WorldServer world;
    final SwarmDigging digg;
    TargetSelector selector = new TargetSelector(this);
    public final List<EntityCreature> attackers = new ArrayList<EntityCreature>();
    public final List<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
    int idx = 0;
    int ticks = 0;
    public int day;
    public boolean swarming = false;
    public boolean isDay = true;
    int perfticks = 0;
    static final Vec3D vec = new Vec3D();
    final Vec3D vec1 = new Vec3D();
    final Vec3D vec2 = new Vec3D();

    public SwarmWorld(WorldServer world) {
        this.world = world;
        this.digg = new SwarmDiggingOld(this);
        if (world.field_73011_w.field_76575_d) {
            this.selector = new HellSelector(this);
        }
    }

    private void collectTargetsAttackers() {
        this.attackers.clear();
        this.targets.clear();
        block0: for (Entity ent : this.world.field_72996_f) {
            for (Class cls : MonsterSwarm.excludedAttackers) {
                if (!cls.isInstance(ent)) continue;
                continue block0;
            }
            for (Class cls : MonsterSwarm.includedAttackers) {
                if (!cls.isInstance(ent)) continue;
                this.attackers.add((EntityCreature)ent);
                break;
            }
            if (ent instanceof EntityPlayer && ((EntityPlayer)ent).field_71075_bZ.field_75098_d) continue;
            for (Class cls : MonsterSwarm.includedTargets) {
                if (!cls.isInstance(ent)) continue;
                this.targets.add((EntityLivingBase)ent);
                continue block0;
            }
        }
        this.idx = 0;
    }

    public void update() {
        ++this.ticks;
        long startTime = System.nanoTime();
        if (this.world.field_72996_f.isEmpty()) {
            return;
        }
        ++this.perfticks;
        if (this.idx >= this.attackers.size() && this.perfticks > 17) {
            this.collectTargetsAttackers();
        }
        int top = Math.min(this.idx + 2, this.attackers.size());
        while (this.idx < top) {
            Entity entity;
            EntityLivingBase target;
            Chunk czunk;
            int lajt;
            EntityCreature mob = this.attackers.get(this.idx);
            if (this.isDay && Config.KILL_MOBS_DAYTIME && (lajt = (czunk = mob.field_70170_p.func_72938_d((int)mob.field_70165_t, (int)mob.field_70161_v)).func_76614_a(EnumSkyBlock.Sky, (int)mob.field_70165_t & 0xF, (int)(mob.field_70163_u + 1.5) & 0xFF, (int)mob.field_70161_v & 0xF)) > 11) {
                mob.func_70015_d(8);
                mob.func_70097_a(DamageSource.field_76372_a, 2.0f);
            }
            EntityLivingBase entityLivingBase = target = (entity = mob.func_70777_m()) instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
            if (target == null || target instanceof EntityMob || target.field_70128_L) {
                target = this.selector.selectTarget(mob);
            } else {
                EntityLivingBase nt;
                double dx = mob.field_70165_t - target.field_70165_t;
                double dy = mob.field_70163_u - target.field_70163_u;
                double dz = mob.field_70161_v - target.field_70161_v;
                double dist2 = dx * dx + dy * dy + dz * dz;
                if (dist2 > 256.0 && (nt = this.selector.selectTarget(mob)) != null) {
                    target = nt;
                }
            }
            if (target != null) {
                if (this.swarming && Config.CREEP_EXPLODE && mob instanceof EntityCreeper) {
                    Vec3I from = new Vec3I((Entity)mob);
                    SwarmDigging.Mob m = this.digg.getMob(mob);
                    if (m.isNear(from)) {
                        ++m.time;
                        if (m.time > 20) {
                            boolean flag = mob.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                            if (((EntityCreeper)mob).func_70830_n()) {
                                mob.field_70170_p.func_72876_a((Entity)mob, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, 6.0f, flag);
                            } else {
                                mob.field_70170_p.func_72876_a((Entity)mob, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, 2.5f, flag);
                            }
                            mob.func_70106_y();
                        }
                    } else {
                        m.time = 0;
                        m.set(from.x, from.y, from.z);
                    }
                }
                mob.func_70784_b((Entity)target);
                if (target != mob.func_70638_az()) {
                    mob.func_70624_b(target);
                }
                this.vec1.set(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v);
                this.vec2.set(target.field_70165_t, target.field_70163_u + 0.5, target.field_70161_v);
                Vec3D tow = SwarmWorld.towards(this.vec1, this.vec2, 15.0f);
                boolean wasshooting = false;
                if (this.swarming) {
                    boolean digger = false;
                    for (Class cls : MonsterSwarm.includedDiggers) {
                        if (!cls.isInstance(mob)) continue;
                        digger = true;
                        break;
                    }
                    if (digger) {
                        this.digg.process(mob, new Vec3I((Entity)target));
                    }
                    if (Config.SHOOT_ROCKET) {
                        MovingObjectPosition raytrace;
                        Vec3 trg;
                        double dst;
                        double dy;
                        double dz;
                        if (mob instanceof EntityPigZombie) {
                            if (Math.random() < Config.ROCKET_FREQUENCY) {
                                double dx = mob.field_70165_t - target.field_70165_t;
                                dz = mob.field_70161_v - target.field_70161_v;
                                dy = target.field_70163_u - mob.field_70163_u;
                                dst = Maths.fastSqrt(dx * dx + dz * dz);
                                trg = tow.getMC();
                                trg.field_72448_b += dst * 0.2 + 1.0;
                                raytrace = mob.field_70170_p.func_147447_a(this.vec1.getMC().func_72441_c(0.0, (double)mob.func_70047_e(), 0.0), trg, false, true, false);
                                if (raytrace == null) {
                                    Vec3D out = new Vec3D();
                                    boolean result = Kurwektoria.calculateTrajectory(new Vec3D(target.field_70165_t - mob.field_70165_t, target.field_70163_u + (double)target.func_70047_e() - mob.field_70163_u - (double)mob.func_70047_e(), target.field_70161_v - mob.field_70161_v), 1.5f, 0.01f, false, out);
                                    if (result) {
                                        RocketEntity shot = new RocketEntity(mob.field_70170_p, (EntityLivingBase)mob);
                                        shot.explosion = 4.0f;
                                        shot.func_70186_c(out.x, out.y, out.z, 1.5f, 20.0f);
                                        mob.field_70170_p.func_72838_d((Entity)shot);
                                        mob.field_70170_p.func_72956_a((Entity)mob, "fireworks.launch", 1.0f, 0.5f);
                                    }
                                }
                            }
                        } else if ((mob instanceof EntitySkeleton || mob instanceof EntityCreeper) && Math.random() < Config.ROCKET_FREQUENCY && (target instanceof EntityPlayer || target instanceof EntityVillager)) {
                            double dx = mob.field_70165_t - target.field_70165_t;
                            dz = mob.field_70161_v - target.field_70161_v;
                            dy = target.field_70163_u - mob.field_70163_u;
                            dst = Maths.fastSqrt(dx * dx + dz * dz);
                            if ((dst > 20.0 || Math.abs(dy) > 20.0) && dst < 100.0) {
                                trg = tow.getMC();
                                trg.field_72448_b += dst * 0.4 + 1.0;
                                raytrace = mob.field_70170_p.func_147447_a(this.vec1.getMC().func_72441_c(0.0, (double)mob.func_70047_e(), 0.0), trg, false, true, false);
                                if (raytrace == null) {
                                    float speed = dy > 50.0 ? 2.2f : 1.5f;
                                    Vec3D out = new Vec3D();
                                    boolean result = Kurwektoria.calculateTrajectory(new Vec3D(target.field_70165_t - mob.field_70165_t, target.field_70163_u + (double)target.func_70047_e() - mob.field_70163_u + (double)mob.func_70047_e(), target.field_70161_v - mob.field_70161_v), speed, 0.01f, dst > 50.0, out);
                                    if (result) {
                                        wasshooting = true;
                                        RocketEntity shot = new RocketEntity(mob.field_70170_p, (EntityLivingBase)mob);
                                        shot.explosion = dst < 50.0 ? 2.5f : 1.8f;
                                        shot.func_70186_c(out.x, out.y, out.z, speed, 14.0f);
                                        mob.field_70170_p.func_72838_d((Entity)shot);
                                        mob.field_70170_p.func_72956_a((Entity)mob, "fireworks.launch", 1.0f, 0.5f);
                                    }
                                }
                            }
                        }
                    }
                }
                if (!wasshooting) {
                    if (mob instanceof EntityZombie && !(mob instanceof EntityPigZombie) || mob instanceof EntitySkeleton || mob instanceof EntityCreeper) {
                        mob.func_70661_as().func_75492_a(tow.x, tow.y, tow.z, target.func_70051_ag() && Config.ENABLE_SPRINTING ? (double)2.6f : 1.0);
                    } else {
                        PathEntity path = this.world.func_72844_a((Entity)mob, (int)tow.x, (int)tow.y, (int)tow.z, 18.0f, true, false, false, true);
                        mob.func_70778_a(path);
                    }
                }
                if (mob.field_70170_p.func_147439_a((int)mob.field_70165_t, (int)mob.field_70163_u, (int)mob.field_70161_v).func_149688_o().func_76224_d()) {
                    Vec3D vec = new Vec3D((Entity)target).sub((Entity)mob).normalize().scale(0.4);
                    mob.field_70159_w = vec.x;
                    mob.field_70181_x = vec.y;
                    mob.field_70179_y = vec.z;
                }
            }
            ++this.idx;
        }
        if (this.ticks > 15) {
            this.ticks = 0;
            if (this.world.field_73011_w.field_76576_e) {
                this.isDay = false;
            } else {
                this.day = (int)(this.world.func_72820_D() / 24000L) + 1;
                int time = (int)this.world.func_72820_D() % 24000;
                this.isDay = time < 12300 || time > 23850;
                boolean oldswarming = this.swarming;
                boolean bl = this.swarming = this.day > Config.SWARM_PERIOD && !this.isDay && (Config.SWARM_EVERY_NIGHT || this.day % Config.SWARM_PERIOD == 1);
                if (Config.DEBUG && oldswarming != this.swarming) {
                    System.out.println("Swarming: " + this.swarming);
                }
            }
            this.selector.updateRadius();
            this.digg.update();
        }
        if (Config.DEBUG) {
            long endTime = System.nanoTime();
            float ms = (float)((endTime - startTime) / 100000L) / 10.0f;
            Log.println("ticking took: " + ms + "ms with " + this.attackers.size() + " mobs, swarming: " + this.swarming);
            ++this.perfticks;
        }
    }

    public static final Vec3D towards(Vec3D from, Vec3D to, float dist) {
        SwarmWorld.vec.x = to.x - from.x;
        SwarmWorld.vec.y = to.y - from.y;
        SwarmWorld.vec.z = to.z - from.z;
        double len = vec.length();
        if (len < (double)dist) {
            vec.set(to.x, to.y, to.z);
        } else {
            vec.set(SwarmWorld.vec.x / len, SwarmWorld.vec.y / len, SwarmWorld.vec.z / len);
            vec.scale(dist);
            SwarmWorld.vec.x += from.x;
            SwarmWorld.vec.y += from.y;
            SwarmWorld.vec.z += from.z;
        }
        return vec;
    }
}

