/*
 * Decompiled with CFR 0.152.
 */
package net.keraj.swarm.target;

import java.util.List;
import net.keraj.swarm.SwarmWorld;
import net.keraj.util.Maths;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;

public class TargetSelector {
    public int radius = 80;
    SwarmWorld sw;

    public TargetSelector(SwarmWorld sw) {
        this.sw = sw;
    }

    public static final boolean contains(AxisAlignedBB aabb, Entity ent) {
        return ent.field_70165_t >= aabb.field_72340_a && ent.field_70165_t <= aabb.field_72336_d && ent.field_70163_u >= aabb.field_72338_b && ent.field_70163_u <= aabb.field_72337_e && ent.field_70161_v >= aabb.field_72339_c && ent.field_70161_v <= aabb.field_72334_f;
    }

    public EntityLivingBase selectTarget(EntityCreature attacker) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(attacker.field_70165_t - (double)this.radius), (double)(attacker.field_70163_u - (double)this.radius - (double)this.radius), (double)(attacker.field_70161_v - (double)this.radius), (double)(attacker.field_70165_t + (double)this.radius), (double)(attacker.field_70163_u + (double)this.radius + (double)this.radius), (double)(attacker.field_70161_v + (double)this.radius));
        List<EntityLivingBase> ents = this.sw.targets;
        EntityLivingBase nearest = null;
        double ndist2 = Double.POSITIVE_INFINITY;
        for (EntityLivingBase ent : ents) {
            if (!ent.func_70089_S() || !TargetSelector.contains(aabb, (Entity)ent)) continue;
            double dx = attacker.field_70165_t - ent.field_70165_t;
            double dy = attacker.field_70163_u - ent.field_70163_u;
            double dz = attacker.field_70161_v - ent.field_70161_v;
            double hdist2 = dx * dx + dz * dz;
            double dist2 = hdist2 + dy * dy;
            if (ent instanceof EntityGolem && dist2 > 576.0) continue;
            if (!(ent instanceof EntityPlayer)) {
                dist2 += dist2;
            }
            if (!(dist2 < ndist2) || !this.canAttack(attacker, ent, Maths.fastSqrt(hdist2), Math.abs(dy))) continue;
            nearest = ent;
            ndist2 = dist2;
        }
        return nearest;
    }

    public boolean canAttack(EntityCreature mob, EntityLivingBase ent, double hdist, double ydist) {
        if (hdist < 20.0 && ydist < 10.0) {
            return true;
        }
        if (hdist < 30.0 && ydist < 5.0) {
            return true;
        }
        if (this.sw.swarming) {
            if (ent.field_70163_u > 50.0) {
                return mob.field_70163_u > 59.0;
            }
            if (ent.field_70163_u < 30.0) {
                return mob.field_70163_u < 64.0;
            }
            return ydist < 20.0;
        }
        if (ent.field_70163_u < 30.0) {
            return mob.field_70163_u < 60.0 && hdist < 70.0;
        }
        return false;
    }

    public void updateRadius() {
        this.radius = this.sw.swarming ? 160 : 70;
    }
}

