/*
 * Decompiled with CFR 0.152.
 */
package net.keraj.util;

import net.keraj.util.Vec3D;
import net.keraj.util.vec2;

public class Kurwektoria {
    public static boolean calculateTrajectory(Vec3D diff, float speed, float gravity, boolean useHighArc, Vec3D out) {
        boolean canHit = false;
        double term1 = 0.0;
        double term2 = 0.0;
        double root = 0.0;
        float xzlen = (float)Math.sqrt(diff.x * diff.x + diff.z * diff.z);
        vec2 horz = new vec2(xzlen, 0.0f);
        float factor = 100.0f;
        float x = horz.x / 100.0f;
        float y = (float)(diff.y / 100.0);
        float v = speed / 100.0f;
        float g = gravity / 100.0f;
        term1 = Math.pow(v, 4.0) - (double)g * ((double)g * Math.pow(x, 2.0) + (double)(2.0f * y) * Math.pow(v, 2.0));
        if (term1 >= 0.0) {
            canHit = true;
            term2 = Math.sqrt(term1);
            double divisor = g * x;
            if (divisor != 0.0) {
                root = useHighArc ? (Math.pow(v, 2.0) + term2) / divisor : (Math.pow(v, 2.0) - term2) / divisor;
                root = Math.atan(root);
                horz.rotate((float)root);
            }
            float faktor = horz.x / xzlen;
            out.set(diff.x * (double)faktor, horz.y, diff.z * (double)faktor).normalize().scale(speed);
        }
        return canHit;
    }
}

