/*
 * Decompiled with CFR 0.152.
 */
package net.keraj.util;

import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.keraj.util.ImageFrame;
import net.keraj.util.Kurwektoria;
import net.keraj.util.Vec3D;
import net.keraj.util.vec2;

public class Trajectory {
    BufferedImage image = new BufferedImage(800, 600, 2);
    ImageFrame frame = new ImageFrame(this.image);
    Graphics2D g = this.image.createGraphics();
    float scale = 2.0f;
    float mousex;
    float mousey;
    private MouseMotionListener mouser = new MouseAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            Trajectory.this.mousex = (float)e.getX() / Trajectory.this.scale;
            Trajectory.this.mousey = (float)e.getY() / -Trajectory.this.scale + 300.0f;
        }
    };
    List<Projectile> bullets = new ArrayList<Projectile>();
    int timer = 0;
    private String dista = "hehe";

    private Trajectory() {
        this.frame.getContentPane().addMouseMotionListener(this.mouser);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public void run() throws Exception {
        while (true) {
            Projectile p;
            this.g.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
            AffineTransform trans = this.g.getTransform();
            this.g.translate(0, 600);
            this.g.scale(this.scale, -this.scale);
            Iterator<Projectile> iter = this.bullets.iterator();
            while (iter.hasNext()) {
                p = iter.next();
                p.update();
                this.g.drawLine((int)p.lx, (int)p.ly, (int)p.x, (int)p.y);
                if (!p.dead) continue;
                iter.remove();
            }
            this.g.fillOval((int)this.mousex - 2, (int)this.mousey - 2, 4, 4);
            if (++this.timer > 15) {
                this.timer = 0;
                p = new Projectile();
                p.lx = 10.0f;
                p.x = 10.0f;
                p.ly = 10.0f;
                p.y = 10.0f;
                this.dista = "dist x : " + (this.mousex - p.x);
                Vec3D out = new Vec3D();
                boolean res = Kurwektoria.calculateTrajectory(new Vec3D(this.mousex - p.x, this.mousey - p.y, this.mousex - p.x), 1.5f, 0.01f, true, out);
                if (res) {
                    p.setVelocity(out);
                    this.bullets.add(p);
                }
            }
            this.g.setTransform(trans);
            this.g.drawString(this.dista, 10, 30);
            this.frame.repaint();
            Thread.sleep(8L);
        }
    }

    public static void main(String[] args) throws Exception {
        new Trajectory().run();
    }

    class Projectile {
        public boolean dead = false;
        float x;
        float y;
        float vx;
        float vy;
        float lx;
        float ly;

        Projectile() {
        }

        public void update() {
            this.lx = this.x;
            this.ly = this.y;
            this.x += this.vx;
            this.y += this.vy;
            this.vy -= 0.01f;
            if (this.x < 0.0f || this.x > 400.0f) {
                this.dead = true;
            } else if (this.y < 0.0f || this.y > 300.0f) {
                this.dead = true;
            }
        }

        public void setHeading(float x, float y, float speed) {
            float f2 = (float)Math.sqrt(x * x + y * y);
            x /= f2;
            y /= f2;
            this.vx = x *= speed;
            this.vy = y *= speed;
        }

        public void setVelocity(Vec3D vec3d) {
            this.vx = (float)vec3d.x;
            this.vy = (float)vec3d.y;
        }

        private float gfactor(float dist, float dy) {
            return dist * dist * 0.002f - (dy < 0.0f ? (float)Math.sqrt(dy * dist) * 1.0f : 0.0f);
        }

        private vec2 getPos() {
            return new vec2(this.x, this.y);
        }

        public void setHeadingTowards(float tx, float ty, float speed) {
            vec2 vec = new vec2();
            this.setHeading(vec.x, vec.y, speed);
        }
    }
}

