/*
 * Decompiled with CFR 0.152.
 */
package net.keraj.util;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class Vec3I {
    public int x;
    public int y;
    public int z;

    public Vec3I() {
    }

    public Vec3I(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3I(Entity ent) {
        this.x = (int)ent.field_70165_t;
        this.y = (int)(ent.field_70163_u + 0.2);
        this.z = (int)ent.field_70161_v;
    }

    public Block getBlock(World w) {
        return w.func_147439_a(this.x, this.y, this.z);
    }

    public int getData(World w) {
        return w.func_72805_g(this.x, this.y, this.z);
    }

    public int getLightSky(World w) {
        Chunk czunk = w.func_72938_d(this.x, this.z);
        return czunk.func_76614_a(EnumSkyBlock.Sky, this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    public int getLightBlocks(World w) {
        Chunk czunk = w.func_72938_d(this.x, this.z);
        return czunk.func_76614_a(EnumSkyBlock.Block, this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    public Vec3I set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vec3I set(Vec3I that) {
        this.x = that.x;
        this.y = that.y;
        this.z = that.z;
        return this;
    }

    public double length() {
        return MathHelper.func_76133_a((double)(this.x * this.x + this.y * this.y + this.z * this.z));
    }

    public Vec3I scale(double scalar) {
        this.x = (int)((double)this.x * scalar);
        this.y = (int)((double)this.y * scalar);
        this.z = (int)((double)this.z * scalar);
        return this;
    }

    public Vec3I getRelative(int x, int y, int z) {
        return new Vec3I(this.x + x, this.y + y, this.z + z);
    }

    public void setBlock(World w, Block type, int data) {
        w.func_147465_d(this.x, this.y, this.z, type, data, 3);
    }

    public int hashCode() {
        return this.x ^ this.y << 14 ^ this.z << 20;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vec3I) {
            Vec3I that = (Vec3I)obj;
            return this.x == that.x && this.y == that.y && this.z == that.z;
        }
        return false;
    }

    public boolean equals(Vec3I that) {
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }
}

