/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class FileReader {
    URL url;
    URLConnection urlConn;
    FileInputStream file;
    BufferedReader fin;
    String fileName;
    String line = "";
    String customSpacer = " ";
    StringTokenizer standardToken;
    StringTokenizer customToken;
    Vector lines;
    int currentLine = 0;
    boolean online = false;
    boolean validFile = true;

    public FileReader(String theFile, boolean onServer) throws IOException {
        this.lines = new Vector();
        this.fileName = theFile;
        this.online = onServer;
        if (onServer) {
            this.serverInit();
        } else if (theFile.compareTo("JARinit") == 0) {
            this.fileName = "init.dat";
            this.JARinit();
        } else {
            this.HDinit();
        }
    }

    public FileReader() {
        this.lines = new Vector();
    }

    public FileReader(boolean JAR, String theFile) throws IOException {
        if (JAR) {
            this.fileName = theFile;
            this.online = false;
            this.JARinit();
        } else {
            this.cout("incorrect constructor use of FileReader for: " + theFile);
        }
    }

    public FileReader(String customParseLine) {
        this.setupCustomStringParse(customParseLine);
    }

    void serverInit() throws IOException {
        this.fileName = this.fileName;
        this.url = new URL(this.fileName);
        this.urlConn = this.url.openConnection();
        this.urlConn.setDoInput(true);
        this.urlConn.setUseCaches(false);
        this.fin = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
    }

    void HDinit() throws IOException {
        try {
            this.file = new FileInputStream(this.fileName);
            this.fin = new BufferedReader(new InputStreamReader(this.file));
            this.lines = new Vector();
            this.loadVector();
        }
        catch (IOException e) {
            this.validFile = false;
        }
    }

    void JARinit() throws IOException {
        this.fin = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.fileName)));
        this.lines = new Vector();
        this.line = "";
        this.loadVector();
    }

    void setCustomTokenSpacer(String spacer) {
        this.customSpacer = spacer;
    }

    void printLines() {
        for (int i = 0; i < this.lines.size(); ++i) {
            this.cout((String)this.lines.elementAt(i));
        }
    }

    String lastToken() {
        String last = "";
        while (this.hasMoreTokens()) {
            last = this.nextToken();
        }
        return last;
    }

    boolean hasMoreLines() {
        return this.currentLine < this.lines.size() - 1;
    }

    static String getStackTrace(Exception e) {
        String trace = "\n";
        StackTraceElement[] stack = e.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            trace = trace + "\n" + stack[i];
        }
        return trace;
    }

    void vectorRead() {
        try {
            this.line = this.fin.readLine();
            this.lines.add(this.line);
        }
        catch (IOException error) {
            JOptionPane.showMessageDialog(null, "File IO Error", "File IO Error reading file '" + this.fileName + "':" + FileReader.getStackTrace(error), 0);
        }
    }

    void setupCustomStringParse(String newLine) {
        this.line = newLine;
        if (this.line != null) {
            this.standardToken = new StringTokenizer(this.line, " ");
            this.customToken = new StringTokenizer(this.line, this.customSpacer);
        }
    }

    void setupCustomStringParse(String newLine, String customSpacing) {
        this.line = newLine;
        if (this.line != null) {
            this.standardToken = new StringTokenizer(this.line, " ");
            this.customToken = new StringTokenizer(this.line, customSpacing);
        }
    }

    String readNextLine() {
        if (this.currentLine < this.lines.size()) {
            this.line = (String)this.lines.elementAt(this.currentLine);
            ++this.currentLine;
        } else {
            this.line = null;
        }
        if (this.line != null) {
            this.standardToken = new StringTokenizer(this.line, " ");
            this.customToken = new StringTokenizer(this.line, this.customSpacer);
        }
        return this.line;
    }

    void loadVector() {
        while (this.line != null) {
            this.vectorRead();
        }
    }

    void cout(String goo) {
        System.out.println(goo);
    }

    boolean hasMoreCustomTokens() {
        return this.customToken.hasMoreTokens();
    }

    boolean hasMoreTokens() {
        return this.standardToken.hasMoreTokens();
    }

    String nextToken() {
        return this.standardToken.nextToken();
    }

    String nextTokenCustom() {
        return this.customToken.nextToken();
    }

    static boolean containsSubstring(String bigString, String sub_String) {
        if (bigString == null || sub_String == null || bigString.length() <= 0 || sub_String.length() <= 0) {
            return false;
        }
        char[] string = bigString.toLowerCase().toCharArray();
        char[] subString = sub_String.toLowerCase().toCharArray();
        int passedChars = 0;
        boolean lastOK = false;
        boolean passed = false;
        for (int i = 0; i < bigString.length(); ++i) {
            if (string[i] == subString[passedChars]) {
                lastOK = true;
                if (++passedChars != subString.length) continue;
                passed = true;
                i = bigString.length();
                continue;
            }
            lastOK = false;
            passedChars = 0;
        }
        return passed;
    }

    static String removeSubstring(String bigString, String sub_String) {
        if (bigString == null || sub_String == null || bigString.length() <= 0 || sub_String.length() <= 0) {
            return bigString;
        }
        char[] string = bigString.toLowerCase().toCharArray();
        char[] subString = sub_String.toLowerCase().toCharArray();
        int passedChars = 0;
        int begin = 0;
        int end = 0;
        boolean lastOK = false;
        boolean passed = false;
        for (int i = 0; i < bigString.length(); ++i) {
            if (string[i] == subString[passedChars]) {
                if (passedChars == 0) {
                    begin = i;
                }
                lastOK = true;
                if (++passedChars != subString.length) continue;
                passed = true;
                end = i;
                i = bigString.length();
                continue;
            }
            lastOK = false;
            passedChars = 0;
        }
        char[] newString = new char[bigString.length() - (end - begin) - 1];
        int curr = 0;
        if (passed) {
            for (int i = 0; i < bigString.length(); ++i) {
                if (i >= begin && i <= end) continue;
                newString[curr] = string[i];
                ++curr;
            }
        } else {
            newString = string;
        }
        return String.valueOf(newString);
    }

    void skipTokens(int num, boolean standardTokenSpacing) {
        for (int i = 0; i < num; ++i) {
            if (standardTokenSpacing) {
                this.standardToken.nextToken();
                continue;
            }
            this.customToken.nextToken();
        }
    }

    void closeFile() {
        try {
            this.file.close();
        }
        catch (IOException error) {
            JOptionPane.showMessageDialog(null, "File Close Error", "File IO Error closing file '" + this.fileName + "':" + FileReader.getStackTrace(error), 0);
        }
    }

    void reloadTokens() {
        this.standardToken = new StringTokenizer(this.line, " ");
        this.customToken = new StringTokenizer(this.line, this.customSpacer);
    }

    void startOver() {
        this.currentLine = 0;
        this.line = null;
    }

    boolean lineIsNotNull() {
        return this.line != null;
    }
}

