/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class MovieFinder {
    static String updateURL = "http://www.moviefinderonline.com/downloads/java_versions.txt";
    static boolean makeMacDockIcon = true;

    public static void main(String[] args) {
        try {
            if (System.getProperty("os.name").startsWith("Mac") && args.length == 0 && makeMacDockIcon) {
                MovieFinder.runMacShell();
            } else {
                new MovieFinder();
            }
        }
        catch (Exception e) {
            new TextAlert(null, "MovieFinder Initialization Failed", "An unexpected exception was encountered:\n\n" + MovieFinder.getStackTrace(e), "OK", "null", 450, 300);
        }
        catch (Error f) {
            new TextAlert(null, "MovieFinder Initialization Failed", "An unexpected error was encountered:\n\n" + MovieFinder.getStackTrace(f), "OK", "null", 450, 300);
        }
    }

    public MovieFinder() {
        String loadError = "http://www.moviefinderonline.com/load_error.html";
        try {
            File graphics;
            File alias;
            String className = "MovieList";
            String[] mainArgs = new String[]{className};
            Class<?> cls = Class.forName(className);
            File substance = new File("substance.jar");
            if (substance.exists()) {
                substance.delete();
            }
            if ((alias = new File("MovieFinderAlias.zip")).exists()) {
                alias.delete();
            }
            if ((graphics = new File("MFgraphics.lib")).exists()) {
                graphics.delete();
            }
            boolean iconFileExists = true;
            if (System.getProperty("os.name").startsWith("Mac")) {
                File icon = new File(".MovieFinderMac.icns");
                iconFileExists = icon.exists();
            }
            if (!iconFileExists && makeMacDockIcon) {
                this.extractMacIcon();
            } else {
                try {
                    Method m = cls.getMethod("main", String[].class);
                    System.out.println("\nLaunching MovieFinder");
                    m.invoke(null, new Object[]{mainArgs});
                }
                catch (InvocationTargetException i) {
                    String err = "new MovieFinder(), caught invocation exception";
                    System.err.println(err);
                    this.initLF();
                    MovieFinder.updateJava(i, err);
                }
            }
        }
        catch (NoClassDefFoundError n) {
            this.initLF();
            String err = "new MovieFinder(), caught NoClassDefFoundError";
            System.err.println(err);
            MovieFinder.updateJava(n, err);
        }
        catch (UnsupportedClassVersionError e) {
            String err = "new MovieFinder(), caught unsupported class";
            System.err.println(err);
            this.initLF();
            MovieFinder.updateJava(e, err);
        }
        catch (Exception e) {
            this.initLF();
            JFrame frame = MovieFinder.makeFrame("MovieFinder Load Error");
            TextAlert t = new TextAlert(frame, frame.getTitle(), " MovieFinder has encountered a load error (specific error information below).\n\n If the problem persists, try looking for a solution at www.MovieFinderOnline.com.\n\n\n Would you like to visit www.MovieFinderOnline.com for help?\n\n\n" + MovieFinder.getStackTrace(e), "Go to www.MovieFinderOnline.com", "No Thanks", 550, 450);
            frame.dispose();
            int i = t.buttonSelected;
            if (i == 0) {
                MovieFinder.showInBrowser(loadError);
            }
            System.exit(0);
        }
    }

    public void extractMacIcon() {
        try {
            String macIcon = ".MovieFinderMac.icns";
            File macFile = new File(macIcon);
            macFile.delete();
            File fileDest = new File(macIcon);
            FileOutputStream output = new FileOutputStream(fileDest);
            output = new FileOutputStream(macIcon);
            InputStream stream = this.getClass().getResourceAsStream(macIcon);
            byte[] b = new byte[1000];
            int v = 0;
            while ((v = stream.read(b)) > -1) {
                output.write(b, 0, v);
            }
            stream.close();
            output.flush();
            output.close();
            MovieFinder.cout("extracted '" + macIcon + "'");
        }
        catch (IOException i) {
            String vistaWarn = "\n\n Note that in Windows Vista and Windows 7, 'User Account Control' can prevent proper system-wide MovieFinder operation. \n\n You can disable it from the control panel.\n ";
            if (System.getProperty("os.name").indexOf("Vista") < 0 && System.getProperty("os.name").indexOf("Windows 7") < 0) {
                vistaWarn = "";
            }
            i.printStackTrace();
            MovieFinder.popUpAlert("MovieFinder Initialization Failed", "MovieFinder failed to extract it's internal files." + vistaWarn + MovieFinder.getStackTrace(i) + "\n\n Email support@MovieFinderOnline.com for help regarding this matter.");
        }
    }

    static void runMacShell() {
        Runtime rt = Runtime.getRuntime();
        boolean runAgain = !new File(".script.sh").exists();
        FilesFilter filter = new FilesFilter(new File("").getAbsolutePath());
        filter.addFileType("jar");
        filter.filterFiles();
        filter.printFilteredFiles();
        filter.removeFile("UnInstall_MovieFinder.jar");
        filter.removeFile("MF_ExportPlugin.jar");
        filter.removeFile(".MF_ExportPlugin.jar");
        filter.printFilteredFiles();
        if (new File("MovieFinder.jar").exists() && filter.passed.size() == 1) {
            try {
                BufferedWriter outFile = new BufferedWriter(new FileWriter(".script.sh", false));
                outFile.write("java -Xdock:name=\"MovieFinder\" -Xdock:icon=\".MovieFinderMac.icns\" -jar MovieFinder.jar args");
                outFile.close();
                MovieFinder.cout("wrote shell script, executing...");
                String[] cmd = new String[]{"sh", ".script.sh"};
                rt.exec(cmd);
                if (runAgain) {
                    rt.exec(cmd);
                }
            }
            catch (Exception e) {
                MovieFinder.cout("failed to init dock icon");
                JOptionPane.showMessageDialog(null, "\n\n  MovieFinder failed to initialize the dock icon properly.\n\n Now exiting.", "MovieFinder Script Error", 0);
            }
            System.exit(0);
        } else {
            Object[] options = new Object[]{" Just open the file I clicked on ", "Exit; I want to fix this"};
            int choice = MovieFinder.popUpQuestion("Mac OS X Note", "Please do not rename MovieFinder.jar on Mac OS X. It must be named exactly \"MovieFinder.jar\" \n or the program will not run and/or the dock icon will not display properly.\n\n Additionally, if multiple .jar files are found in the program folder, *only MovieFinder.jar will be run*,\n even if you clicked on 'MovieFinder-1.jar' or something equivalent!", options);
            if (choice == 0) {
                new MovieList(true);
            } else {
                System.exit(0);
            }
        }
    }

    static void popUpAlert(String frame, String message) {
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        Point p = new Point((int)resolution.getWidth() / 2, (int)resolution.getHeight() / 2);
        JFrame window = new JFrame("MovieFinder Error");
        window.setLocation(p);
        window.setVisible(true);
        JOptionPane.showMessageDialog(window, "\n\n " + message + "\n\n", frame, 1);
        window.dispose();
    }

    static int popUpQuestion(String frame, String message, Object[] options) {
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        Point p = new Point((int)resolution.getWidth() / 2, (int)resolution.getHeight() / 2);
        JFrame window = new JFrame("MovieFinder Error");
        window.setLocation(p);
        window.setVisible(true);
        int choice = JOptionPane.showOptionDialog(window, "\n\n " + message + "\n\n", frame, 0, 3, null, options, options[0]);
        window.dispose();
        return choice;
    }

    void initLF() {
        if (System.getProperty("os.name").startsWith("Win") || System.getProperty("os.name").startsWith("Mac")) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception t) {
                System.err.println("Failed to init System Look and Feel.");
            }
        }
    }

    static void updateJava(Error e, String cause) {
        MovieFinder.updateJavaForReal(MovieFinder.getStackTrace(e), cause);
    }

    static void updateJava(Exception e, String cause) {
        MovieFinder.updateJavaForReal(MovieFinder.getStackTrace(e), cause);
    }

    static void updateJavaForReal(String stackTrace, String cause) {
        JFrame frame = MovieFinder.makeFrame("MovieFinder Load Error");
        boolean mac = false;
        boolean win = false;
        boolean otherOS = false;
        String text = " \"" + cause + "\"" + "\n\n MovieFinder has failed to load it's required java .class files." + "\n\n Either this is a build error (a bug), your MovieFinder file(s) are corrupt, or the version of Java you are using is not compatible with MovieFinder." + "\n\n Usually, updating Java (Java SE 6 or greater) will fix the problem.\n";
        int i = -1;
        if (System.getProperty("os.name").startsWith("Mac") || System.getProperty("os.name").startsWith("mac")) {
            mac = true;
            text = text + "\n\n\n MAC USERS using OS X 10.5 or below will receive this error if Java SE 6 is not set as the system defualt.\n\n ( View settings in Applications-->Utilities-->Java Preferences ) \n\n\n What would you like to do?\n\n\n";
        } else if (System.getProperty("os.name").startsWith("Win") || System.getProperty("os.name").startsWith("win")) {
            win = true;
            text = text + "\n\n\n What would you like to do?\n\n";
        } else {
            otherOS = true;
            text = text + "\n\n As a Linux/Unix user, you may also need to specify which version of Java is set as the default. \n\n If you choose to update, you will be shown installation instructions with a link for you to \n download the latest Java version and set it as your computer's default.\n\n\n What would you like to do?\n\n";
        }
        TextAlert alert = new TextAlert(frame, "MovieFinder Load Error", text + "\n               ----- ERROR DETAILS -----\n\n Using Java version " + Double.parseDouble(System.getProperty("java.specification.version")) + ", An unexpected exception was encountered:\n" + stackTrace, "  Download the Java Update  ", "  Contact MovieFinder Support  ", 650, 550);
        if (alert.getButton() == 0) {
            if (mac) {
                MovieFinder.showInBrowser("http://www.moviefinderonline.com/installing_moviefinder.html#Mac");
            } else if (otherOS) {
                MovieFinder.showInBrowser("http://www.moviefinderonline.com/installing_moviefinder.html#OtherOS");
            }
            MovieFinder.showInBrowser("http://www.java.com/en/download/manual.jsp");
        } else {
            MovieFinder.showInBrowser("http://www.moviefinderonline.com/load_error.html");
        }
        System.exit(0);
    }

    static String getStackTrace(Exception e) {
        String trace = "\n" + e.getMessage() + "\n";
        StackTraceElement[] stack = e.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            trace = trace + "\n" + stack[i];
        }
        return trace;
    }

    static String getStackTrace(Error e) {
        String trace = "\n" + e.getMessage() + "\n";
        StackTraceElement[] stack = e.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            trace = trace + "\n" + stack[i];
        }
        return trace;
    }

    static void downloadUpdate() {
        FileReader reader = MovieFinder.loadFile(updateURL);
        reader.currentLine = 0;
        if (System.getProperty("os.name").startsWith("Mac") || System.getProperty("os.name").startsWith("mac")) {
            reader.readNextLine();
            MovieFinder.showInBrowser(reader.readNextLine());
        } else if (System.getProperty("os.name").startsWith("Win") || System.getProperty("os.name").startsWith("win")) {
            MovieFinder.showInBrowser(reader.readNextLine());
        } else {
            reader.readNextLine();
            reader.readNextLine();
            MovieFinder.showInBrowser(reader.readNextLine());
        }
    }

    static FileReader loadFile(String target) {
        FileReader reader = new FileReader();
        try {
            String inputLine;
            URL url = new URL(target);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                reader.lines.add(inputLine);
            }
            in.close();
            conn.disconnect();
            reader.validFile = true;
        }
        catch (MalformedURLException m) {
            reader.validFile = false;
            MovieFinder.showInBrowser("http://www.moviefinderonline.com/download.html");
        }
        catch (Exception e) {
            reader.validFile = false;
            MovieFinder.showInBrowser("http://www.moviefinderonline.com/download.html");
        }
        return reader;
    }

    static void cout(String s) {
        System.out.println(s);
    }

    static JFrame makeFrame(String title) {
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        JFrame win = new JFrame(title);
        win.setVisible(true);
        win.setLocation((int)resolution.getWidth() / 2 - 65, (int)resolution.getHeight() / 2 - 40);
        return win;
    }

    static boolean showInBrowser(String url) {
        String os = System.getProperty("os.name").toLowerCase();
        Runtime rt = Runtime.getRuntime();
        try {
            if (os.indexOf("win") >= 0) {
                String[] cmd = new String[]{"cmd.exe", "/C", "start", url};
                rt.exec(cmd);
            } else if (os.indexOf("mac") >= 0) {
                rt.exec("open " + url);
            } else {
                String[] browsers = new String[]{"firefox", "epiphany", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
                StringBuffer cmd = new StringBuffer();
                for (int i = 0; i < browsers.length; ++i) {
                    cmd.append((i == 0 ? "" : " || ") + browsers[i] + " \"" + url + "\" ");
                }
                rt.exec(new String[]{"sh", "-c", cmd.toString()});
            }
            return true;
        }
        catch (IOException e) {
            JFrame frame = MovieFinder.makeFrame("Browser Error");
            TextAlert t = new TextAlert(frame, frame.getTitle(), " The system failed to invoke your default web browser while attempting to access: \n\n " + url + "\n\n" + MovieFinder.getStackTrace(e), "My OS Sucks.", "null", 550, 450);
            frame.dispose();
            return false;
        }
    }
}

