/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class MovieFinderExportPlugin {
    public static void main(String[] args) {
        new MovieFinderExportPlugin();
    }

    public MovieFinderExportPlugin() {
        File mf = new File("MovieFinder.jar");
        if (mf.exists()) {
            this.runFile("MovieFinder.jar");
        } else {
            this.initLF();
            this.tellUser();
        }
        System.exit(0);
    }

    void tellUser() {
        MovieFinderExportPlugin.popUpAlert("MovieFinder Plugin", "The file you just clicked on is a plugin, not a program.\n\n It must reside in the folder where \"MovieFinder.jar\" is kept.");
    }

    static void popUpAlert(String frame, String message) {
        JOptionPane.showMessageDialog(null, "\n\n " + message + "\n\n", frame, 1);
    }

    void initLF() {
        if (System.getProperty("os.name").startsWith("Win") || System.getProperty("os.name").startsWith("Mac")) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception t) {
                System.err.println("Failed to init System Look and Feel.");
            }
        }
    }

    void runFile(String filepath) {
        String os = System.getProperty("os.name").toLowerCase();
        Runtime rt = Runtime.getRuntime();
        try {
            if (os.indexOf("win") >= 0) {
                String[] cmd = new String[]{"cmd.exe", "/C", "\"" + filepath + "\""};
                rt.exec(cmd);
            } else if (os.indexOf("mac") >= 0) {
                String[] cmd = new String[]{"open", filepath};
                rt.exec(cmd);
            } else {
                String[] cmd = new String[]{"java", "-jar", "MovieFinder.jar"};
                rt.exec(cmd);
            }
        }
        catch (IOException e) {
            this.tellUser();
        }
    }
}

