/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.UIManager;

public class MovieFinderInstaller
implements ActionListener {
    String installDir;
    String shortcutDir;
    String userShortcutDir;
    String desktopDir;
    String commonDir;
    String osName;
    boolean win = false;
    boolean mac = false;
    boolean otherOS = false;
    boolean vista;
    boolean winNotC;
    FileReader fin;
    boolean userOnly = false;
    Timer timer;
    String shortcutName = "MovieFinder";
    String settingsFile = "update.log";
    String email = "support@moviefinder.com";
    String target = "MovieFinder.jar";
    boolean downloadingJava = false;
    boolean coutChanges = false;
    SplashScreen splash;
    boolean failed = false;
    String vistaWarning = "";
    int popupShift = -7;
    int macDiff = 22;
    int offset = 325;
    int offsetMac = this.offset - this.macDiff;
    boolean inJar = true;

    public MovieFinderInstaller() {
        this.vista = false;
        this.winNotC = false;
        this.winNotC = true;
        this.installMovieFinder(true);
        this.splash.dispose();
        System.exit(0);
    }

    public MovieFinderInstaller(String installDirTarget) {
        this.installDir = installDirTarget;
        this.installMovieFinder(false);
    }

    void installMovieFinder(boolean doSplash) {
        try {
            if (doSplash) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    System.err.println("Failed to init Look and Feel: " + e.getCause());
                }
                this.timer = new Timer(10000, this);
                this.splash = new SplashScreen("MovieFinder Installer", 5, this.inJar, Double.parseDouble(System.getProperty("java.specification.version")) < 1.5 && (System.getProperty("os.name").toLowerCase().lastIndexOf("vista") > 0 || System.getProperty("os.name").toLowerCase().lastIndexOf("windows 7") > 0), false);
                this.splash.updateProgress("checking operating system");
                Point loc = this.splash.getLocation();
                int y = (int)loc.getY() - this.offset;
                if (y < 0) {
                    y = -5;
                }
                if (MovieFinderInstaller.mac() && y < this.macDiff) {
                    y = this.macDiff;
                    this.offset = this.offsetMac;
                }
                this.splash.setLocation(new Point((int)loc.getX(), y));
            }
            if (System.getProperty("os.name").startsWith("Win") || System.getProperty("os.name").startsWith("win")) {
                this.osName = System.getProperty("os.name");
                if (MovieFinderInstaller.containsSubstring(this.osName, "Vista") || MovieFinderInstaller.containsSubstring(this.osName, "7") || MovieFinderInstaller.containsSubstring(this.osName, "8")) {
                    this.vista = true;
                }
                if (doSplash) {
                    this.splash.updateProgress(System.getProperty("os.name") + " detected");
                }
                this.win = true;
                System.err.println("Windows Operating System detected.");
                this.shortcutName = this.shortcutName + ".lnk";
                if (!this.vista) {
                    if (doSplash) {
                        this.installDir = System.getProperty("user.home");
                    }
                    this.shortcutDir = this.installDir.substring(0, this.installDir.indexOf("Settings\\") + 9) + "All Users";
                    this.desktopDir = System.getProperty("user.home") + "\\Desktop";
                    this.shortcutDir = this.shortcutDir + "\\Start Menu\\Programs\\MovieFinder";
                    this.userShortcutDir = System.getProperty("user.home") + "\\Start Menu\\Programs\\MovieFinder";
                    if (doSplash) {
                        this.installDir = this.installDir.substring(0, 2) + "\\Program Files\\MovieFinder";
                    }
                    this.commonDir = this.installDir.charAt(0) + ":\\Documents and Settings\\All Users\\Application Data\\MovieFinder";
                } else {
                    this.vistaWarning = "\n\n This is a known issue with " + this.osName + "'s User Account Control. At the moment, the\n " + "only solution is to go into the Control Panel -> User Accounts and disable User Account Control.\n " + "Sorry for the inconvenience, but at least that pop-up won't annoy you anymore!";
                    this.desktopDir = System.getProperty("user.home") + "\\Desktop";
                    if (doSplash) {
                        this.installDir = this.desktopDir.substring(0, 2) + "\\Program Files\\MovieFinder";
                    }
                    this.shortcutDir = this.desktopDir.substring(0, 2) + "\\ProgramData\\Microsoft\\Windows\\Start Menu\\Programs\\MovieFinder";
                    this.userShortcutDir = System.getProperty("user.home") + "\\AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\MovieFinder";
                    this.commonDir = this.desktopDir.substring(0, 2) + "\\ProgramData\\MovieFinder";
                }
                if (doSplash) {
                    int choice = 1;
                    Object[] options = new Object[]{"Next", "Change Install Dir", "Cancel Installation"};
                    while (choice == 1) {
                        choice = this.popUpQuestion(this.splash, "Installing MovieFinder", "Welcome to MovieFinder!\n\n MovieFinder will be extracted to the following directory:\n\n         " + this.installDir, options);
                        if (choice != 1) continue;
                        this.installDir = this.getInstallPath(this.installDir);
                    }
                    if (choice == 2) {
                        System.exit(0);
                    }
                }
                MovieFinderInstaller.cout("shortcutDir: " + this.shortcutDir);
                MovieFinderInstaller.cout("userShortcutDir: " + this.userShortcutDir);
                MovieFinderInstaller.cout("installDir: " + this.installDir);
                MovieFinderInstaller.cout("desktopDir: " + this.desktopDir);
                MovieFinderInstaller.cout("commonDir: " + this.commonDir);
                File dir = new File(this.shortcutDir);
                if (!dir.exists()) {
                    this.userOnly = !dir.mkdir();
                    MovieFinderInstaller.cout("making shortcutDir: " + !this.userOnly);
                } else {
                    MovieFinderInstaller.cout("shortcutDir already exists");
                }
                this.shortcutDir = this.shortcutDir + "\\";
                this.userShortcutDir = this.userShortcutDir + "\\";
                if (this.userOnly) {
                    this.shortcutDir = this.userShortcutDir;
                    dir = new File(this.userShortcutDir);
                    if (!dir.exists()) {
                        MovieFinderInstaller.cout("making userShortcutDir: " + dir.mkdir());
                    } else {
                        MovieFinderInstaller.cout("userShortcutDir already exists");
                    }
                    this.updateCommonInstallDirs(true, true);
                }
                if (!(dir = new File(this.installDir)).exists()) {
                    boolean made = dir.mkdir();
                    MovieFinderInstaller.cout("making installDir: " + made);
                    if (!made) {
                        this.updateCommonInstallDirs(true, false);
                        dir = new File(this.installDir);
                        if (!dir.exists()) {
                            made = dir.mkdir();
                        }
                        MovieFinderInstaller.cout("making new installDir: " + made);
                    }
                } else {
                    MovieFinderInstaller.cout("installDir already exists");
                }
                this.installDir = this.installDir + "\\";
                this.desktopDir = this.desktopDir + "\\";
                dir = new File(this.commonDir);
                if (!dir.exists()) {
                    boolean made = dir.mkdir();
                    MovieFinderInstaller.cout("making commonDir: " + made);
                    if (!made) {
                        this.updateCommonInstallDirs(false, true);
                        dir = new File(this.commonDir);
                        if (!dir.exists()) {
                            made = dir.mkdir();
                        }
                        MovieFinderInstaller.cout("making new commonDir: " + made);
                    }
                } else {
                    MovieFinderInstaller.cout("commonDir already exists");
                }
                this.commonDir = this.commonDir + "\\";
            } else {
                if (System.getProperty("os.name").startsWith("Mac") || System.getProperty("os.name").startsWith("mac")) {
                    this.mac = true;
                    this.installDir = "/Applications/MovieFinder";
                    this.desktopDir = System.getProperty("user.home") + "/Desktop";
                    this.commonDir = "/var/tmp/MovieFinder";
                } else {
                    this.otherOS = true;
                    System.err.println(System.getProperty("os.name") + " Operating System detected.");
                    this.installDir = System.getProperty("user.home") + "/MovieFinder";
                    this.commonDir = "/var/tmp/MovieFinder";
                }
                if (doSplash) {
                    this.splash.updateProgress(System.getProperty("os.name") + " detected");
                    int choice = 1;
                    Object[] options = new Object[]{"Next", "Change Install Dir", "Cancel Installation"};
                    while (choice == 1) {
                        choice = this.popUpQuestion(this.splash, "Installing MovieFinder", "Welcome to MovieFinder!\n\n MovieFinder will be extracted to the following directory:\n\n         " + this.installDir, options);
                        if (choice != 1) continue;
                        this.installDir = this.getInstallPath(this.installDir);
                    }
                    if (choice == 2) {
                        System.exit(0);
                    }
                }
                File dir = new File(this.installDir);
                boolean dirCreated = true;
                Object[] option = new Object[]{"Browse for Another Install Folder", "Exit Installation"};
                if (!dir.exists()) {
                    dirCreated = dir.mkdir();
                }
                String path = this.installDir;
                while (!dirCreated) {
                    int c = this.popUpQuestion(this.splash, "Cannot Access Install Directory", "Your user account does not have the proper permissions to install to '" + path + ".'\n\n Would you like to attempt installation to another folder?", option);
                    if (c == 0) {
                        path = this.getInstallPath(System.getProperty("user.home"));
                        MovieFinderInstaller.cout("chose: " + path);
                        dirCreated = new File(path).isDirectory();
                        MovieFinderInstaller.cout(dirCreated + "");
                        if (dirCreated) {
                            File temp = new File(path + "/temp");
                            dirCreated = temp.mkdir();
                            MovieFinderInstaller.cout("madeDir? " + dirCreated);
                            dirCreated = temp.delete();
                        }
                        MovieFinderInstaller.cout(dirCreated + "");
                        continue;
                    }
                    System.exit(0);
                }
                this.installDir = path;
                this.installDir = this.installDir + "/";
                if (this.mac) {
                    this.desktopDir = this.desktopDir + "/";
                }
                if (!(dir = new File(this.commonDir)).exists()) {
                    dir.mkdir();
                }
                this.commonDir = this.commonDir + "/";
            }
            if (doSplash) {
                this.installMF();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (doSplash) {
                if (this.splash != null) {
                    this.popUpAlert(this.splash, "MovieFinder Installation -- Failed", "The MovieFinder installation program has failed to extract the MovieFinder application files.\n\n A computer administrator is required for proper file permissions.\n\n\n If you continue to receive this error, visit www.MovieFinderOnline.com for a solution." + MovieFinderInstaller.getStackTrace(e));
                } else {
                    JOptionPane.showMessageDialog(null, "\n\n The MovieFinder installation program has failed to extract the MovieFinder application files.\n\n A computer administrator is required for proper file permissions.\n\n\n If continue to receive this error, visit www.MovieFinderOnline.com for a solution." + MovieFinderInstaller.getStackTrace(e) + "\n\n", "MovieFinder Installation -- Failed", 1);
                }
                System.exit(0);
            }
            JOptionPane.showMessageDialog(null, "\n\n Sorry, but the MovieFinder update has failed unexpectedly.\n\n  To help me patch this error, please copy/paste the following information in an email to support@moviefinderonline.com --" + MovieFinderInstaller.getStackTrace(e) + "\n\n", "MovieFinder Installation -- Failed", 1);
        }
        if (doSplash) {
            this.timer.start();
            if (System.getProperty("user.home").indexOf("Mark Haag") <= 0 && System.getProperty("user.home").indexOf("ZRedBaron") <= 0) {
                MovieFinderInstaller.emailInstallProcess(false);
            }
        }
    }

    static boolean mac() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    int yLoc() {
        int y = 0;
        return y;
    }

    void updateCommonInstallDirs(boolean install, boolean common) {
        int i;
        Object[] continueOptions = new Object[]{"Continue", " Choose Install Dir ", "Exit Installation"};
        String prev = this.installDir;
        if (this.vista) {
            if (common) {
                this.commonDir = System.getProperty("user.home") + "\\AppData\\Local\\MovieFinder";
            }
            if (install) {
                this.installDir = System.getProperty("user.home") + "\\AppData\\MovieFinder";
            }
        } else {
            if (install) {
                this.installDir = System.getProperty("user.home") + "\\Application Data\\MovieFinder";
            }
            if (common) {
                this.commonDir = System.getProperty("user.home") + "\\Local Settings\\Application Data\\MovieFinder";
            }
        }
        if ((i = this.popUpQuestion(this.splash, "File Access Denied", System.getProperty("os.name") + " has denied write access to the install directory '" + prev + ".' \n\n Install path will be changed to: \n\n     " + this.installDir, continueOptions)) != 0) {
            if (i == 1) {
                this.installDir = this.getInstallPath(this.installDir);
            } else {
                System.exit(0);
            }
        }
        MovieFinderInstaller.cout("commonDir is now: " + this.commonDir);
    }

    String getInstallPath(String path) {
        Point loc = this.splash.getLocation();
        JDialog dialog = new JDialog(this.splash, "test", true);
        dialog.setLocation(new Point((int)loc.getX(), (int)loc.getY() + this.offset));
        JFileChooser chooser = new JFileChooser(path);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Select MovieFinder Install Directory");
        chooser.setApproveButtonText("OK");
        chooser.setControlButtonsAreShown(true);
        int returnVal = chooser.showOpenDialog(dialog);
        if (returnVal == 0) {
            if (!chooser.getSelectedFile().exists()) {
                chooser.getSelectedFile().mkdir();
            }
            if (chooser.getSelectedFile().isDirectory()) {
                return chooser.getSelectedFile().getAbsolutePath();
            }
        }
        return path;
    }

    static boolean containsSubstring(String bigString, String sub_String) {
        if (bigString == null || sub_String == null || bigString.length() <= 0 || sub_String.length() <= 0) {
            return false;
        }
        char[] string = bigString.toLowerCase().toCharArray();
        char[] subString = sub_String.toLowerCase().toCharArray();
        int passedChars = 0;
        boolean lastOK = false;
        boolean passed = false;
        for (int i = 0; i < bigString.length(); ++i) {
            if (string[i] == subString[passedChars]) {
                lastOK = true;
                if (++passedChars != subString.length) continue;
                passed = true;
                i = bigString.length();
                continue;
            }
            lastOK = false;
            passedChars = 0;
        }
        return passed;
    }

    static String getStackTrace(Exception e) {
        String trace = "\n";
        StackTraceElement[] stack = e.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            trace = trace + "\n" + stack[i];
        }
        return trace;
    }

    void installMF() {
        Object[] options = new Object[]{"Run MovieFinder", "Finish"};
        if (this.win) {
            MovieFinderInstaller.cout(this.installDir);
            MovieFinderInstaller.cout(System.getProperty("user.home"));
            MovieFinderInstaller.cout(this.installDir.substring(0, 1));
            MovieFinderInstaller.cout(System.getProperty("user.home").substring(0, 1));
            if (this.installDir.substring(0, 1).compareToIgnoreCase(System.getProperty("user.home").substring(0, 1)) != 0) {
                this.winNotC = true;
            }
            this.splash.updateProgress("extracting files");
            this.copy(this.target, this.installDir);
            if (this.vista || this.winNotC) {
                this.copy("Shortcut.exe", this.commonDir);
            }
            this.copy("UnInstall_MovieFinder.jar", this.commonDir);
            this.copy("MovieFinderWin.ico", this.commonDir);
            this.copy("uninstallMF.ico", this.commonDir);
            this.copy("MovieFinderHelp.url", this.shortcutDir);
            MovieFinderInstaller.cout(this.commonDir + "MovieFinderWin.ico");
            MovieFinderInstaller.cout(this.shortcutDir + this.shortcutName);
            MovieFinderInstaller.cout(this.installDir + this.target);
            MovieFinderInstaller.cout(this.desktopDir + this.shortcutName);
            int i = this.popUpQuestion(this.splash, "Desktop Shortcut?", "Would you like to install a MovieFinder shortcut on your desktop?");
            if (i == 0) {
                this.makeShortcut(this.installDir + this.target, this.installDir, this.commonDir + "MovieFinderWin.ico", this.desktopDir + this.shortcutName);
            }
            this.makeShortcut(this.installDir + this.target, this.installDir, this.commonDir + "MovieFinderWin.ico", this.shortcutDir + this.shortcutName);
            this.makeShortcut(this.commonDir + "UnInstall_" + this.target, this.commonDir, this.commonDir + "uninstallMF.ico", this.shortcutDir + "UnInstall MovieFinder.lnk");
            MovieFinderInstaller.cout("placed shortcuts in: " + this.shortcutDir);
            File f = new File(System.getProperty("user.home") + "\\Shortcut.exe");
            if (f.exists()) {
                f.delete();
            }
            this.splash.updateProgress("checking java version");
            this.updateJava();
            this.splash.updateProgress("installation complete");
            f = new File(this.shortcutDir + "MovieFinderHelp.url");
            File fNew = new File(this.shortcutDir + "Online MovieFinder Help.url");
            f.renameTo(fNew);
            f = new File(this.shortcutDir + "MovieFinderHelp.url");
            if (f.exists()) {
                f.delete();
            }
            f = new File(this.shortcutDir + "MovieFinder.lnk");
            String runPath = f.getAbsolutePath();
            if (!f.exists()) {
                runPath = "";
            }
            if (this.userOnly && !this.failed) {
                int run;
                this.vistaWarning = this.vista ? "\n If you have an Administrator's access, then " + this.osName + " itself has prevented system-wide shortcut installation." + this.vistaWarning : "";
                String frame = "MovieFinder Installation Complete -- " + System.getProperty("os.name") + " (limited install)";
                String message = "MovieFinder's shortcuts can only be seen on this computer from your user account.\n\n It seems you don't have the system privileges to install MovieFinder shortcuts system-wide.";
                if (this.downloadingJava) {
                    this.popUpAlert(this.splash, frame, message + "\n\n Don't forget run the Java installation file that your browser is downloading!");
                } else if (runPath.length() == 0) {
                    this.popUpAlert(this.splash, frame, message);
                } else if (runPath.length() > 0 && (run = this.popUpQuestion(this.splash, frame, message + "\n\n Would you like to run MovieFinder now?", options)) == 0) {
                    this.runProgram(this.splash, runPath);
                }
            } else if (this.failed) {
                this.popUpAlert(this.splash, "MovieFinder Installation Failed -- " + System.getProperty("os.name"), "MovieFinder has completed the installation process, but errors were encountered. \n\n MovieFinder tried to install to: \n               " + this.installDir + "\n\n It is possible that the installed files can be found there. Please check your file permissions and try again." + this.vistaWarning);
            } else if (this.downloadingJava || runPath.length() == 0) {
                this.popUpAlert(this.splash, "MovieFinder Installation Complete -- " + System.getProperty("os.name"), "MovieFinder has completed installation on your Windows computer. \n\n MovieFinder was extracted to: \n               " + this.installDir + "\n\n Shortcuts were placed in your Start Menu.\n\n Don't forget run the Java installation file that your browser is downloading!");
            } else {
                int run = this.popUpQuestion(this.splash, "MovieFinder Installation Complete -- " + System.getProperty("os.name"), "MovieFinder has completed installation on your Windows computer. \n\n MovieFinder was extracted to: \n               " + this.installDir + "\n\n Shortcuts were placed and in your Start Menu.\n\n Would you like to run MovieFinder now?", options);
                if (run == 0) {
                    this.runProgram(this.splash, runPath);
                }
            }
        } else if (this.mac) {
            boolean makeAlias;
            boolean bl = makeAlias = !new File(this.installDir + "MovieFinder").exists();
            if (this.installDir.compareTo("/Applications/MovieFinder/") == 0 && makeAlias) {
                this.copy("MovieFinderAlias.zip", this.installDir);
            }
            this.splash.updateProgress("extracting " + this.target);
            this.copy(this.target, this.installDir);
            this.copy("UnInstall_MovieFinder.jar", this.installDir);
            this.copy("MovieFinderHelp.url", this.installDir);
            this.splash.updateProgress("checking java version");
            this.updateJava();
            this.splash.updateProgress("installation complete");
            new File(this.installDir + ".MovieFinderMac.icns").delete();
            MovieFinderInstaller.cout("deleted MFgraphics.lib ?= " + new File(this.installDir + "MFgraphics.lib").delete());
            MovieFinderInstaller.cout("deleted .script.sh ?= " + new File(this.installDir + ".script.sh").delete());
            File f = new File(this.installDir + "MovieFinderHelp.url");
            File fNew = new File(this.installDir + "Online MovieFinder Help.url");
            f.renameTo(fNew);
            f = new File(this.installDir + "MovieFinderHelp.url");
            if (f.exists()) {
                f.delete();
            }
            if (this.installDir.compareTo("/Applications/MovieFinder/") == 0 && makeAlias) {
                this.runProgram(this.splash, this.installDir + "MovieFinderAlias.zip");
            }
            if (this.failed) {
                this.popUpAlert(this.splash, "MovieFinder Installation Failed -- " + System.getProperty("os.name"), "MovieFinder has completed the installation process, but errors were encountered. \n\n MovieFinder tried to install to: \n               " + this.installDir + "\n\n It is likely that this installation failed. Please check your file permissions and try again.");
            } else if (this.downloadingJava) {
                this.popUpAlert(this.splash, "MovieFinder Installation Complete -- " + System.getProperty("os.name"), "MovieFinder has completed installation on your Windows computer. \n\n MovieFinder was extracted to: \n               " + this.installDir + "\n\n Shortcuts were placed in your Start Menu.\n\n Don't forget run the Java installation file that your browser is downloading!");
            } else {
                int run = this.popUpQuestion(this.splash, "MovieFinder Installation Complete -- " + System.getProperty("os.name"), "MovieFinder has completed installation on your Macintosh computer. \n\n MovieFinder was extracted to: \n               " + this.installDir + "\n\n To run MovieFinder, double-click on MovieFinder.jar, found in the above directory.\n\n Would you like to run MovieFinder now?", options);
                if (run == 0) {
                    this.runProgram(this.splash, this.installDir + this.target);
                }
            }
            if (this.installDir.compareTo("/Applications/MovieFinder/") == 0 && makeAlias) {
                new File(this.installDir + "MovieFinderAlias.zip").delete();
            }
        } else {
            this.copy(this.target, this.installDir);
            this.copy("UnInstall_MovieFinder.jar", this.installDir);
            this.copy("icon32.png", this.installDir);
            this.copy("icon64.png", this.installDir);
            this.copy("MovieFinderHelp.url", this.installDir);
            File f = new File(this.installDir + "MovieFinderHelp.url");
            File fNew = new File(this.installDir + "Online MovieFinder Help.url");
            f.renameTo(fNew);
            f = new File(this.installDir + "MovieFinderHelp.url");
            if (f.exists()) {
                f.delete();
            }
            this.splash.updateProgress("checking java version");
            this.updateJava();
            this.splash.updateProgress("installation complete");
            if (this.failed) {
                this.popUpAlert(this.splash, "MovieFinder Installation Failed -- " + System.getProperty("os.name"), "MovieFinder has completed the installation process, but errors were encountered. \n\n MovieFinder tried to install to: \n               " + this.installDir + "\n\n It is likely that this installation failed. Please check your file permissions and try again.");
            } else {
                int r = this.popUpQuestion(this.splash, "MovieFinder Installation Complete -- " + System.getProperty("os.name"), "MovieFinder has completed installation on your computer. \n\n MovieFinder was extracted to: \n               " + this.installDir + "\n\n\n If double-clicking doesn't work, cd to the above directory and enter the command: \n 'java -jar MovieFinder.jar' \n\n\n Run MovieFinder now?");
                if (r == 0) {
                    new File(this.installDir + ".script.sh").delete();
                    new File(this.installDir + ".MovieFinderMac.icns").delete();
                    this.runProgram(this.splash, this.installDir + this.target);
                }
            }
        }
    }

    void runMacShell() {
        Runtime rt = Runtime.getRuntime();
        try {
            MovieFinderInstaller.cout("wrote shell script to " + this.installDir + ".script.sh, executing...");
            String[] cmd = new String[]{"java", "-jar", this.installDir + "MovieFinder.jar"};
            this.popUpAlert(this.splash, "trying to run MF", cmd[2]);
            rt.exec(cmd);
        }
        catch (Exception e) {
            MovieFinderInstaller.cout("failed to init dock icon");
            JOptionPane.showMessageDialog(this.splash, "\n\n  MovieFinder failed to initialize the dock icon properly.\n\n Now exiting.", "MovieFinder Script Error", 0);
        }
    }

    public void copy(String filename, String targetDir) {
        try {
            File fileDest = new File(targetDir + filename);
            if (fileDest.exists()) {
                fileDest.delete();
                fileDest = new File(targetDir + filename);
            }
            FileOutputStream output = new FileOutputStream(fileDest);
            if (!this.inJar) {
                FileInputStream stream = new FileInputStream(new File(filename));
                byte[] b = new byte[1000];
                int v = 0;
                while ((v = stream.read(b)) > -1) {
                    output.write(b, 0, v);
                }
                stream.close();
            } else {
                InputStream stream = this.getClass().getResourceAsStream(filename);
                byte[] b = new byte[1000];
                int v = 0;
                while ((v = stream.read(b)) > -1) {
                    output.write(b, 0, v);
                }
                stream.close();
            }
            output.flush();
            output.close();
            MovieFinderInstaller.cout("extracted '" + filename + "' to '" + targetDir + "'");
        }
        catch (IOException e) {
            this.failed = true;
            this.popUpAlert(this.splash, "MovieFinder Extraction -- Failed", "The MovieFinder installation program has failed to extract '" + filename + "' to " + targetDir + "." + this.vistaWarning + "\n\n\n You may wish to reboot your computer and try again.\n\n\n If all else fails, visit www.MovieFinderOnline.com for a solution." + MovieFinderInstaller.getStackTrace(e));
        }
    }

    void updateJava() {
        if (Double.parseDouble(System.getProperty("java.specification.version")) > 1.4 && this.mac) {
            return;
        }
        Object[] javaOptions = new Object[]{"Download Latest Version of Java", "Not Right Now"};
        if (Double.parseDouble(System.getProperty("java.specification.version")) < 1.6) {
            String message = "The version of Java installed on your computer is not supported by MovieFinder.\n\n Would you like MovieFinder to request your internet browser download the latest version of Java?";
            int update = this.popUpQuestion(this.splash, "Java Version Out of Date", message, javaOptions);
            if (update == 0) {
                MovieFinder.showInBrowser("http://www.java.com/en/download/manual.jsp");
                this.downloadingJava = true;
            } else {
                this.popUpAlert(this.splash, "Java Warning", "Since you are not updating Java, MovieFinder will not run. \n\n Go to www.java.com when you change your mind...");
            }
        }
    }

    void runProgram(Frame frame, String path) {
        Runtime rt = Runtime.getRuntime();
        try {
            MovieFinderInstaller.cout("trying to open:  \"" + path + "\"");
            if (System.getProperty("os.name").startsWith("Win") || System.getProperty("os.name").startsWith("win")) {
                String[] cmd = new String[]{"cmd.exe", "/C", "\"" + path + "\""};
                rt.exec(cmd);
            } else if (System.getProperty("os.name").startsWith("Mac") || System.getProperty("os.name").startsWith("mac")) {
                String[] cmd = new String[]{"open", path};
                rt.exec(cmd);
            } else {
                String[] cmd = new String[]{"java", "-jar", path};
                rt.exec(cmd);
            }
        }
        catch (IOException e) {
            this.popUpAlert(frame, "Cannot Open File", " The system failed to open the file '" + path + ".' \n\n " + MovieFinder.getStackTrace(e));
        }
    }

    void makeShortcut(String target, String workingDir, String iconPath, String linkPath) {
        try {
            new WindowsShortcut(linkPath, target, "", workingDir, iconPath);
            if (this.vista || this.winNotC) {
                String command = "\"" + this.commonDir + "Shortcut.exe\" ";
                command = command + "/f:\"" + linkPath + "\" ";
                command = command + "/a:e ";
                command = command + "/t:\"" + target + "\" ";
                this.runProgram(this.splash, command);
            }
        }
        catch (IOException e) {
            this.failed = true;
            this.popUpAlert(this.splash, "MovieFinder Shortcut Creation -- Failed", "The MovieFinder installation program has failed to create shortcuts in '" + workingDir + "'" + this.vistaWarning + "\n\n If all else fails, visit www.MovieFinderOnline.com for a solution." + MovieFinderInstaller.getStackTrace(e));
        }
    }

    static void cout(String s) {
        System.out.println(s);
    }

    void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            System.out.println("cant sleep" + MovieFinderInstaller.getStackTrace(e));
        }
    }

    void popUpAlert(Window window, String frame, String message) {
        final JOptionPane optionPane = new JOptionPane("\n " + message + "\n  ", 0);
        optionPane.createDialog(window, frame);
        boolean jframe = true;
        try {
            JFrame test = (JFrame)window;
        }
        catch (Exception e) {
            jframe = false;
        }
        final JDialog dialog = jframe ? new JDialog((JFrame)window, frame, true) : new JDialog((JDialog)window, frame, true);
        dialog.setContentPane(optionPane);
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        Point loc = new Point((int)(resolution.getWidth() / 2.0), (int)(resolution.getHeight() / 2.0));
        try {
            loc = window.getLocation();
        }
        catch (Exception ex) {
            loc.setLocation((int)loc.getX(), (int)loc.getY() - this.offset - (int)dialog.getPreferredSize().getHeight() / 2);
        }
        dialog.setLocation(new Point((int)(resolution.getWidth() - dialog.getPreferredSize().getWidth()) / 2 + this.popupShift, (int)loc.getY() + this.offset));
        dialog.setDefaultCloseOperation(2);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.pack();
        dialog.setVisible(true);
    }

    int popUpQuestion(Window window, String frame, String message, Object[] options) {
        final JOptionPane optionPane = new JOptionPane("\n " + message + "\n ", 3, 1);
        optionPane.setOptions(options);
        optionPane.createDialog(window, frame);
        boolean jframe = true;
        try {
            JFrame test = (JFrame)window;
        }
        catch (Exception e) {
            jframe = false;
        }
        final JDialog dialog = jframe ? new JDialog((JFrame)window, frame, true) : new JDialog((JDialog)window, frame, true);
        dialog.setContentPane(optionPane);
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        Point loc = new Point((int)(resolution.getWidth() / 2.0), (int)(resolution.getHeight() / 2.0));
        try {
            loc = window.getLocation();
        }
        catch (Exception ex) {
            // empty catch block
        }
        dialog.setLocation(new Point((int)(resolution.getWidth() - dialog.getPreferredSize().getWidth()) / 2 + this.popupShift, (int)loc.getY() + this.offset));
        dialog.setDefaultCloseOperation(0);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.pack();
        dialog.setVisible(true);
        Object obj = optionPane.getValue();
        for (int i = 0; i < options.length; ++i) {
            if (obj != options[i]) continue;
            return i;
        }
        return -1;
    }

    int popUpQuestion(Window window, String frame, String message) {
        return this.popUpQuestion(window, frame, message, new Object[]{"OK", " Cancel "});
    }

    static boolean emailInstallProcess(boolean uninstall) {
        movie m = new movie();
        int presentMonth = m.numMonth;
        int presentDay = m.day;
        int presentYear = m.year;
        String type = "installer";
        if (uninstall) {
            type = "unInstaller";
        }
        String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        try {
            String inputLine;
            URL url = new URL("http://www.moviefinderonline.com/cgi-bin/" + type + ".cgi?date=" + presentDay + months[presentMonth - 1] + presentYear + "&OS=" + System.getProperty("os.name").replaceAll(" ", "."));
            MovieFinderInstaller.cout(url.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Accept", "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/x-shockwave-flash, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
            conn.setRequestProperty("Accept-Language", "en-us");
            conn.setRequestProperty("Accept-Encoding", "deflate");
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                MovieFinderInstaller.cout(inputLine);
            }
            in.close();
            conn.disconnect();
        }
        catch (FileNotFoundException f) {
            f.printStackTrace();
        }
        catch (NoRouteToHostException n) {
            n.printStackTrace();
        }
        catch (UnknownHostException h) {
            h.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            new MovieFinderInstaller();
        }
        catch (Exception e) {
            new TextAlert(null, "MovieFinder Installation Failed", "An unexpected exception was encountered:\n\n" + MovieFinder.getStackTrace(e), "OK", "null", 450, 300);
        }
        catch (Error f) {
            new TextAlert(null, "MovieFinder Installation Failed", "An unexpected error was encountered:\n\n" + MovieFinder.getStackTrace(f), "OK", "null", 450, 300);
        }
        System.exit(0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        final ActionEvent action = event;
        if (event == null) {
            return;
        }
        new SwingWorker(){

            public Object construct() {
                try {
                    MovieFinderInstaller.this.performAction(action);
                }
                catch (Exception exc) {
                    MovieFinderInstaller.this.splash.dispose();
                    System.exit(0);
                }
                catch (Error err) {
                    MovieFinderInstaller.this.splash.dispose();
                    System.exit(0);
                }
                return null;
            }
        }.start();
    }

    void performAction(ActionEvent e) {
        if (e.getSource() == this.timer) {
            this.splash.dispose();
            System.exit(0);
        }
    }
}

