/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SplashScreen
extends JFrame
implements KeyListener {
    JProgressBar progressBar;
    JProgressBar progressBar2;
    JLabel taskOutput;
    JLabel taskOutput2;
    Container c;
    JPanel panel;
    ImageIcon[] images;
    ImagePanel image;
    boolean percent;
    boolean jar;
    boolean inited = false;
    Thread thread;
    int winW;
    int winH;
    int bar2H;
    int numSpaces = 13;
    int progress = 0;
    int progress2 = 0;
    int numStages;
    boolean substance;
    boolean newBar = false;
    boolean bar2added = false;
    boolean closeWhenDone;
    boolean cancelled = false;
    boolean bkgdsLoaded = false;
    boolean toFront = true;
    String title;

    public SplashScreen() {
        this.cancelled = true;
    }

    public SplashScreen(String Title, int numTotalStages, boolean inJar, boolean showPercent, boolean disposeWhenDone) {
        super(Title);
        this.title = Title;
        this.numStages = numTotalStages;
        this.jar = inJar;
        this.percent = showPercent;
        this.closeWhenDone = disposeWhenDone;
        this.init();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SplashScreen.this.loadBkgds();
                SplashScreen.this.bkgdsLoaded = true;
            }
        });
    }

    public SplashScreen(String Title, int numTotalStages, boolean inJar, boolean showPercent, ImageIcon[] imgs) {
        super(Title);
        this.title = Title;
        this.numStages = numTotalStages;
        this.jar = inJar;
        this.percent = showPercent;
        this.closeWhenDone = false;
        this.init();
        this.images = imgs;
    }

    void init() {
        this.inited = true;
        String icon = "icon16.png";
        if (System.getProperty("os.name").contains("Windows 7")) {
            icon = "icon64.png";
        }
        if (this.jar) {
            this.setIconImage(new ImageIcon(this.getClass().getResource(icon)).getImage());
        } else {
            this.setIconImage(new ImageIcon(icon).getImage());
        }
        this.c = this.getContentPane();
        this.c.setFocusable(true);
        this.c.addKeyListener(this);
        this.showPercent(this.percent);
        this.setDefaultCloseOperation(0);
        this.initBar();
        if (FileReader.containsSubstring(this.getTitle(), "MovieFinder") || this.getTitle().compareToIgnoreCase("Loading MovieFinder") == 0 || "Loading MovieFinder".compareToIgnoreCase(this.getTitle()) == 0) {
            this.setUndecorated(true);
        }
        this.setResizable(false);
        this.addKeyListener(this);
        this.pack();
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(resolution.getWidth() - this.getPreferredSize().getWidth()) / 2, (int)(resolution.getHeight() - this.getPreferredSize().getHeight()) / 2);
    }

    void close() {
        try {
            this.dispose();
        }
        catch (Exception e) {
            SplashScreen.cout("FAILED to dispose splash. caught.");
        }
    }

    void cancel() {
        Integer.parseInt("g");
        SplashScreen.cout("click");
        boolean q = false;
        if (!q) {
            this.cancelled = true;
            this.dispose();
        }
    }

    void setCancel() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SplashScreen.this.cancel();
            }
        });
    }

    int popUpQuestion(String frame, String message) {
        return JOptionPane.showConfirmDialog(this, "\n\n " + message + "\n\n", frame, 0);
    }

    static void cout(String s) {
        System.out.println(s);
    }

    void showPercent(boolean showIt) {
        if (this.progressBar != null) {
            this.progressBar.setStringPainted(showIt);
        }
    }

    void initBar() {
        this.winW = 350;
        this.winH = 238;
        this.bar2H = 44;
        this.progressBar = new JProgressBar(0, this.numStages);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(this.percent);
        this.progressBar.setPreferredSize(new Dimension(this.winW, 20));
        this.progressBar.setOpaque(false);
        this.progressBar.setBorderPainted(false);
        this.progressBar2 = new JProgressBar(0, this.numStages);
        this.progressBar2.setValue(0);
        this.progressBar2.setStringPainted(this.percent);
        this.progressBar2.setPreferredSize(new Dimension(this.winW, 20));
        this.progressBar2.setOpaque(false);
        this.progressBar2.setBorderPainted(false);
        this.taskOutput = new JLabel("loading");
        this.taskOutput2 = new JLabel("");
        this.image = FileReader.containsSubstring(this.getTitle(), "IMDb") ? new ImagePanel("splashIMDb.png", this.winW, this.winH, this.jar) : new ImagePanel("splash.png", this.winW, this.winH, this.jar);
        this.image.setFocusable(true);
        this.c.add(this.image);
        this.winW += 23;
        this.winH += 92;
    }

    static void sleep(double s) {
        try {
            Thread.sleep((int)(s * 1000.0));
        }
        catch (InterruptedException e) {
            System.out.println("cant sleep");
            e.printStackTrace();
        }
    }

    static JLabel blankLine() {
        String s = "";
        for (int i = 0; i < 20; ++i) {
            s = s + "     ";
        }
        return new JLabel(s);
    }

    void reInit(String title, int numOfStages, Window frame) {
        this.setTitle(title);
        this.cancelled = false;
        this.numStages = numOfStages;
        this.progressBar.setMaximum(this.numStages);
        this.progress = 0;
        this.progress2 = 0;
        if (this.bar2added || this.newBar) {
            this.closeBar2();
        }
        Point p = frame.getLocation();
        int x = (int)p.getX() + (int)((double)frame.getWidth() - this.getPreferredSize().getWidth()) / 2;
        int y = (int)p.getY() + (int)((double)frame.getHeight() - this.getPreferredSize().getHeight()) / 2;
        this.setLocation(new Point(x, y));
        this.setVisible(true);
        this.toFront();
    }

    void loadBkgds() {
    }

    void splashMF() {
        this.changeSplash(0);
    }

    void splashIMDb() {
        this.changeSplash(1);
    }

    void splashAmazon() {
        this.changeSplash(2);
    }

    void splashDvdEmpire() {
        this.changeSplash(3);
    }

    void changeSplash(int index) {
    }

    void update() {
        if (!this.newBar) {
            ++this.progress;
            this.progressBar.setValue(this.progress);
            if (this.progress > this.numStages && this.closeWhenDone && this.isVisible()) {
                this.dispose();
            }
        } else {
            if (!this.bar2added) {
                this.image.add(this.progressBar2);
                this.image.add(this.taskOutput2);
                this.image.updateUI();
                this.bar2added = true;
                this.winH += this.bar2H;
                this.setSize(new Dimension(this.winW, this.winH));
            }
            ++this.progress2;
            this.progressBar2.setValue(this.progress2);
        }
    }

    void updateProgressAddTotal(String update, int stageIncrease) {
        if (this.newBar) {
            this.progressBar2.setMaximum(this.progress2 + stageIncrease);
        } else {
            this.numStages += stageIncrease;
            this.progressBar.setMaximum(this.progress + stageIncrease);
        }
        this.updateProgress(update);
    }

    void addTotal(int increase) {
        if (this.newBar) {
            this.progressBar2.setMaximum(this.progressBar2.getMaximum() + increase);
        } else {
            this.numStages += increase;
            this.progressBar.setMaximum(this.numStages);
        }
    }

    void resetProgress(String update) {
        this.progress = 0;
        this.progressBar.setValue(0);
        this.updateProgress(update);
    }

    void updateProgress(String update) {
        if (!this.isVisible()) {
            this.setVisible(true);
            if (this.toFront) {
                this.toFront();
            }
        }
        if (this.newBar) {
            if (this.taskOutput2 != null) {
                this.taskOutput2.setText(update);
            }
        } else if (this.taskOutput != null) {
            this.taskOutput.setText(update);
        }
        this.update();
    }

    void addNewBar(int numStages) {
        this.newBar = true;
        this.progressBar2.setMaximum(numStages);
    }

    void updateProgress() {
        this.update();
    }

    void toggleBarControl(int max) {
        if (this.newBar) {
            this.progress2 = 0;
            this.taskOutput2.setText("");
            this.progressBar2.setMaximum(max);
        } else {
            this.progressBar2.setMaximum(max);
        }
        this.newBar = !this.newBar;
    }

    void closeBar2() {
        if (this.bar2added) {
            this.progress2 = 0;
            this.bar2added = false;
            this.newBar = false;
            this.image.remove(this.numSpaces + 3);
            this.image.remove(this.numSpaces + 2);
            this.image.updateUI();
            this.winH -= this.bar2H;
            if (this.getTitle().indexOf("Loading") >= 0) {
                this.setSize(new Dimension(this.winW, this.winH));
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.cancel();
        }
    }

    class ImagePanel
    extends JPanel {
        ImageIcon icon;
        String picFile;

        public ImagePanel(String filename, int w, int h, boolean inJar) {
            this.icon = inJar ? new ImageIcon(this.getClass().getResource(filename)) : new ImageIcon(filename);
            this.picFile = filename;
            this.setLayout(new FlowLayout());
            this.setPreferredSize(new Dimension(w + 15, h + 60));
            if (SplashScreen.this.title.indexOf("nstall") >= 0 && (System.getProperty("os.name").indexOf("Mac") >= 0 || System.getProperty("os.name").indexOf("Windows XP") >= 0 && Double.parseDouble(System.getProperty("java.specification.version")) <= 1.4)) {
                --SplashScreen.this.numSpaces;
            } else if (SplashScreen.this.title.indexOf("nstall") < 0 && System.getProperty("os.name").contains("Windows 7") || System.getProperty("os.name").indexOf("Vista") >= 0 && Double.parseDouble(System.getProperty("java.specification.version")) > 1.5) {
                --SplashScreen.this.numSpaces;
            }
            for (int i = 0; i < SplashScreen.this.numSpaces; ++i) {
                this.add(SplashScreen.blankLine());
            }
            this.add(SplashScreen.this.progressBar);
            this.add(SplashScreen.this.taskOutput);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.icon.getImage(), 8, 10, this);
        }
    }
}

