/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TextAlert
extends JDialog
implements KeyListener,
PropertyChangeListener {
    String typedText = "-1";
    JTextField textField;
    JOptionPane optionPane;
    String enter = "Enter";
    String cancel = "Cancel";
    JScrollPane scroller;
    int width;
    int height;
    int buttonSelected = -1;
    boolean tipShown = false;
    String cancelledText;

    public TextAlert(Frame aFrame, String title, String message, String firstButton, String secondButton, int w, int h) {
        super(aFrame, title, true);
        this.width = w;
        this.height = h;
        Object[] array = new Object[]{"\n", null, "\n"};
        array[1] = this.getScroller(message);
        if (firstButton.length() > 0) {
            this.enter = firstButton;
        }
        if (secondButton.length() > 0) {
            this.cancel = secondButton;
        }
        Object[] options = new Object[]{this.enter, this.cancel};
        if (secondButton.compareToIgnoreCase("null") == 0) {
            options = new Object[]{this.enter};
            this.optionPane = new JOptionPane(array, 1, 0, null, options, options[0]);
        } else {
            this.optionPane = new JOptionPane(array, 1, 0, null, options, options[0]);
        }
        this.init();
    }

    void init() {
        this.setDefaultCloseOperation(0);
        this.addKeyListener(this);
        this.optionPane.addPropertyChangeListener(this);
        this.setResizable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                if (TextAlert.this.scroller != null) {
                    TextAlert.this.scroller.requestFocus();
                } else {
                    TextAlert.this.textField.requestFocusInWindow();
                }
            }
        });
        this.setContentPane(this.optionPane);
        this.pack();
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(resolution.getWidth() - this.getPreferredSize().getWidth()) / 2, (int)(resolution.getHeight() - this.getPreferredSize().getHeight()) / 2);
        this.setModal(true);
        this.setVisible(true);
    }

    String getText() {
        return this.typedText;
    }

    int getButton() {
        return this.buttonSelected;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.buttonSelected = 0;
            if (this.scroller == null) {
                this.typedText = this.textField.getText();
            }
            this.dispose();
        } else if (e.getKeyCode() == 27) {
            if (this.scroller == null) {
                this.typedText = this.cancelledText;
            }
            this.dispose();
        }
    }

    public static void cout(String s) {
        System.out.println(s);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (this.enter.equals(value)) {
                if (this.scroller != null) {
                    this.buttonSelected = 0;
                } else {
                    this.typedText = this.textField.getText();
                }
                this.dispose();
            } else if (this.cancel.equals(value)) {
                this.typedText = this.cancelledText;
                this.dispose();
            }
        }
    }

    JScrollPane getScroller(String text) {
        JTextArea details = new JTextArea();
        details.setBorder(null);
        details.setEditable(false);
        details.setCursor(null);
        details.setOpaque(false);
        details.setLineWrap(true);
        details.setWrapStyleWord(true);
        details.setFont(new JLabel("goo").getFont());
        details.setText(text);
        details.setCaretPosition(0);
        this.scroller = new JScrollPane(details);
        this.scroller.setBorder(BorderFactory.createEmptyBorder());
        this.scroller.getViewport().setOpaque(false);
        this.scroller.setPreferredSize(new Dimension(this.width - 50, this.height - 120));
        return this.scroller;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("MovieFinder Load Error");
        TextAlert t = new TextAlert(frame, frame.getTitle(), " MovieFinder has encountered a load error (specific error information below).\n\n If the problem persists, try looking for a solution at www.MovieFinderOnline.com.\n\n\n Would you like to visit www.MovieFinderOnline.com for help?\n\n\n MovieFinder has encountered a load error (specific error information below).\n\n If the problem persists, try looking for a solution at www.MovieFinderOnline.com.\n\n\n Would you like to visit www.MovieFinderOnline.com for help?\n\n\n MovieFinder has encountered a load error (specific error information below).\n\n If the problem persists, try looking for a solution at www.MovieFinderOnline.com.\n\n\n Would you like to visit www.MovieFinderOnline.com for help?\n\n\n MovieFinder has encountered a load error (specific error information below).\n\n If the problem persists, try looking for a solution at www.MovieFinderOnline.com.\n\n\n Would you like to visit www.MovieFinderOnline.com for help?\n\n\n MovieFinder has encountered a load error (specific error information below).\n\n If the problem persists, try looking for a solution at www.MovieFinderOnline.com.\n\n\n Would you like to visit www.MovieFinderOnline.com for help?\n\n\n", "Go to www.MovieFinderOnline.com", "null", 550, 450);
        TextAlert.cout("chose: " + t.buttonSelected);
    }
}

