/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.utils;

import com.topjohnwu.utils.ByteArrayStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarMap
implements Closeable,
AutoCloseable {
    private JarFile jarFile;
    private JarInputStream jis;
    private LinkedHashMap<String, JarEntry> bufMap;
    private Manifest manifest;

    public JarMap(File file) throws IOException {
        this(file, true);
    }

    public JarMap(File file, boolean verify) throws IOException {
        this(file, verify, 1);
    }

    public JarMap(File file, boolean verify, int mode) throws IOException {
        this.jarFile = new JarFile(file, verify, mode);
        this.manifest = this.jarFile.getManifest();
    }

    public JarMap(String name) throws IOException {
        this(new File(name));
    }

    public JarMap(String name, boolean verify) throws IOException {
        this(new File(name), verify);
    }

    public JarMap(InputStream is) throws IOException {
        this(is, true);
    }

    public JarMap(InputStream is, boolean verify) throws IOException {
        JarEntry entry;
        this.jis = new JarInputStream(is, verify);
        this.bufMap = new LinkedHashMap();
        while ((entry = this.jis.getNextJarEntry()) != null) {
            this.bufMap.put(entry.getName(), new JarMapEntry(entry, this.jis));
        }
        this.manifest = this.jis.getManifest();
    }

    public File getFile() {
        return this.jarFile == null ? null : new File(this.jarFile.getName());
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public InputStream getInputStream(ZipEntry ze) throws IOException {
        JarMapEntry e;
        if (this.bufMap != null && (e = (JarMapEntry)this.bufMap.get(ze.getName())) != null) {
            return e.data.getInputStream();
        }
        return this.jarFile.getInputStream(ze);
    }

    public OutputStream getOutputStream(ZipEntry ze) {
        this.manifest = null;
        if (this.bufMap == null) {
            this.bufMap = new LinkedHashMap();
        }
        JarMapEntry e = new JarMapEntry(ze.getName());
        this.bufMap.put(ze.getName(), e);
        return e.data;
    }

    public byte[] getRawData(ZipEntry ze) throws IOException {
        JarMapEntry e;
        if (this.bufMap != null && (e = (JarMapEntry)this.bufMap.get(ze.getName())) != null) {
            return e.data.toByteArray();
        }
        ByteArrayStream bytes = new ByteArrayStream();
        bytes.readFrom(this.jarFile.getInputStream(ze));
        return bytes.toByteArray();
    }

    public Enumeration<JarEntry> entries() {
        return this.jarFile == null ? Collections.enumeration(this.bufMap.values()) : this.jarFile.entries();
    }

    public ZipEntry getEntry(String name) {
        return this.getJarEntry(name);
    }

    public JarEntry getJarEntry(String name) {
        JarEntry e;
        JarEntry jarEntry = e = this.jarFile == null ? this.bufMap.get(name) : this.jarFile.getJarEntry(name);
        if (e == null && this.bufMap != null) {
            return this.bufMap.get(name);
        }
        return e;
    }

    @Override
    public void close() throws IOException {
        (this.jarFile == null ? this.jis : this.jarFile).close();
    }

    private static class JarMapEntry
    extends JarEntry {
        ByteArrayStream data = new ByteArrayStream();

        JarMapEntry(JarEntry je, InputStream is) {
            super(je);
            this.data.readFrom(is);
        }

        JarMapEntry(String s) {
            super(s);
        }
    }
}

