/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ZipAdjust {
    public static void adjust(File input, File output) throws IOException {
        try (RandomAccessFile in = new RandomAccessFile(input, "r");
             FileOutputStream out = new FileOutputStream(output);){
            ZipAdjust.adjust(in, out);
        }
    }

    public static void adjust(RandomAccessFile in, OutputStream out) throws IOException {
        CentralFooter footer = new CentralFooter(in);
        int outOff = 0;
        long centralOff = ZipAdjust.unsigned(footer.centralDirectoryOffset);
        CentralHeader[] centralHeaders = new CentralHeader[ZipAdjust.unsigned(footer.numEntries)];
        for (int i = 0; i < centralHeaders.length; ++i) {
            int read;
            in.seek(centralOff);
            centralHeaders[i] = new CentralHeader(in);
            centralOff = in.getFilePointer();
            in.seek(ZipAdjust.unsigned(centralHeaders[i].localHeaderOffset));
            LocalHeader localHeader = new LocalHeader(in);
            centralHeaders[i].localHeaderOffset = outOff;
            localHeader.flags = centralHeaders[i].flags = (short)(centralHeaders[i].flags & 0xFFFFFFF7);
            localHeader.crc32 = centralHeaders[i].crc32;
            localHeader.compressedSize = centralHeaders[i].compressedSize;
            localHeader.uncompressedSize = centralHeaders[i].uncompressedSize;
            localHeader.fileNameLength = centralHeaders[i].fileNameLength;
            localHeader.filename = centralHeaders[i].filename;
            outOff += localHeader.write(out);
            long len = ZipAdjust.unsigned(localHeader.compressedSize);
            outOff = (int)((long)outOff + len);
            byte[] data = new byte[4096];
            while ((read = in.read(data, 0, len < (long)data.length ? (int)len : data.length)) > 0) {
                out.write(data, 0, read);
                len -= (long)read;
            }
        }
        footer.centralDirectoryOffset = outOff;
        outOff = 0;
        for (CentralHeader header : centralHeaders) {
            outOff += header.write(out);
        }
        footer.centralDirectorySize = outOff;
        footer.write(out);
    }

    public static short unsigned(byte n) {
        return (short)(n & 0xFF);
    }

    public static int unsigned(short n) {
        return n & 0xFFFF;
    }

    public static long unsigned(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    static class LocalHeader {
        static final int MAGIC = 67324752;
        int signature;
        short versionNeededToExtract;
        short flags;
        short compressionMethod;
        short lastModFileTime;
        short lastModFileDate;
        int crc32;
        int compressedSize;
        int uncompressedSize;
        short fileNameLength;
        short extraFieldLength;
        byte[] filename;

        LocalHeader(RandomAccessFile file) throws IOException {
            byte[] buffer = new byte[30];
            file.read(buffer);
            ByteBuffer buf = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
            this.signature = buf.getInt();
            if (this.signature != 67324752) {
                throw new IOException();
            }
            this.versionNeededToExtract = buf.getShort();
            this.flags = buf.getShort();
            this.compressionMethod = buf.getShort();
            this.lastModFileTime = buf.getShort();
            this.lastModFileDate = buf.getShort();
            this.crc32 = buf.getInt();
            this.compressedSize = buf.getInt();
            this.uncompressedSize = buf.getInt();
            this.fileNameLength = buf.getShort();
            this.extraFieldLength = buf.getShort();
            file.skipBytes(ZipAdjust.unsigned(this.fileNameLength) + ZipAdjust.unsigned(this.extraFieldLength));
        }

        int write(OutputStream out) throws IOException {
            byte[] buffer = new byte[30];
            ByteBuffer buf = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt(this.signature);
            buf.putShort(this.versionNeededToExtract);
            buf.putShort(this.flags);
            buf.putShort(this.compressionMethod);
            buf.putShort(this.lastModFileTime);
            buf.putShort(this.lastModFileDate);
            buf.putInt(this.crc32);
            buf.putInt(this.compressedSize);
            buf.putInt(this.uncompressedSize);
            buf.putShort(this.fileNameLength);
            buf.putShort((short)0);
            out.write(buffer);
            out.write(this.filename);
            return buffer.length + this.filename.length;
        }
    }

    static class CentralHeader {
        static final int MAGIC = 33639248;
        int signature;
        short versionMadeBy;
        short versionNeededToExtract;
        short flags;
        short compressionMethod;
        short lastModFileTime;
        short lastModFileDate;
        int crc32;
        int compressedSize;
        int uncompressedSize;
        short fileNameLength;
        short extraFieldLength;
        short fileCommentLength;
        short diskNumberStart;
        short internalFileAttributes;
        int externalFileAttributes;
        int localHeaderOffset;
        byte[] filename;

        CentralHeader(RandomAccessFile file) throws IOException {
            byte[] buffer = new byte[46];
            file.read(buffer);
            ByteBuffer buf = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
            this.signature = buf.getInt();
            if (this.signature != 33639248) {
                throw new IOException();
            }
            this.versionMadeBy = buf.getShort();
            this.versionNeededToExtract = buf.getShort();
            this.flags = buf.getShort();
            this.compressionMethod = buf.getShort();
            this.lastModFileTime = buf.getShort();
            this.lastModFileDate = buf.getShort();
            this.crc32 = buf.getInt();
            this.compressedSize = buf.getInt();
            this.uncompressedSize = buf.getInt();
            this.fileNameLength = buf.getShort();
            this.extraFieldLength = buf.getShort();
            this.fileCommentLength = buf.getShort();
            this.diskNumberStart = buf.getShort();
            this.internalFileAttributes = buf.getShort();
            this.externalFileAttributes = buf.getInt();
            this.localHeaderOffset = buf.getInt();
            this.filename = new byte[ZipAdjust.unsigned(this.fileNameLength)];
            file.read(this.filename);
            file.skipBytes(ZipAdjust.unsigned(this.extraFieldLength) + ZipAdjust.unsigned(this.fileCommentLength));
        }

        int write(OutputStream out) throws IOException {
            byte[] buffer = new byte[46];
            ByteBuffer buf = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt(this.signature);
            buf.putShort(this.versionMadeBy);
            buf.putShort(this.versionNeededToExtract);
            buf.putShort(this.flags);
            buf.putShort(this.compressionMethod);
            buf.putShort(this.lastModFileTime);
            buf.putShort(this.lastModFileDate);
            buf.putInt(this.crc32);
            buf.putInt(this.compressedSize);
            buf.putInt(this.uncompressedSize);
            buf.putShort(this.fileNameLength);
            buf.putShort((short)0);
            buf.putShort((short)0);
            buf.putShort(this.diskNumberStart);
            buf.putShort(this.internalFileAttributes);
            buf.putInt(this.externalFileAttributes);
            buf.putInt(this.localHeaderOffset);
            out.write(buffer);
            out.write(this.filename);
            return buffer.length + this.filename.length;
        }
    }

    public static class CentralFooter {
        static final int MAGIC = 101010256;
        int signature;
        short diskNumber;
        short centralDirectoryDiskNumber;
        short numEntriesThisDisk;
        short numEntries;
        int centralDirectorySize;
        int centralDirectoryOffset;
        short zipCommentLength;

        CentralFooter(RandomAccessFile file) throws IOException {
            byte[] buffer = new byte[22];
            for (long i = file.length() - 4L; i >= 0L; --i) {
                file.seek(i);
                file.read(buffer, 0, 4);
                ByteBuffer buf = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
                this.signature = buf.getInt();
                if (this.signature != 101010256) continue;
                file.read(buffer, 4, buffer.length - 4);
                this.diskNumber = buf.getShort();
                this.centralDirectoryDiskNumber = buf.getShort();
                this.numEntriesThisDisk = buf.getShort();
                this.numEntries = buf.getShort();
                this.centralDirectorySize = buf.getInt();
                this.centralDirectoryOffset = buf.getInt();
                this.zipCommentLength = buf.getShort();
                break;
            }
        }

        int write(OutputStream out) throws IOException {
            byte[] buffer = new byte[22];
            ByteBuffer buf = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt(this.signature);
            buf.putShort(this.diskNumber);
            buf.putShort(this.centralDirectoryDiskNumber);
            buf.putShort(this.numEntriesThisDisk);
            buf.putShort(this.numEntries);
            buf.putInt(this.centralDirectorySize);
            buf.putInt(this.centralDirectoryOffset);
            buf.putShort((short)0);
            out.write(buffer);
            return buffer.length;
        }
    }
}

