/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts;

import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import chumbanotz.mutantbeasts.entity.mutant.SpiderPigEntity;
import chumbanotz.mutantbeasts.item.HulkHammerItem;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBParticles;
import chumbanotz.mutantbeasts.util.SeismicWave;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="mutantbeasts")
public class EventHandler {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityCreature) {
            EntityCreature creature = (EntityCreature)event.getEntity();
            if (creature instanceof EntityOcelot) {
                creature.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity(creature, MutantCreeperEntity.class, 16.0f, 0.8, 1.33));
            }
            if (creature instanceof EntityVillager) {
                creature.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity(creature, MutantZombieEntity.class, 12.0f, 0.8, 0.8));
            }
            if (creature.getClass() == EntityPig.class) {
                creature.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt(creature, 1.0, Items.field_151071_bq, false));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getEntityPlayer().func_184586_b(event.getHand());
        if (event.getTarget().getClass() == EntityPig.class && !((EntityPig)event.getTarget()).func_70644_a(MobEffects.field_189112_A) && stack.func_77973_b() == Items.field_151071_bq) {
            if (!event.getEntityPlayer().func_184812_l_()) {
                stack.func_190918_g(1);
            }
            ((EntityPig)event.getTarget()).func_70690_d(new PotionEffect(MobEffects.field_189112_A, 600, 13));
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (SpiderPigEntity.isPigOrSpider(event.getEntityLiving()) && event.getSource().func_76346_g() instanceof SpiderPigEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingUseItem(LivingEntityUseItemEvent.Tick event) {
        if (event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == MBItems.MUTANT_SKELETON_CHESTPLATE && event.getItem().func_77975_n() == EnumAction.BOW && event.getDuration() > 4) {
            event.setDuration(event.getDuration() - 3);
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && !HulkHammerItem.WAVES.isEmpty() && HulkHammerItem.WAVES.containsKey(event.player.func_110124_au())) {
            EntityPlayer player = event.player;
            List<SeismicWave> waveList = HulkHammerItem.WAVES.get(player.func_110124_au());
            while (waveList.size() > 16) {
                waveList.remove(0);
            }
            SeismicWave wave = waveList.remove(0);
            wave.affectBlocks(player.field_70170_p, (EntityLivingBase)player);
            AxisAlignedBB box = new AxisAlignedBB((double)wave.func_177958_n(), (double)(wave.func_177956_o() + 1), (double)wave.func_177952_p(), (double)(wave.func_177958_n() + 1), (double)(wave.func_177956_o() + 2), (double)(wave.func_177952_p() + 1));
            for (Entity entity : player.field_70170_p.func_72839_b((Entity)player, box)) {
                if (!entity.func_70067_L() || player.func_184187_bx() == entity || !entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)(6 + player.func_70681_au().nextInt(3)))) continue;
                if (entity instanceof EntityLivingBase) {
                    EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)player);
                }
                EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)entity);
            }
            if (waveList.isEmpty()) {
                HulkHammerItem.WAVES.remove(player.func_110124_au());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerShootArrow(ArrowLooseEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntityPlayer().func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == MBItems.MUTANT_SKELETON_SKULL && event.hasAmmo()) {
            int k;
            int j;
            boolean inAir;
            event.setCanceled(true);
            EntityPlayer player = event.getEntityPlayer();
            World world = event.getWorld();
            ItemStack bow = event.getBow();
            ItemStack arrowStack = EventHandler.findAmmo(player);
            boolean bl = inAir = !player.field_70122_E && !player.func_70090_H() && !player.func_180799_ab();
            if (arrowStack.func_190926_b()) {
                arrowStack = new ItemStack(Items.field_151032_g);
            }
            float velocity = ItemBow.func_185059_b((int)event.getCharge());
            boolean infiniteArrow = player.field_71075_bZ.field_75098_d || arrowStack.func_77973_b() instanceof ItemArrow && ((ItemArrow)arrowStack.func_77973_b()).isInfinite(arrowStack, bow, player);
            ItemArrow itemarrow = (ItemArrow)(arrowStack.func_77973_b() instanceof ItemArrow ? arrowStack.func_77973_b() : Items.field_151032_g);
            EntityArrow entityarrow = itemarrow.func_185052_a(world, arrowStack, (EntityLivingBase)player);
            entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity * 2.0f, 1.0f);
            if (velocity == 1.0f && inAir) {
                entityarrow.func_70243_d(true);
            }
            if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)bow)) > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bow)) > 0) {
                entityarrow.func_70240_a(k);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)bow) > 0) {
                entityarrow.func_70015_d(100);
            }
            entityarrow.func_70239_b(entityarrow.func_70242_d() * (inAir ? 2.0 : 0.5));
            bow.func_77972_a(1, (EntityLivingBase)player);
            if (infiniteArrow || player.field_71075_bZ.field_75098_d && (arrowStack.func_77973_b() == Items.field_185166_h || arrowStack.func_77973_b() == Items.field_185167_i)) {
                entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            }
            world.func_72838_d((Entity)entityarrow);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (player.func_70681_au().nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
            if (!infiniteArrow && !player.field_71075_bZ.field_75098_d) {
                arrowStack.func_190918_g(1);
                if (arrowStack.func_190926_b()) {
                    player.field_71071_by.func_184437_d(arrowStack);
                }
            }
            player.func_71029_a(StatList.func_188057_b((Item)bow.func_77973_b()));
        }
    }

    private static ItemStack findAmmo(EntityPlayer player) {
        if (player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof ItemArrow) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemArrow) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!(itemstack.func_77973_b() instanceof ItemArrow)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    public static void onPlayerToss(ItemTossEvent event) {
        World world = event.getPlayer().field_70170_p;
        EntityPlayer player = event.getPlayer();
        if (!world.field_72995_K) {
            boolean isHand;
            ItemStack stack = event.getEntityItem().func_92059_d();
            boolean bl = isHand = stack.func_77973_b() == MBItems.ENDERSOUL_HAND && stack.func_77951_h();
            if (stack.func_77973_b() == Items.field_151061_bv || isHand) {
                int count = 0;
                for (EndersoulFragmentEntity orb : world.func_72872_a(EndersoulFragmentEntity.class, player.func_174813_aQ().func_186662_g(8.0))) {
                    if (!orb.func_70089_S() || orb.getOwner() != player) continue;
                    ++count;
                    orb.func_70106_y();
                }
                if (count > 0) {
                    EntityUtil.sendParticlePacket((Entity)player, MBParticles.ENDERSOUL, 256);
                    int addDmg = count * 60;
                    if (isHand) {
                        int dmg = stack.func_77952_i() - addDmg;
                        stack.func_77964_b(Math.max(dmg, 0));
                    } else {
                        ItemStack newStack = new ItemStack(MBItems.ENDERSOUL_HAND);
                        newStack.func_77964_b(MBItems.ENDERSOUL_HAND.getMaxDamage(stack) - addDmg);
                        event.getEntityItem().func_92058_a(newStack);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedEntities().removeIf(entity -> entity instanceof EntityItem && ((EntityItem)entity).func_92059_d().func_77973_b() == MBItems.CREEPER_SHARD);
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mutantbeasts")) {
            ConfigManager.sync((String)"mutantbeasts", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

