/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.model;

import chumbanotz.mutantbeasts.MutantBeasts;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class EndersoulHandModel
extends ModelBase {
    public static final ResourceLocation GUI_LOCATION = new ModelResourceLocation(MutantBeasts.prefix("endersoul_hand_gui"), "inventory");
    public static final ResourceLocation MODEL_LOCATION = new ModelResourceLocation(MutantBeasts.prefix("endersoul_hand_model"), "inventory");
    private final ModelRenderer hand;
    private final ModelRenderer[] finger;
    private final ModelRenderer[] foreFinger;
    private final ModelRenderer thumb;

    public EndersoulHandModel() {
        int i;
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.finger = new ModelRenderer[3];
        this.foreFinger = new ModelRenderer[3];
        this.hand = new ModelRenderer((ModelBase)this);
        this.hand.func_78793_a(0.0f, 17.5f, 0.0f);
        float fingerScale = 0.6f;
        for (i = 0; i < this.finger.length; ++i) {
            this.finger[i] = new ModelRenderer((ModelBase)this, i * 4, 0);
            this.finger[i].func_78790_a(-0.5f, 0.0f, -0.5f, 1, i == 1 ? 6 : 5, 1, fingerScale);
        }
        this.finger[0].func_78793_a(-0.5f, 0.0f, -1.0f);
        this.finger[1].func_78793_a(-0.5f, 0.0f, 0.0f);
        this.finger[2].func_78793_a(-0.5f, 0.0f, 1.0f);
        for (i = 0; i < this.foreFinger.length; ++i) {
            this.foreFinger[i] = new ModelRenderer((ModelBase)this, 1 + i * 5, 0);
            this.foreFinger[i].func_78790_a(-0.5f, 0.0f, -0.5f, 1, i == 1 ? 6 : 5, 1, fingerScale - 0.01f);
            this.foreFinger[i].func_78793_a(0.0f, 0.5f + (float)(i == 1 ? 6 : 5), 0.0f);
        }
        for (i = 0; i < this.finger.length; ++i) {
            this.hand.func_78792_a(this.finger[i]);
            this.finger[i].func_78792_a(this.foreFinger[i]);
        }
        this.thumb = new ModelRenderer((ModelBase)this, 14, 0);
        this.thumb.func_78790_a(-0.5f, 0.0f, -0.5f, 1, 5, 1, fingerScale);
        this.thumb.func_78793_a(0.5f, 0.0f, -0.5f);
        this.hand.func_78792_a(this.thumb);
    }

    private void resetAngles(ModelRenderer model) {
        model.field_78795_f = 0.0f;
        model.field_78796_g = 0.0f;
        model.field_78808_h = 0.0f;
    }

    public void setAngles() {
        this.resetAngles(this.hand);
        for (int i = 0; i < this.finger.length; ++i) {
            this.resetAngles(this.finger[i]);
            this.resetAngles(this.foreFinger[i]);
        }
        this.resetAngles(this.thumb);
        this.hand.field_78796_g = -0.3926991f;
        this.finger[0].field_78795_f = -0.2617994f;
        this.finger[1].field_78808_h = 0.17453294f;
        this.finger[2].field_78795_f = 0.2617994f;
        this.foreFinger[0].field_78808_h = -0.2617994f;
        this.foreFinger[1].field_78808_h = -0.3926991f;
        this.foreFinger[2].field_78808_h = -0.2617994f;
        this.thumb.field_78795_f = -0.62831855f;
        this.thumb.field_78808_h = -0.3926991f;
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.setAngles();
        this.hand.func_78785_a(0.0625f);
    }

    public static class Baked
    extends BakedModelWrapper<IBakedModel> {
        private final IBakedModel bakedModel;

        public Baked(IBakedModel originalModel, IBakedModel bakedModel) {
            super(originalModel);
            this.bakedModel = bakedModel;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            if (cameraTransformType != ItemCameraTransforms.TransformType.GUI && cameraTransformType != ItemCameraTransforms.TransformType.GROUND && cameraTransformType != ItemCameraTransforms.TransformType.FIXED) {
                return this.bakedModel.handlePerspective(cameraTransformType);
            }
            return super.handlePerspective(cameraTransformType);
        }
    }

    public static class Unbaked
    implements IModel {
        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            try {
                IBakedModel originalModel = ModelLoaderRegistry.getModel((ResourceLocation)GUI_LOCATION).bake(state, format, bakedTextureGetter);
                IBakedModel bakedModel = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_LOCATION).bake(state, format, bakedTextureGetter);
                return new Baked(originalModel, bakedModel);
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to load models for the endersoul hand", exception);
            }
        }

        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.of((Object)GUI_LOCATION, (Object)MODEL_LOCATION);
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void func_110549_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("mutantbeasts") && modelLocation.func_110623_a().equals("endersoul_hand");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return new Unbaked();
        }
    }
}

