/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.model;

import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;

public class MutantZombieModel
extends ModelBase {
    private final ModelRenderer pelvis;
    private final ModelRenderer waist;
    private final ModelRenderer chest;
    private final ModelRenderer head;
    private final ModelRenderer arm1;
    private final ModelRenderer arm2;
    private final ModelRenderer forearm1;
    private final ModelRenderer forearm2;
    private final ModelRenderer leg1;
    private final ModelRenderer leg2;
    private final ModelRenderer foreleg1;
    private final ModelRenderer foreleg2;
    private float partialTick;

    public MutantZombieModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.pelvis = new ModelRenderer((ModelBase)this);
        this.pelvis.func_78793_a(0.0f, 10.0f, 6.0f);
        this.waist = new ModelRenderer((ModelBase)this, 0, 44);
        this.waist.func_78789_a(-7.0f, -16.0f, -6.0f, 14, 16, 12);
        this.pelvis.func_78792_a(this.waist);
        this.chest = new ModelRenderer((ModelBase)this, 0, 16);
        this.chest.func_78789_a(-12.0f, -12.0f, -8.0f, 24, 12, 16);
        this.chest.func_78793_a(0.0f, -12.0f, 0.0f);
        this.waist.func_78792_a(this.chest);
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78789_a(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.head.func_78793_a(0.0f, -11.0f, -4.0f);
        this.chest.func_78792_a(this.head);
        this.arm1 = new ModelRenderer((ModelBase)this, 104, 0);
        this.arm1.func_78789_a(-3.0f, 0.0f, -3.0f, 6, 16, 6);
        this.arm1.func_78793_a(-11.0f, -8.0f, 2.0f);
        this.chest.func_78792_a(this.arm1);
        this.arm2 = new ModelRenderer((ModelBase)this, 104, 0);
        this.arm2.field_78809_i = true;
        this.arm2.func_78789_a(-3.0f, 0.0f, -3.0f, 6, 16, 6);
        this.arm2.func_78793_a(11.0f, -8.0f, 2.0f);
        this.chest.func_78792_a(this.arm2);
        this.forearm1 = new ModelRenderer((ModelBase)this, 104, 22);
        this.forearm1.func_78790_a(-3.0f, 0.0f, -3.0f, 6, 16, 6, 0.1f);
        this.forearm1.func_78793_a(0.0f, 14.0f, 0.0f);
        this.arm1.func_78792_a(this.forearm1);
        this.forearm2 = new ModelRenderer((ModelBase)this, 104, 22);
        this.forearm2.field_78809_i = true;
        this.forearm2.func_78790_a(-3.0f, 0.0f, -3.0f, 6, 16, 6, 0.1f);
        this.forearm2.func_78793_a(0.0f, 14.0f, 0.0f);
        this.arm2.func_78792_a(this.forearm2);
        this.leg1 = new ModelRenderer((ModelBase)this, 80, 0);
        this.leg1.func_78789_a(-3.0f, 0.0f, -3.0f, 6, 11, 6);
        this.leg1.func_78793_a(-5.0f, -2.0f, 0.0f);
        this.pelvis.func_78792_a(this.leg1);
        this.leg2 = new ModelRenderer((ModelBase)this, 80, 0);
        this.leg2.field_78809_i = true;
        this.leg2.func_78789_a(-3.0f, 0.0f, -3.0f, 6, 11, 6);
        this.leg2.func_78793_a(5.0f, -2.0f, 0.0f);
        this.pelvis.func_78792_a(this.leg2);
        this.foreleg1 = new ModelRenderer((ModelBase)this, 80, 17);
        this.foreleg1.func_78790_a(-3.0f, 0.0f, -3.0f, 6, 8, 6, 0.1f);
        this.foreleg1.func_78793_a(0.0f, 9.5f, 0.0f);
        this.leg1.func_78792_a(this.foreleg1);
        this.foreleg2 = new ModelRenderer((ModelBase)this, 80, 17);
        this.foreleg2.field_78809_i = true;
        this.foreleg2.func_78790_a(-3.0f, 0.0f, -3.0f, 6, 8, 6, 0.1f);
        this.foreleg2.func_78793_a(0.0f, 9.5f, 0.0f);
        this.leg2.func_78792_a(this.foreleg2);
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.setAngles();
        this.animate((MutantZombieEntity)entity, f, f1, f2, f3, f4, f5);
        this.pelvis.func_78785_a(f5);
    }

    public void setAngles() {
        this.pelvis.field_78797_d = 10.0f;
        this.waist.field_78795_f = 0.19634955f;
        this.chest.field_78795_f = 0.5235988f;
        this.chest.field_78796_g = 0.0f;
        this.head.field_78795_f = -0.71994835f;
        this.head.field_78796_g = 0.0f;
        this.head.field_78808_h = 0.0f;
        this.arm1.field_78795_f = -0.32724923f;
        this.arm1.field_78796_g = 0.0f;
        this.arm1.field_78808_h = 0.3926991f;
        this.arm2.field_78795_f = -0.32724923f;
        this.arm2.field_78796_g = 0.0f;
        this.arm2.field_78808_h = -0.3926991f;
        this.forearm1.field_78795_f = -1.0471976f;
        this.forearm2.field_78795_f = -1.0471976f;
        this.leg1.field_78795_f = -0.7853982f;
        this.leg1.field_78796_g = 0.0f;
        this.leg1.field_78808_h = 0.0f;
        this.leg2.field_78795_f = -0.7853982f;
        this.leg2.field_78796_g = 0.0f;
        this.leg2.field_78808_h = 0.0f;
        this.foreleg1.field_78795_f = 0.7853982f;
        this.foreleg2.field_78795_f = 0.7853982f;
    }

    public void animate(MutantZombieEntity zombie, float f, float f1, float f2, float f3, float f4, float f5) {
        float walkAnim1 = (MathHelper.func_76126_a((float)((f - 0.7f) * 0.4f)) + 0.7f) * f1;
        float walkAnim2 = -(MathHelper.func_76126_a((float)((f + 0.7f) * 0.4f)) - 0.7f) * f1;
        float walkAnim = MathHelper.func_76126_a((float)(f * 0.4f)) * f1;
        float breatheAnim = MathHelper.func_76126_a((float)(f2 * 0.1f));
        float faceYaw = f3 * (float)Math.PI / 180.0f;
        float facePitch = f4 * (float)Math.PI / 180.0f;
        if (zombie.field_70725_aQ <= 0) {
            float scale;
            if (zombie.getAttackID() == 1) {
                this.animateMelee(zombie.getAttackTick());
            }
            if (zombie.getAttackID() == 3) {
                this.animateRoar(zombie.getAttackTick());
                scale = 1.0f - MathHelper.func_76131_a((float)((float)zombie.getAttackTick() / 6.0f), (float)0.0f, (float)1.0f);
                walkAnim1 *= scale;
                walkAnim2 *= scale;
                walkAnim *= scale;
                facePitch *= scale;
            }
            if (zombie.getAttackID() == 2) {
                this.animateThrow(zombie);
                scale = 1.0f - MathHelper.func_76131_a((float)((float)zombie.getAttackTick() / 3.0f), (float)0.0f, (float)1.0f);
                walkAnim1 *= scale;
                walkAnim2 *= scale;
                walkAnim *= scale;
                facePitch *= scale;
            }
        } else {
            this.animateDeath(zombie);
            float scale = 1.0f - MathHelper.func_76131_a((float)((float)zombie.field_70725_aQ / 6.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim *= scale;
            breatheAnim *= scale;
            faceYaw *= scale;
            facePitch *= scale;
        }
        this.chest.field_78795_f += breatheAnim * 0.02f;
        this.arm1.field_78808_h -= breatheAnim * 0.05f;
        this.arm2.field_78808_h += breatheAnim * 0.05f;
        this.head.field_78795_f += facePitch * 0.6f;
        this.head.field_78796_g += faceYaw * 0.8f;
        this.head.field_78808_h -= faceYaw * 0.2f;
        this.chest.field_78795_f += facePitch * 0.4f;
        this.chest.field_78796_g += faceYaw * 0.2f;
        this.pelvis.field_78797_d += MathHelper.func_76126_a((float)(f * 0.8f)) * f1 * 0.5f;
        this.chest.field_78796_g -= walkAnim * 0.1f;
        this.arm1.field_78795_f -= walkAnim * 0.6f;
        this.arm2.field_78795_f += walkAnim * 0.6f;
        this.leg1.field_78795_f += walkAnim1 * 0.9f;
        this.leg2.field_78795_f += walkAnim2 * 0.9f;
    }

    protected void animateMelee(int fullTick) {
        this.arm1.field_78808_h = 0.0f;
        this.arm2.field_78808_h = 0.0f;
        if (fullTick < 8) {
            float tick = ((float)fullTick + this.partialTick) / 8.0f;
            float f = -MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_78795_f += f * 0.2f;
            this.chest.field_78795_f += f * 0.2f;
            this.arm1.field_78795_f += f * 2.3f;
            this.arm1.field_78808_h += f1 * (float)Math.PI / 8.0f;
            this.arm2.field_78795_f += f * 2.3f;
            this.arm2.field_78808_h -= f1 * (float)Math.PI / 8.0f;
            this.forearm1.field_78795_f += f * 0.8f;
            this.forearm2.field_78795_f += f * 0.8f;
        } else if (fullTick < 12) {
            float tick = ((float)(fullTick - 8) + this.partialTick) / 4.0f;
            float f = -MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_78795_f += f * 0.9f + 0.7f;
            this.chest.field_78795_f += f * 0.9f + 0.7f;
            this.arm1.field_78795_f += f * 0.2f - 2.1f;
            this.arm1.field_78808_h += f1 * 0.3f;
            this.arm2.field_78795_f += f * 0.2f - 2.1f;
            this.arm2.field_78808_h -= f1 * 0.3f;
            this.forearm1.field_78795_f += f * 1.0f + 0.2f;
            this.forearm2.field_78795_f += f * 1.0f + 0.2f;
        } else if (fullTick < 16) {
            this.waist.field_78795_f += 0.7f;
            this.chest.field_78795_f += 0.7f;
            this.arm1.field_78795_f -= 2.1f;
            this.arm1.field_78808_h += 0.3f;
            this.arm2.field_78795_f -= 2.1f;
            this.arm2.field_78808_h -= 0.3f;
            this.forearm1.field_78795_f += 0.2f;
            this.forearm2.field_78795_f += 0.2f;
        } else if (fullTick < 24) {
            float tick = ((float)(fullTick - 16) + this.partialTick) / 8.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_78795_f += f * 0.7f;
            this.chest.field_78795_f += f * 0.7f;
            this.arm1.field_78795_f -= f * 2.1f;
            this.arm1.field_78808_h += f * -0.09269908f + 0.3926991f;
            this.arm2.field_78795_f -= f * 2.1f;
            this.arm2.field_78808_h -= f * -0.09269908f + 0.3926991f;
            this.forearm1.field_78795_f += f * 0.2f;
            this.forearm2.field_78795_f += f * 0.2f;
        } else {
            this.arm1.field_78808_h += 0.3926991f;
            this.arm2.field_78808_h += -0.3926991f;
        }
    }

    protected void animateRoar(int fullTick) {
        float f1;
        float f;
        float tick;
        if (fullTick < 10) {
            tick = ((float)fullTick + this.partialTick) / 10.0f;
            f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI * (float)Math.PI / 8.0f));
            this.waist.field_78795_f += f * 0.2f;
            this.chest.field_78795_f += f * 0.4f;
            this.chest.field_78796_g += f1 * 0.06f;
            this.head.field_78795_f += f * 0.8f;
            this.arm1.field_78795_f -= f * 1.2f;
            this.arm1.field_78808_h += f * 0.6f;
            this.arm2.field_78795_f -= f * 1.2f;
            this.arm2.field_78808_h -= f * 0.6f;
            this.forearm1.field_78795_f -= f * 0.8f;
            this.forearm2.field_78795_f -= f * 0.8f;
        } else if (fullTick < 15) {
            tick = ((float)(fullTick - 10) + this.partialTick) / 5.0f;
            f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_78795_f += f * 0.39634955f - 0.19634955f;
            this.chest.field_78795_f += f * 0.6f - 0.2f;
            this.head.field_78795_f += f * 1.0f - 0.2f;
            this.arm1.field_78795_f -= f * 2.2f - 1.0f;
            this.arm1.field_78796_g += f1 * 0.4f;
            this.arm1.field_78808_h += 0.6f;
            this.arm2.field_78795_f -= f * 2.2f - 1.0f;
            this.arm2.field_78796_g -= f1 * 0.4f;
            this.arm2.field_78808_h -= 0.6f;
            this.forearm1.field_78795_f -= f * 1.0f - 0.2f;
            this.forearm2.field_78795_f -= f * 1.0f - 0.2f;
            this.leg1.field_78796_g += f1 * 0.3f;
            this.leg2.field_78796_g -= f1 * 0.3f;
        } else if (fullTick < 75) {
            this.waist.field_78795_f -= 0.19634955f;
            this.chest.field_78795_f -= 0.2f;
            this.head.field_78795_f -= 0.2f;
            this.addRotation(this.arm1, 1.0f, 0.4f, 0.6f);
            this.addRotation(this.arm2, 1.0f, -0.4f, -0.6f);
            this.forearm1.field_78795_f += 0.2f;
            this.forearm2.field_78795_f += 0.2f;
            this.leg1.field_78796_g += 0.3f;
            this.leg2.field_78796_g -= 0.3f;
        } else if (fullTick < 90) {
            tick = ((float)(fullTick - 75) + this.partialTick) / 15.0f;
            f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_78795_f -= f * 0.69634956f - 0.5f;
            this.chest.field_78795_f -= f * 0.7f - 0.5f;
            this.head.field_78795_f -= f * 0.6f - 0.4f;
            this.addRotation(this.arm1, f * 2.6f - 1.6f, f * 0.4f, f * 0.99269915f - 0.3926991f);
            this.addRotation(this.arm2, f * 2.6f - 1.6f, -f * 0.4f, -f * 0.99269915f + 0.3926991f);
            this.forearm1.field_78795_f += f * -0.6f + 0.8f;
            this.forearm2.field_78795_f += f * -0.6f + 0.8f;
            this.leg1.field_78796_g += f * 0.3f;
            this.leg2.field_78796_g -= f * 0.3f;
        } else if (fullTick < 110) {
            this.waist.field_78795_f += 0.5f;
            this.chest.field_78795_f += 0.5f;
            this.head.field_78795_f += 0.4f;
            this.addRotation(this.arm1, -1.6f, 0.0f, -0.3926991f);
            this.addRotation(this.arm2, -1.6f, 0.0f, 0.3926991f);
            this.forearm1.field_78795_f += 0.8f;
            this.forearm2.field_78795_f += 0.8f;
        } else {
            tick = ((float)(fullTick - 110) + this.partialTick) / 10.0f;
            f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_78795_f += f * 0.5f;
            this.chest.field_78795_f += f * 0.5f;
            this.head.field_78795_f += f * 0.4f;
            this.addRotation(this.arm1, f * -1.6f, 0.0f, f * (float)(-Math.PI) / 8.0f);
            this.addRotation(this.arm2, f * -1.6f, 0.0f, f * (float)Math.PI / 8.0f);
            this.forearm1.field_78795_f += f * 0.8f;
            this.forearm2.field_78795_f += f * 0.8f;
        }
        if (fullTick >= 10 && fullTick < 75) {
            tick = ((float)(fullTick - 10) + this.partialTick) / 65.0f;
            f = MathHelper.func_76126_a((float)(tick * (float)Math.PI * 8.0f));
            f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI * 8.0f + 0.7853982f));
            this.head.field_78796_g += f * 0.5f - f1 * 0.2f;
            this.head.field_78808_h -= f * 0.5f;
            this.chest.field_78796_g += f1 * 0.06f;
        }
    }

    protected void animateThrow(MutantZombieEntity zombie) {
        if (zombie.getAttackTick() < 3) {
            float tick = ((float)zombie.getAttackTick() + this.partialTick) / 3.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.chest.field_78795_f -= f * 0.4f;
            this.arm1.field_78795_f -= f * 1.8f;
            this.arm1.field_78808_h -= f * (float)Math.PI / 8.0f;
            this.arm2.field_78795_f -= f * 1.8f;
            this.arm2.field_78808_h += f * (float)Math.PI / 8.0f;
        } else if (zombie.getAttackTick() < 5) {
            this.chest.field_78795_f -= 0.4f;
            this.arm1.field_78795_f -= 1.0f;
            this.arm1.field_78808_h = 0.0f;
            this.arm2.field_78795_f -= 1.0f;
            this.arm2.field_78808_h = 0.0f;
        } else if (zombie.getAttackTick() < 8) {
            float tick = ((float)(zombie.getAttackTick() - 5) + this.partialTick) / 3.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_78795_f += f1 * 0.2f;
            this.chest.field_78795_f -= f * 0.6f - 0.2f;
            this.arm1.field_78795_f -= f * 2.2f - 0.4f;
            this.arm1.field_78808_h -= f * (float)Math.PI / 8.0f;
            this.arm2.field_78795_f -= f * 2.2f - 0.4f;
            this.arm2.field_78808_h += f * (float)Math.PI / 8.0f;
            this.forearm1.field_78795_f -= f1 * 0.4f;
            this.forearm2.field_78795_f -= f1 * 0.4f;
        } else if (zombie.getAttackTick() < 10) {
            this.waist.field_78795_f += 0.2f;
            this.chest.field_78795_f += 0.2f;
            this.arm1.field_78795_f += 0.4f;
            this.arm2.field_78795_f += 0.4f;
            this.forearm1.field_78795_f -= 0.4f;
            this.forearm2.field_78795_f -= 0.4f;
        } else if (zombie.getAttackTick() < 15) {
            float tick = ((float)(zombie.getAttackTick() - 10) + this.partialTick) / 5.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_78795_f += f * 0.39634955f - 0.19634955f;
            this.chest.field_78795_f += f * 0.8f - 0.6f;
            this.arm1.field_78795_f += f * 3.0f - 2.6f;
            this.arm2.field_78795_f += f * 3.0f - 2.6f;
            this.forearm1.field_78795_f -= f * 0.4f;
            this.forearm2.field_78795_f -= f * 0.4f;
            this.leg1.field_78795_f += f1 * 0.6f;
            this.leg2.field_78795_f += f1 * 0.6f;
        } else if (zombie.throwHitTick == -1) {
            this.waist.field_78795_f -= 0.19634955f;
            this.chest.field_78795_f -= 0.6f;
            this.arm1.field_78795_f -= 2.6f;
            this.arm2.field_78795_f -= 2.6f;
            this.leg1.field_78795_f += 0.6f;
            this.leg2.field_78795_f += 0.6f;
        } else if (zombie.throwHitTick < 5) {
            float tick = ((float)zombie.throwHitTick + this.partialTick) / 3.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_78795_f -= f * 0.39634955f - 0.2f;
            this.chest.field_78795_f -= f * 0.8f - 0.2f;
            this.addRotation(this.arm1, -(f * 2.2f + 0.4f), -f1 * (float)Math.PI / 8.0f, f1 * 0.4f);
            this.addRotation(this.arm2, -(f * 2.2f + 0.4f), f1 * (float)Math.PI / 8.0f, -f1 * 0.4f);
            this.forearm1.field_78795_f += f1 * 0.2f;
            this.forearm2.field_78795_f += f1 * 0.2f;
            this.leg1.field_78795_f += f * 0.8f - 0.2f;
            this.leg2.field_78795_f += f * 0.8f - 0.2f;
        } else if (zombie.throwFinishTick == -1) {
            this.waist.field_78795_f += 0.2f;
            this.chest.field_78795_f += 0.2f;
            this.addRotation(this.arm1, -0.4f, -0.3926991f, 0.4f);
            this.addRotation(this.arm2, -0.4f, 0.3926991f, -0.4f);
            this.forearm1.field_78795_f += 0.2f;
            this.forearm2.field_78795_f += 0.2f;
            this.leg1.field_78795_f -= 0.2f;
            this.leg2.field_78795_f -= 0.2f;
        } else if (zombie.throwFinishTick < 10) {
            float tick = ((float)zombie.throwFinishTick + this.partialTick) / 10.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_78795_f += f * 0.2f;
            this.chest.field_78795_f += f * 0.2f;
            this.addRotation(this.arm1, -f * 0.4f, -f * (float)Math.PI / 8.0f, f * 0.4f);
            this.addRotation(this.arm1, -f * 0.4f, f * (float)Math.PI / 8.0f, -f * 0.4f);
            this.forearm1.field_78795_f += f * 0.2f;
            this.forearm2.field_78795_f += f * 0.2f;
            this.leg1.field_78795_f -= f * 0.2f;
            this.leg2.field_78795_f -= f * 0.2f;
        }
    }

    protected void animateDeath(MutantZombieEntity zombie) {
        if (zombie.field_70725_aQ <= 20) {
            float tick = ((float)zombie.field_70725_aQ + this.partialTick - 1.0f) / 20.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.pelvis.field_78797_d += f * 28.0f;
            this.head.field_78795_f -= f * (float)Math.PI / 10.0f;
            this.head.field_78796_g += f * (float)Math.PI / 5.0f;
            this.chest.field_78795_f -= f * (float)Math.PI / 12.0f;
            this.waist.field_78795_f -= f * (float)Math.PI / 10.0f;
            this.arm1.field_78795_f -= f * (float)Math.PI / 2.0f;
            this.arm1.field_78796_g += f * (float)Math.PI / 2.8f;
            this.arm2.field_78795_f -= f * (float)Math.PI / 2.0f;
            this.arm2.field_78796_g -= f * (float)Math.PI / 2.8f;
            this.leg1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.leg1.field_78808_h += f * (float)Math.PI / 12.0f;
            this.leg2.field_78795_f += f * (float)Math.PI / 6.0f;
            this.leg2.field_78808_h -= f * (float)Math.PI / 12.0f;
        } else if (zombie.field_70725_aQ <= 100) {
            this.pelvis.field_78797_d += 28.0f;
            this.head.field_78795_f -= 0.31415927f;
            this.head.field_78796_g += 0.62831855f;
            this.chest.field_78795_f -= 0.2617994f;
            this.waist.field_78795_f -= 0.31415927f;
            this.arm1.field_78795_f = (float)((double)this.arm1.field_78795_f - 1.57079635);
            this.arm1.field_78796_g = (float)((double)this.arm1.field_78796_g + 1.12199739);
            this.arm2.field_78795_f = (float)((double)this.arm2.field_78795_f - 1.57079635);
            this.arm2.field_78796_g = (float)((double)this.arm2.field_78796_g - 1.12199739);
            this.leg1.field_78795_f += 0.5235988f;
            this.leg1.field_78808_h += 0.2617994f;
            this.leg2.field_78795_f += 0.5235988f;
            this.leg2.field_78808_h -= 0.2617994f;
        } else {
            float tick = ((float)(40 - (140 - zombie.field_70725_aQ)) + this.partialTick) / 40.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.pelvis.field_78797_d += f * 28.0f;
            this.head.field_78795_f -= f * (float)Math.PI / 10.0f;
            this.head.field_78796_g += f * (float)Math.PI / 5.0f;
            this.chest.field_78795_f -= f * (float)Math.PI / 12.0f;
            this.waist.field_78795_f -= f * (float)Math.PI / 10.0f;
            this.arm1.field_78795_f -= f * (float)Math.PI / 2.0f;
            this.arm1.field_78796_g += f * (float)Math.PI / 2.8f;
            this.arm2.field_78795_f -= f * (float)Math.PI / 2.0f;
            this.arm2.field_78796_g -= f * (float)Math.PI / 2.8f;
            this.leg1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.leg1.field_78808_h += f * (float)Math.PI / 12.0f;
            this.leg2.field_78795_f += f * (float)Math.PI / 6.0f;
            this.leg2.field_78808_h -= f * (float)Math.PI / 12.0f;
        }
    }

    public void addRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f += x;
        model.field_78796_g += y;
        model.field_78808_h += z;
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public void func_78086_a(EntityLivingBase entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.partialTick = partialTick;
    }
}

