/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.model.MutantSnowGolemModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class MutantSnowGolemRenderer
extends RenderLiving<MutantSnowGolemEntity> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_snow_golem/mutant_snow_golem");
    private static final ResourceLocation PUMPKIN_TEXTURE = MutantBeasts.getEntityTexture("mutant_snow_golem/pumpkin");
    private static final ResourceLocation GLOW_TEXTURE = MutantBeasts.getEntityTexture("mutant_snow_golem/glow");

    public MutantSnowGolemRenderer(RenderManager manager) {
        super(manager, (ModelBase)new MutantSnowGolemModel(), 0.7f);
        this.func_177094_a(new PumpkinLayer());
        this.func_177094_a(new GlowLayer());
        this.func_177094_a(new HeldBlockLayer());
    }

    public void renderName(MutantSnowGolemEntity entity, double x, double y, double z) {
        super.func_177067_a((EntityLivingBase)entity, x, y, z);
        if (entity.getOwner() != null) {
            ITextComponent textComponent = entity.getOwner().func_145748_c_();
            textComponent.func_150256_b().func_150217_b(Boolean.valueOf(true));
            if (this.func_177070_b((EntityLiving)entity)) {
                y += (double)((float)this.func_76983_a().field_78288_b * 1.15f * 0.025f);
            }
            super.func_188296_a((Entity)entity, x, y, z, textComponent.func_150254_d(), (double)NAME_TAG_RANGE);
        }
    }

    public MutantSnowGolemModel getMainModel() {
        return (MutantSnowGolemModel)super.func_177087_b();
    }

    protected ResourceLocation getEntityTexture(MutantSnowGolemEntity entity) {
        return TEXTURE;
    }

    class HeldBlockLayer
    implements LayerRenderer<MutantSnowGolemEntity> {
        HeldBlockLayer() {
        }

        public void doRenderLayer(MutantSnowGolemEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (entityIn.func_70089_S() && entityIn.isThrowing() && entityIn.getThrowingTick() < 7) {
                GlStateManager.func_179091_B();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.4f, (float)0.0f, (float)0.0f);
                MutantSnowGolemRenderer.this.getMainModel().postRenderArm(0.0625f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.9f, (float)0.0f);
                GlStateManager.func_179152_a((float)-0.8f, (float)-0.8f, (float)0.8f);
                int i = entityIn.func_70070_b();
                int j = i % 65536;
                int k = i / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                MutantSnowGolemRenderer.this.func_110776_a(TextureMap.field_110575_b);
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.5f);
                Minecraft.func_71410_x().func_175602_ab().func_175016_a(Blocks.field_150432_aD.func_176223_P(), 1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179101_C();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    class GlowLayer
    implements LayerRenderer<MutantSnowGolemEntity> {
        GlowLayer() {
        }

        public void doRenderLayer(MutantSnowGolemEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (entityIn.isPumpkinEquipped()) {
                MutantSnowGolemRenderer.this.func_110776_a(GLOW_TEXTURE);
                GlStateManager.func_179140_f();
                GlStateManager.func_179132_a((!entityIn.func_82150_aj() ? 1 : 0) != 0);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)61680.0f, (float)0.0f);
                float f1 = MathHelper.func_76134_b((float)(ageInTicks * 0.1f));
                float f2 = MathHelper.func_76134_b((float)(ageInTicks * 0.15f));
                GlStateManager.func_179131_c((float)1.0f, (float)(0.8f + 0.05f * f2), (float)(0.15f + 0.2f * f1), (float)1.0f);
                Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
                MutantSnowGolemRenderer.this.field_77045_g.func_78088_a((Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                MutantSnowGolemRenderer.this.func_177105_a((EntityLiving)entityIn);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179145_e();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    class PumpkinLayer
    implements LayerRenderer<MutantSnowGolemEntity> {
        PumpkinLayer() {
        }

        public void doRenderLayer(MutantSnowGolemEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (entityIn.isPumpkinEquipped() && !entityIn.func_82150_aj()) {
                MutantSnowGolemRenderer.this.func_110776_a(PUMPKIN_TEXTURE);
                MutantSnowGolemRenderer.this.getMainModel().func_78088_a((Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

