/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.model.MutantZombieModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class MutantZombieRenderer
extends RenderLiving<MutantZombieEntity> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_zombie");

    public MutantZombieRenderer(RenderManager manager) {
        super(manager, (ModelBase)new MutantZombieModel(), 1.0f);
    }

    protected void renderModel(MutantZombieEntity living, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        if (living.vanishTime > 0) {
            GlStateManager.func_179108_z();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - ((float)living.vanishTime + ((MutantZombieModel)this.field_77045_g).getPartialTick()) / 100.0f * 0.6f));
        }
        super.func_77036_a((EntityLivingBase)living, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        if (living.vanishTime > 0) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void preRenderCallback(MutantZombieEntity entitylivingbaseIn, float partialTickTime) {
        GlStateManager.func_179152_a((float)1.3f, (float)1.3f, (float)1.3f);
    }

    protected void applyRotations(MutantZombieEntity entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        if (entityLiving.field_70725_aQ > 0) {
            GlStateManager.func_179114_b((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            int pitch = Math.min(20, entityLiving.field_70725_aQ);
            boolean reviving = false;
            if (entityLiving.field_70725_aQ > 100) {
                pitch = 140 - entityLiving.field_70725_aQ;
                reviving = true;
            }
            if (pitch > 0) {
                float f = ((float)pitch + partialTicks - 1.0f) / 20.0f * 1.6f;
                if (reviving) {
                    f = ((float)pitch - partialTicks) / 40.0f * 1.6f;
                }
                if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                GlStateManager.func_179114_b((float)(f * this.getDeathMaxRotation(entityLiving)), (float)-1.0f, (float)0.0f, (float)0.0f);
            }
        } else {
            super.func_77043_a((EntityLivingBase)entityLiving, ageInTicks, rotationYaw, partialTicks);
        }
    }

    protected float getDeathMaxRotation(MutantZombieEntity living) {
        return 80.0f;
    }

    protected ResourceLocation getEntityTexture(MutantZombieEntity entity) {
        return TEXTURE;
    }
}

