/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity;

import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.MutatedExplosion;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class CreeperMinionEggEntity
extends Entity
implements IEntityOwnable {
    private static final DataParameter<Boolean> CHARGED = EntityDataManager.func_187226_a(CreeperMinionEggEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private int health = 8;
    private int age = (60 + this.field_70146_Z.nextInt(40)) * 1200;
    private int recentlyHit;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private UUID ownerUUID;

    public CreeperMinionEggEntity(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(0.5625f, 0.75f);
    }

    public CreeperMinionEggEntity(MutantCreeperEntity spawner, EntityPlayer owner) {
        this(spawner.field_70170_p);
        this.ownerUUID = owner.func_110124_au();
        this.func_70107_b(spawner.field_70165_t, spawner.field_70163_u, spawner.field_70161_v);
        if (spawner.func_70830_n()) {
            this.setCharged(true);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CHARGED, (Object)false);
    }

    public boolean isCharged() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGED);
    }

    private void setCharged(boolean charged) {
        this.field_70180_af.func_187227_b(CHARGED, (Object)charged);
    }

    public EntityPlayer getOwner() {
        return this.ownerUUID == null ? null : this.field_70170_p.func_152378_a(this.ownerUUID);
    }

    public UUID func_184753_b() {
        return this.ownerUUID;
    }

    public double func_70033_W() {
        if (this.func_184187_bx() instanceof EntityPlayer) {
            return (double)this.field_70131_O - (this.func_184187_bx().func_70093_af() ? 0.3 : 0.2);
        }
        return 0.0;
    }

    public double func_70042_X() {
        return this.field_70131_O;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.func_70104_M() ? entity.func_174813_aQ() : null;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return !this.field_70128_L;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean func_85031_j(Entity entityIn) {
        return entityIn == this.func_184187_bx();
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.func_180426_a(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    public void func_70016_h(double x, double y, double z) {
        super.func_70016_h(x, y, z);
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
    }

    private void hatch() {
        EntityPlayer player;
        CreeperMinionEntity minion = new CreeperMinionEntity(this.field_70170_p);
        if (this.ownerUUID != null && (player = this.getOwner()) != null && !ForgeEventFactory.onAnimalTame((EntityAnimal)minion, (EntityPlayer)player)) {
            minion.func_193101_c(player);
            minion.func_70907_r().func_75270_a(true);
            player.func_130011_c(null);
        }
        if (this.isCharged()) {
            minion.setPowered(true);
        }
        minion.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70170_p.func_72838_d((Entity)minion);
        this.func_184185_a(MBSoundEvents.ENTITY_CREEPER_MINION_EGG_HATCH, 0.7f, 0.9f + this.field_70146_Z.nextFloat() * 0.1f);
        this.func_70106_y();
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.setCharged(true);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
        }
        if (this.func_184218_aH() && (this.func_70094_T() || this.func_184187_bx() instanceof EntityPlayer && (((EntityPlayer)this.func_184187_bx()).func_184613_cA() || ((EntityPlayer)this.func_184187_bx()).func_70608_bn()))) {
            this.playMountSound(false);
            this.func_184210_p();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.health < 8 && this.field_70173_aa - this.recentlyHit > 80 && this.field_70173_aa % 20 == 0) {
                ++this.health;
            }
            if (--this.age <= 0) {
                this.hatch();
            }
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.func_184218_aH() && player == this.func_184187_bx()) {
            this.playMountSound(false);
            this.getEntityToRide((Entity)player).func_184210_p();
            return true;
        }
        if (!player.func_184613_cA()) {
            this.func_184205_a(this.getEntityToRide((Entity)player), true);
            this.playMountSound(true);
            return true;
        }
        return false;
    }

    private Entity getEntityToRide(Entity entity) {
        List passengers = entity.func_184188_bt();
        return !passengers.isEmpty() ? this.getEntityToRide((Entity)passengers.get(0)) : entity;
    }

    private void playMountSound(boolean mount) {
        this.func_184185_a(SoundEvents.field_187638_cR, 0.7f, (mount ? 0.6f : 0.3f) + this.field_70146_Z.nextFloat() * 0.1f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || source.func_76346_g() == this.func_184187_bx()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && this.field_70173_aa > 0) {
            this.func_70018_K();
            if (source.func_94541_c()) {
                this.age -= (int)(amount * 80.0f);
                EntityUtil.sendParticlePacket(this, EnumParticleTypes.HEART, (int)(amount / 2.0f));
                return false;
            }
            this.recentlyHit = this.field_70173_aa;
            this.field_70181_x = 0.2f;
            this.health -= (int)amount;
            if (this.health <= 0) {
                MutatedExplosion.create(this, this.isCharged() ? 2.0f : 0.0f, false, true);
                if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    if (this.isCharged() || this.field_70146_Z.nextInt(3) == 0) {
                        this.func_145779_a(MBItems.CREEPER_SHARD, 1);
                    } else {
                        for (int j = 5 + this.field_70146_Z.nextInt(6); j > 0; --j) {
                            this.func_145779_a(Items.field_151016_H, 1);
                        }
                    }
                }
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Health", this.health);
        compound.func_74768_a("Age", this.age);
        if (this.isCharged()) {
            compound.func_74757_a("Charged", true);
        }
        if (this.ownerUUID != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUUID);
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.health = compound.func_74762_e("Health");
        if (compound.func_74764_b("Age")) {
            this.age = compound.func_74762_e("Age");
        }
        this.setCharged(compound.func_74767_n("Charged"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.ownerUUID = compound.func_186857_a("OwnerUUID");
        }
    }
}

