/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.entity.ai.EntityAIAvoidDamage;
import chumbanotz.mutantbeasts.entity.ai.EntityAIFleeRain;
import chumbanotz.mutantbeasts.entity.ai.EntityAIHurtByNearestTarget;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;

public class MutantSnowGolemEntity
extends EntityGolem
implements IRangedAttackMob,
IEntityOwnable,
IShearable {
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(MutantSnowGolemEntity.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Byte> DATA_FLAGS = EntityDataManager.func_187226_a(MutantSnowGolemEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    private boolean isThrowing;
    private int throwingTick;

    public MutantSnowGolemEntity(World worldIn) {
        super(worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_70105_a(1.1f, 2.2f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new SwimJumpGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFleeRain((EntityCreature)this, 1.1f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new ThrowIceGoal());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, (double)1.1f, 30, 12.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, (double)1.1f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoidDamage((EntityCreature)this, 1.1f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByNearestTarget((EntityCreature)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, true, false, entity -> IMob.field_82192_a.apply(entity) && (!(entity instanceof EntityCreeper) || ((EntityCreeper)entity).func_70638_az() == this)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(DATA_FLAGS, (Object)1);
    }

    @Nullable
    public EntityPlayer getOwner() {
        UUID uuid = this.func_184753_b();
        return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)uuid));
    }

    public boolean isPumpkinEquipped() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS) & 1) != 0;
    }

    public void setPumpkinEquipped(boolean pumpkinEquipped) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS);
        this.field_70180_af.func_187227_b(DATA_FLAGS, (Object)(pumpkinEquipped ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean getSwimJump() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS) & 4) != 0;
    }

    public void setSwimJump(boolean swimJump) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS);
        this.field_70180_af.func_187227_b(DATA_FLAGS, (Object)(swimJump ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((EntityLiving)this, worldIn).setAvoidRain(true);
    }

    public float func_70047_e() {
        return 2.0f;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return super.func_70686_a(cls) && IMob.class.isAssignableFrom(cls);
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.getSwimJump()) {
            EntityUtil.spawnParticleAtEntity((EntityLivingBase)this, EnumParticleTypes.SNOWBALL, 6, new int[0]);
            EntityUtil.spawnParticleAtEntity((EntityLivingBase)this, EnumParticleTypes.WATER_SPLASH, 6, new int[0]);
        }
        if (this.isThrowing && this.throwingTick++ >= 20) {
            this.isThrowing = false;
            this.throwingTick = 0;
        }
        if (this.field_70173_aa % 20 == 0 && this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.field_70170_p.field_73011_w.func_177495_o()) {
            if (this.field_70146_Z.nextFloat() > Math.min(80.0f, this.func_110143_aJ()) * 0.01f) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_DROP, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.5f) - (double)this.field_70130_N, this.field_70163_u - 0.15 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.5f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.field_70173_aa % 60 == 0) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
        } else if (!this.field_70170_p.field_72995_K && this.field_70122_E && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos posDown = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos posUp = new BlockPos.MutableBlockPos();
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    boolean placeIce;
                    if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                    pos.func_181079_c(MathHelper.func_76128_c((double)this.field_70165_t) + i, MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v) + j);
                    posDown.func_189533_g((Vec3i)pos).func_185336_p(pos.func_177956_o() - 1);
                    posUp.func_189533_g((Vec3i)pos).func_185336_p(pos.func_177956_o() + 1);
                    boolean placeSnow = this.field_70170_p.func_180494_b((BlockPos)pos).func_180626_a((BlockPos)pos) < 0.95f && this.field_70170_p.func_175623_d((BlockPos)pos) && Blocks.field_150431_aC.func_176196_c(this.field_70170_p, (BlockPos)pos);
                    boolean bl = placeIce = this.field_70170_p.func_180495_p((BlockPos)posDown).func_177230_c() == Blocks.field_150355_j || this.field_70170_p.func_180495_p((BlockPos)posDown).func_177230_c() == Blocks.field_150358_i;
                    if (this.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c() == Blocks.field_150358_i) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (this.field_70170_p.func_180495_p((BlockPos)posUp).func_177230_c() == Blocks.field_150358_i) {
                        this.field_70170_p.func_175656_a((BlockPos)posUp, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (placeSnow && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_70146_Z.nextInt(20) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_70146_Z.nextInt(10) != 0) || placeIce && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_70146_Z.nextInt(14) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_70146_Z.nextInt(6) != 0)) continue;
                    if (placeSnow) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150431_aC.func_176223_P());
                    }
                    if (!placeIce) continue;
                    this.field_70170_p.func_175656_a((BlockPos)posDown, Blocks.field_150432_aD.func_176223_P());
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 40 == 0 && this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP() && this.isSnowingAt(new BlockPos((Entity)this))) {
            this.func_70691_i(1.0f);
        }
    }

    private boolean isSnowingAt(BlockPos position) {
        if (!this.field_70170_p.func_72896_J()) {
            return false;
        }
        if (!this.field_70170_p.func_175678_i(position)) {
            return false;
        }
        if (this.field_70170_p.func_175725_q(position).func_177956_o() > position.func_177956_o()) {
            return false;
        }
        Biome biome = this.field_70170_p.func_180494_b(position);
        return biome.func_76746_c() && biome.func_180626_a(position) < 0.15f;
    }

    protected void func_70619_bc() {
        if (this.func_110167_bD()) {
            return;
        }
        EntityPlayer owner = this.getOwner();
        if (owner != null && owner.func_70089_S()) {
            this.func_175449_a(new BlockPos((Entity)owner), this.func_70638_az() == null ? 8 : 16);
        } else if (this.func_110175_bO()) {
            this.func_110177_bN();
        }
    }

    public boolean isThrowing() {
        return this.isThrowing;
    }

    public int getThrowingTick() {
        return this.throwingTick;
    }

    private void startThrowing() {
        this.isThrowing = true;
        this.throwingTick = 0;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 0) {
            this.startThrowing();
        } else {
            super.func_70103_a(id);
            if (id == 2 || id == 33 || id == 36 || id == 37) {
                EntityUtil.spawnParticleAtEntity((EntityLivingBase)this, EnumParticleTypes.SNOWBALL, 30, new int[0]);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntitySnowball) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70691_i(1.0f);
                }
                EntityUtil.spawnParticleAtEntity((EntityLivingBase)this, EnumParticleTypes.HEART, 1, new int[0]);
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!this.isThrowing && distanceFactor < 1.0f) {
            this.isThrowing = true;
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_111282_a(player, (EntityLivingBase)this, hand)) {
            return true;
        }
        if ((this.func_184753_b() == null || player == this.getOwner()) && itemStack.func_77973_b() != Items.field_151126_ay) {
            if (!this.field_70170_p.field_72995_K) {
                this.setOwnerId(this.func_184753_b() == null ? player.func_110124_au() : null);
            }
            return true;
        }
        return false;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return this.isPumpkinEquipped();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setPumpkinEquipped(false);
        return Collections.singletonList(new ItemStack(Blocks.field_150428_aP));
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && this.getOwner() instanceof EntityPlayerMP) {
            this.getOwner().func_145747_a(this.func_110142_aN().func_151521_b());
        }
        super.func_70645_a(cause);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == this || entityIn == this.getOwner() || super.func_184191_r(entityIn)) {
            return true;
        }
        if (!(entityIn instanceof IMob)) {
            return this.func_70638_az() != entityIn && (!(entityIn instanceof EntityLiving) || ((EntityLiving)entityIn).func_70638_az() != this) && this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Pumpkin", this.isPumpkinEquipped());
        if (this.func_184753_b() != null) {
            compound.func_186854_a("OwnerUUID", this.func_184753_b());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Pumpkin")) {
            this.setPumpkinEquipped(compound.func_74767_n("Pumpkin"));
        }
        if (compound.func_186855_b("OwnerUUID")) {
            this.setOwnerId(compound.func_186857_a("OwnerUUID"));
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187815_fJ, 0.15f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        return EntityUtil.getLootTable((Entity)this);
    }

    class ThrowIceGoal
    extends EntityAIBase {
        private EntityLivingBase attackTarget;

        ThrowIceGoal() {
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantSnowGolemEntity.this.func_70638_az();
            return this.attackTarget != null && MutantSnowGolemEntity.this.isThrowing;
        }

        public void func_75249_e() {
            MutantSnowGolemEntity.this.startThrowing();
        }

        public boolean func_75253_b() {
            return MutantSnowGolemEntity.this.isThrowing && MutantSnowGolemEntity.this.throwingTick < 20;
        }

        public void func_75246_d() {
            MutantSnowGolemEntity.this.func_70661_as().func_75499_g();
            MutantSnowGolemEntity.this.field_70761_aq = MutantSnowGolemEntity.this.field_70177_z;
            if (MutantSnowGolemEntity.this.throwingTick == 7) {
                ThrowableBlockEntity block = new ThrowableBlockEntity(MutantSnowGolemEntity.this.field_70170_p, MutantSnowGolemEntity.this);
                block.field_70163_u += 1.0;
                double x = this.attackTarget.field_70165_t - block.field_70165_t;
                double y = this.attackTarget.field_70163_u - block.field_70163_u;
                double z = this.attackTarget.field_70161_v - block.field_70161_v;
                double xz = Math.sqrt(x * x + z * z);
                block.func_70186_c(x, y + xz * (double)0.4f, z, 0.9f, 1.0f);
                MutantSnowGolemEntity.this.field_70170_p.func_72838_d((Entity)block);
            }
        }
    }

    class SwimJumpGoal
    extends EntityAIBase {
        private int jumpTick = 20;
        private boolean waterReplaced;
        private BlockPos.MutableBlockPos prevPos;

        public SwimJumpGoal() {
            this.func_75248_a(4);
            ((MBGroundPathNavigator)MutantSnowGolemEntity.this.field_70699_by).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return MutantSnowGolemEntity.this.func_70090_H();
        }

        public void func_75249_e() {
            this.prevPos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)MutantSnowGolemEntity.this.field_70165_t), MathHelper.func_76128_c((double)MutantSnowGolemEntity.this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)MutantSnowGolemEntity.this.field_70161_v));
            MutantSnowGolemEntity.this.field_70159_w = (MutantSnowGolemEntity.this.field_70146_Z.nextFloat() - MutantSnowGolemEntity.this.field_70146_Z.nextFloat()) * 0.9f;
            MutantSnowGolemEntity.this.field_70181_x = 1.5;
            MutantSnowGolemEntity.this.field_70179_y = (MutantSnowGolemEntity.this.field_70146_Z.nextFloat() - MutantSnowGolemEntity.this.field_70146_Z.nextFloat()) * 0.9f;
            MutantSnowGolemEntity.this.func_70097_a(DamageSource.field_76369_e, 16.0f);
            MutantSnowGolemEntity.this.setSwimJump(true);
        }

        public boolean func_75253_b() {
            return this.jumpTick > 0;
        }

        public void func_75246_d() {
            --this.jumpTick;
            if (!this.waterReplaced && !MutantSnowGolemEntity.this.func_70090_H() && this.jumpTick < 17 && ForgeEventFactory.getMobGriefingEvent((World)MutantSnowGolemEntity.this.field_70170_p, (Entity)MutantSnowGolemEntity.this)) {
                this.prevPos.func_185336_p(this.getWaterSurfaceHeight(MutantSnowGolemEntity.this.field_70170_p, (BlockPos)this.prevPos));
                if ((double)this.prevPos.func_177956_o() > MutantSnowGolemEntity.this.field_70163_u) {
                    return;
                }
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            if (y != 0 && (Math.abs(x) == 2 || Math.abs(z) == 2)) continue;
                            BlockPos blockPos = this.prevPos.func_177982_a(x, y, z);
                            Block block = MutantSnowGolemEntity.this.field_70170_p.func_180495_p(blockPos).func_177230_c();
                            if (!MutantSnowGolemEntity.this.field_70170_p.func_175623_d(blockPos) && block != Blocks.field_150355_j && block != Blocks.field_150358_i || (y != 0 ? (Math.abs(x) == 1 || Math.abs(z) == 1) && MutantSnowGolemEntity.this.field_70146_Z.nextInt(4) == 0 : (Math.abs(x) == 2 || Math.abs(z) == 2) && MutantSnowGolemEntity.this.field_70146_Z.nextInt(3) == 0)) continue;
                            MutantSnowGolemEntity.this.field_70170_p.func_175656_a(blockPos, Blocks.field_150432_aD.func_176223_P());
                        }
                    }
                }
                BlockPos posUp2 = this.prevPos.func_177981_b(2);
                if (MutantSnowGolemEntity.this.field_70170_p.func_175623_d(posUp2)) {
                    MutantSnowGolemEntity.this.field_70170_p.func_175656_a(posUp2, Blocks.field_150432_aD.func_176223_P());
                }
                this.waterReplaced = true;
            }
        }

        public void func_75251_c() {
            this.jumpTick = 20;
            this.waterReplaced = false;
            MutantSnowGolemEntity.this.setSwimJump(false);
        }

        private int getWaterSurfaceHeight(World world, BlockPos coord) {
            Block block;
            int y = coord.func_177956_o();
            while ((block = world.func_180495_p(new BlockPos(coord.func_177958_n(), y, coord.func_177952_p())).func_177230_c()) == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                ++y;
            }
            return y;
        }
    }
}

