/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.entity.ai.EntityAIAvoidDamage;
import chumbanotz.mutantbeasts.entity.ai.EntityAIHurtByNearestTarget;
import chumbanotz.mutantbeasts.entity.ai.MBEntityAIAttackMelee;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.SeismicWave;
import chumbanotz.mutantbeasts.util.ZombieResurrection;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class MutantZombieEntity
extends EntityMob
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> LIVES = EntityDataManager.func_187226_a(MutantZombieEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> THROW_ATTACK_STATE = EntityDataManager.func_187226_a(MutantZombieEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final int MAX_DEATH_TIME = 140;
    public static final int MAX_VANISH_TIME = 100;
    public static final byte MELEE_ATTACK = 1;
    public static final byte THROW_ATTACK = 2;
    public static final byte ROAR_ATTACK = 3;
    private int attackID;
    private int attackTick;
    public int throwHitTick = -1;
    public int throwFinishTick = -1;
    public int vanishTime;
    private final List<SeismicWave> seismicWavesList = new ArrayList<SeismicWave>();
    private final List<ZombieResurrection> resurrections = new ArrayList<ZombieResurrection>();
    private DamageSource deathCause;
    public int field_70725_aQ;

    public MutantZombieEntity(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 30;
        this.func_70105_a(1.8f, 3.2f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MeleeGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new RoarGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new ThrowAttackGoal());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MBEntityAIAttackMelee((EntityCreature)this, 1.2).setMaxAttackTick(0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidDamage((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByNearestTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true).func_190882_b(100));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(3.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LIVES, (Object)3);
        this.field_70180_af.func_187214_a(THROW_ATTACK_STATE, (Object)0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((EntityLiving)this, worldIn);
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        return this.field_70725_aQ > 0 ? p_110146_2_ : super.func_110146_f(p_110146_1_, p_110146_2_);
    }

    public int getLives() {
        return (Integer)this.field_70180_af.func_187225_a(LIVES);
    }

    private void setLives(int lives) {
        this.field_70180_af.func_187227_b(LIVES, (Object)lives);
    }

    public boolean getThrowAttackHit() {
        return ((Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE) & 1) != 0;
    }

    private void setThrowAttackHit(boolean hit) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE);
        this.field_70180_af.func_187227_b(THROW_ATTACK_STATE, (Object)(hit ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean getThrowAttackFinish() {
        return ((Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE) & 2) != 0;
    }

    private void setThrowAttackFinished(boolean finished) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE);
        this.field_70180_af.func_187227_b(THROW_ATTACK_STATE, (Object)(finished ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public int getAttackID() {
        return this.attackID;
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    private void setAttackID(int attackID) {
        this.attackID = attackID;
        this.attackTick = 0;
        this.field_70170_p.func_72960_a((Entity)this, (byte)(-attackID));
    }

    public float func_70047_e() {
        return 2.8f;
    }

    public int func_70641_bl() {
        return 1;
    }

    public int func_82143_as() {
        return this.func_70638_az() != null ? (int)this.func_70032_d((Entity)this.func_70638_az()) : 3;
    }

    public boolean func_70104_M() {
        return !this.func_70617_f_();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!(itemStack.func_77973_b() != Items.field_151033_d || this.func_70089_S() || this.func_70027_ad() || this.func_70026_G())) {
            this.func_70015_d(8);
            player.func_184609_a(hand);
            itemStack.func_77972_a(1, (EntityLivingBase)player);
            player.func_71029_a(StatList.func_188057_b((Item)itemStack.func_77973_b()));
            this.field_70170_p.func_184133_a(player, this.func_180425_c(), SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.attackID == 0 && (this.func_184187_bx() == entityIn || this.field_70146_Z.nextInt(5) == 0 && this.func_70635_at().func_75522_a(entityIn))) {
                this.attackID = 2;
            }
            if (this.attackID == 0 && (this.field_70122_E || this.field_70170_p.func_72953_d(this.func_174813_aQ()))) {
                this.attackID = 1;
            }
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity;
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.attackID == 3 && source != DamageSource.field_76380_i) {
            if (this.attackTick < 10) {
                return false;
            }
            if (!source.func_76363_c()) {
                amount *= 0.15f;
            }
        }
        return (entity = source.func_76346_g()) != null && this.attackID == 2 && entity == this.func_70638_az() ? false : super.func_70097_a(source, amount);
    }

    public void func_70103_a(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attackTick = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_70619_bc() {
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 49.0 && Math.abs(this.field_70163_u - this.func_70638_az().field_70163_u) <= 4.0) {
            if (this.attackID == 0 && (this.field_70122_E || this.field_70170_p.func_72953_d(this.func_174813_aQ())) && this.field_70146_Z.nextInt(20) == 0) {
                this.attackID = 1;
            }
            if (this.attackID == 0 && this.func_70068_e((Entity)this.func_70638_az()) < 1.0 && this.field_70146_Z.nextInt(125) == 0) {
                this.attackID = 2;
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.fixRotation();
        this.updateAnimation();
        this.updateMeleeGrounds();
        if (!this.field_70170_p.func_72935_r() && this.field_70173_aa % 100 == 0 && this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(2.0f);
        }
        for (int i = this.resurrections.size() - 1; i >= 0; --i) {
            ZombieResurrection zr = this.resurrections.get(i);
            if (zr.update(this)) continue;
            this.resurrections.remove((Object)zr);
        }
        if (this.func_110143_aJ() > 0.0f) {
            this.field_70725_aQ = 0;
            this.vanishTime = 0;
        }
    }

    private void fixRotation() {
        float yaw;
        for (yaw = this.field_70759_as - this.field_70761_aq; yaw < -180.0f; yaw += 360.0f) {
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        float offset = 0.1f;
        if (this.attackID == 1) {
            offset = 0.2f;
        }
        this.field_70761_aq += yaw * offset;
    }

    private void updateAnimation() {
        if (this.attackID != 0) {
            ++this.attackTick;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.attackID == 2) {
                if (this.getThrowAttackHit()) {
                    if (this.throwHitTick == -1) {
                        this.throwHitTick = 0;
                    }
                    ++this.throwHitTick;
                }
                if (this.getThrowAttackFinish()) {
                    if (this.throwFinishTick == -1) {
                        this.throwFinishTick = 0;
                    }
                    ++this.throwFinishTick;
                }
            } else {
                this.throwHitTick = -1;
                this.throwFinishTick = -1;
            }
        }
    }

    private void updateMeleeGrounds() {
        if (!this.seismicWavesList.isEmpty()) {
            SeismicWave wave = this.seismicWavesList.remove(0);
            wave.affectBlocks(this.field_70170_p, (EntityLivingBase)this);
            AxisAlignedBB box = new AxisAlignedBB((double)wave.func_177958_n(), (double)(wave.func_177956_o() + 1), (double)wave.func_177952_p(), (double)(wave.func_177958_n() + 2), (double)(wave.func_177956_o() + 2), (double)(wave.func_177952_p() + 2));
            if (wave.isFirst()) {
                double addScale = this.field_70146_Z.nextDouble() * 0.75;
                box = box.func_72314_b(0.25 + addScale, 0.25 + addScale * 0.5, 0.25 + addScale);
            }
            DamageSource source = DamageSource.func_76358_a((EntityLivingBase)this).func_151518_m();
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, box)) {
                if (!entity.func_70067_L() || this.func_184191_r(entity)) continue;
                if (entity.func_70097_a(source, wave.isFirst() ? (float)(9 + this.field_70146_Z.nextInt(4)) : (float)(6 + this.field_70146_Z.nextInt(3)))) {
                    this.func_174815_a((EntityLivingBase)this, entity);
                    if (entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(5) == 0) {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76438_s, 160, 1));
                    }
                }
                double x = entity.field_70165_t - this.field_70165_t;
                double z = entity.field_70161_v - this.field_70161_v;
                double d = Math.max(Math.sqrt(x * x + z * z), 0.001);
                entity.field_70159_w = x / d * 0.3;
                entity.field_70181_x = 0.04;
                entity.field_70179_y = z / d * 0.3;
            }
        }
    }

    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(1.0);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return super.func_184228_n(entityIn) && entityIn instanceof EntityLivingBase;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.deathCause = cause;
            this.func_130011_c((Entity)this.func_70643_av());
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            if (this.field_70718_bc > 0) {
                this.field_70718_bc += 140;
            }
        }
    }

    protected void func_70609_aI() {
        if (this.field_70725_aQ <= 25 || !this.func_70027_ad() || this.field_70725_aQ >= 100) {
            ++this.field_70725_aQ;
        }
        if (this.func_70027_ad()) {
            ++this.vanishTime;
        } else if (this.vanishTime > 0) {
            --this.vanishTime;
        }
        if (this.getLives() <= 0) {
            ((EntityMob)this).field_70725_aQ = this.field_70725_aQ;
        }
        if (this.field_70725_aQ >= 140) {
            this.field_70725_aQ = 0;
            this.vanishTime = 0;
            this.deathCause = null;
            this.setLives(this.getLives() - 1);
            if (this.func_110144_aD() != null) {
                this.func_110144_aD().func_70604_c((EntityLivingBase)this);
            }
            this.func_70606_j(Math.round(this.func_110138_aP() / 3.75f));
            return;
        }
        if (this.vanishTime >= 100 || this.getLives() <= 0 && this.field_70725_aQ > 25) {
            if (!this.field_70170_p.field_72995_K) {
                EntityUtil.dropExperience((EntityLiving)this, this.field_70718_bc, arg_0 -> ((MutantZombieEntity)this).func_70693_a(arg_0), this.field_70717_bb);
                super.func_70645_a(this.deathCause != null ? this.deathCause : DamageSource.field_76377_j);
            }
            EntityUtil.spawnParticleAtEntity((EntityLivingBase)this, this.func_70027_ad() ? EnumParticleTypes.FLAME : EnumParticleTypes.EXPLOSION_NORMAL, 30, new int[0]);
            this.func_70106_y();
        }
    }

    public void func_174812_G() {
        super.func_174812_G();
        this.setLives(0);
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        if ((this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL && this.field_70146_Z.nextBoolean() || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) && entityLivingIn instanceof EntityVillager) {
            EntityVillager entityvillager = (EntityVillager)entityLivingIn;
            EntityZombieVillager entityzombievillager = new EntityZombieVillager(this.field_70170_p);
            entityzombievillager.func_82149_j((Entity)entityvillager);
            this.field_70170_p.func_72900_e((Entity)entityvillager);
            entityzombievillager.func_190733_a(entityvillager.func_70946_n());
            entityzombievillager.func_82227_f(entityvillager.func_70631_g_());
            entityzombievillager.func_94061_f(entityvillager.func_175446_cd());
            if (entityvillager.func_145818_k_()) {
                entityzombievillager.func_96094_a(entityvillager.func_95999_t());
                entityzombievillager.func_174805_g(entityvillager.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entityzombievillager);
            if (!entityLivingIn.func_174814_R()) {
                this.field_70170_p.func_180498_a(null, 1026, entityLivingIn.func_180425_c(), 0);
            }
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == this || super.func_184191_r(entityIn)) {
            return true;
        }
        if (ZombieResurrection.canBeResurrected(entityIn.getClass()) || entityIn.getClass() == ((Object)((Object)this)).getClass()) {
            return this.func_70638_az() != entityIn && ((EntityMob)entityIn).func_70638_az() != this && this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    protected void func_70629_bd() {
        this.field_70181_x += (double)0.04f;
    }

    protected void func_180466_bG() {
        this.func_70629_bd();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Lives", this.getLives());
        compound.func_74777_a("DeathTime", (short)this.field_70725_aQ);
        compound.func_74777_a("VanishTime", (short)this.vanishTime);
        if (!this.resurrections.isEmpty()) {
            NBTTagList nbtTagList = new NBTTagList();
            for (ZombieResurrection resurrection : this.resurrections) {
                NBTTagCompound compound1 = NBTUtil.func_186859_a((BlockPos)resurrection);
                compound1.func_74768_a("Tick", resurrection.getTick());
                nbtTagList.func_74742_a((NBTBase)compound1);
            }
            compound.func_74782_a("Resurrections", (NBTBase)nbtTagList);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70725_aQ = ((EntityMob)this).field_70725_aQ;
        if (compound.func_74764_b("Lives")) {
            this.setLives(compound.func_74762_e("Lives"));
        }
        this.vanishTime = compound.func_74765_d("VanishTime");
        NBTTagList nbtTagList = compound.func_150295_c("Resurrections", 10);
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound compound1 = nbtTagList.func_150305_b(i);
            this.resurrections.add(i, new ZombieResurrection(this.field_70170_p, NBTUtil.func_186861_c((NBTTagCompound)compound1), compound1.func_74762_e("Tick")));
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_ZOMBIE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_ZOMBIE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_ZOMBIE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (this.field_70725_aQ == 0) {
            this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
        }
    }

    protected ResourceLocation func_184647_J() {
        return EntityUtil.getLootTable((Entity)this);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.attackID);
        buffer.writeInt(this.attackTick);
        buffer.writeInt(this.field_70725_aQ);
        buffer.writeInt(this.vanishTime);
        buffer.writeInt(this.throwHitTick);
        buffer.writeInt(this.throwFinishTick);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.attackID = additionalData.readInt();
        this.attackTick = additionalData.readInt();
        this.field_70725_aQ = additionalData.readInt();
        this.vanishTime = additionalData.readInt();
        this.throwHitTick = additionalData.readInt();
        this.throwFinishTick = additionalData.readInt();
    }

    class ThrowAttackGoal
    extends EntityAIBase {
        private EntityLivingBase attackTarget;
        private int hit = -1;
        private int finish = -1;

        public ThrowAttackGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantZombieEntity.this.func_70638_az();
            return this.attackTarget != null && MutantZombieEntity.this.attackID == 2;
        }

        public void func_75249_e() {
            MutantZombieEntity.this.setAttackID(2);
            this.attackTarget.func_184210_p();
            double x = this.attackTarget.field_70165_t - MutantZombieEntity.this.field_70165_t;
            double z = this.attackTarget.field_70161_v - MutantZombieEntity.this.field_70161_v;
            double d = Math.max(Math.sqrt(x * x + z * z), 0.001);
            this.attackTarget.field_70159_w = x / d * (double)0.8f;
            this.attackTarget.field_70181_x = 1.6f;
            this.attackTarget.field_70179_y = z / d * (double)0.8f;
            EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
        }

        public boolean func_75253_b() {
            return MutantZombieEntity.this.attackID == 2 && this.finish < 10;
        }

        public void func_75246_d() {
            MutantZombieEntity.this.func_70661_as().func_75499_g();
            MutantZombieEntity.this.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (MutantZombieEntity.this.attackTick == 15) {
                MutantZombieEntity.this.field_70134_J = false;
                double x = this.attackTarget.field_70165_t - MutantZombieEntity.this.field_70165_t;
                double y = this.attackTarget.field_70163_u - MutantZombieEntity.this.field_70163_u;
                double z = this.attackTarget.field_70161_v - MutantZombieEntity.this.field_70161_v;
                double d0 = Math.max(Math.sqrt(x * x + y * y + z * z), 0.001);
                MutantZombieEntity.this.field_70159_w = x / d0 * (double)3.4f;
                MutantZombieEntity.this.field_70181_x = y / d0 * (double)1.4f;
                MutantZombieEntity.this.field_70179_y = z / d0 * (double)3.4f;
            } else if (MutantZombieEntity.this.attackTick > 15) {
                double d1 = MutantZombieEntity.this.field_70130_N * 2.0f * MutantZombieEntity.this.field_70130_N * 2.0f;
                double distSq = MutantZombieEntity.this.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
                if (distSq < d1 && this.hit == -1) {
                    this.hit = 0;
                    MutantZombieEntity.this.setThrowAttackHit(true);
                    if (!this.attackTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)MutantZombieEntity.this), (float)MutantZombieEntity.this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) {
                        EntityUtil.disableShield(this.attackTarget, 150);
                    }
                    double x = this.attackTarget.field_70165_t - MutantZombieEntity.this.field_70165_t;
                    double z = this.attackTarget.field_70161_v - MutantZombieEntity.this.field_70161_v;
                    double d0 = Math.max(Math.sqrt(x * x + z * z), 0.001);
                    this.attackTarget.field_70159_w = x / d0 * (double)0.6f;
                    this.attackTarget.field_70181_x = -1.2f;
                    this.attackTarget.field_70179_y = z / d0 * (double)0.6f;
                    EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
                    this.attackTarget.field_70172_ad = 10;
                    MutantZombieEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ZOMBIE_GRUNT, 0.3f, 0.8f + MutantZombieEntity.this.field_70146_Z.nextFloat() * 0.4f);
                }
                if (this.hit >= 0) {
                    ++this.hit;
                }
                if ((MutantZombieEntity.this.field_70122_E || MutantZombieEntity.this.func_70090_H() || MutantZombieEntity.this.func_180799_ab()) && this.finish == -1) {
                    this.finish = 0;
                    MutantZombieEntity.this.setThrowAttackFinished(true);
                }
                if (this.finish >= 0) {
                    ++this.finish;
                }
            }
        }

        public void func_75251_c() {
            MutantZombieEntity.this.setAttackID(0);
            this.attackTarget = null;
            this.hit = -1;
            this.finish = -1;
            MutantZombieEntity.this.setThrowAttackHit(false);
            MutantZombieEntity.this.setThrowAttackFinished(false);
        }
    }

    class RoarGoal
    extends EntityAIBase {
        public RoarGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return MutantZombieEntity.this.func_70638_az() != null && MutantZombieEntity.this.field_70122_E && MutantZombieEntity.this.func_70068_e((Entity)MutantZombieEntity.this.func_70638_az()) > 16.0 && MutantZombieEntity.this.field_70146_Z.nextFloat() * 100.0f < 0.35f;
        }

        public void func_75249_e() {
            MutantZombieEntity.this.setAttackID(3);
            MutantZombieEntity.this.field_70708_bq = 0;
            MutantZombieEntity.this.field_70757_a = -MutantZombieEntity.this.func_70627_aG();
        }

        public boolean func_75253_b() {
            return MutantZombieEntity.this.attackTick < 120;
        }

        public void func_75246_d() {
            MutantZombieEntity.this.func_70661_as().func_75499_g();
            if (MutantZombieEntity.this.attackTick < 75 && MutantZombieEntity.this.func_70638_az() != null) {
                MutantZombieEntity.this.func_70671_ap().func_75651_a((Entity)MutantZombieEntity.this.func_70638_az(), 30.0f, 30.0f);
            }
            if (MutantZombieEntity.this.attackTick == 10) {
                MutantZombieEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ZOMBIE_ROAR, 3.0f, 0.7f + MutantZombieEntity.this.field_70146_Z.nextFloat() * 0.2f);
                for (Entity entity : MutantZombieEntity.this.field_70170_p.func_72839_b((Entity)MutantZombieEntity.this, MutantZombieEntity.this.func_174813_aQ().func_72314_b(12.0, 8.0, 12.0))) {
                    if (!entity.func_70067_L() || MutantZombieEntity.this.func_184191_r(entity) || !(MutantZombieEntity.this.func_70068_e(entity) <= 196.0)) continue;
                    double x = entity.field_70165_t - MutantZombieEntity.this.field_70165_t;
                    double z = entity.field_70161_v - MutantZombieEntity.this.field_70161_v;
                    double d = Math.sqrt(x * x + z * z);
                    entity.field_70159_w = x / d * (double)0.7f;
                    entity.field_70181_x = 0.3f;
                    entity.field_70179_y = z / d * (double)0.7f;
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)MutantZombieEntity.this).func_76348_h().func_151518_m(), (float)(2 + MutantZombieEntity.this.field_70146_Z.nextInt(2)));
                    EntityUtil.sendPlayerVelocityPacket(entity);
                }
            }
            if (MutantZombieEntity.this.attackTick >= 20 && MutantZombieEntity.this.attackTick < 80 && MutantZombieEntity.this.attackTick % 10 == 0) {
                int x = MathHelper.func_76128_c((double)MutantZombieEntity.this.field_70165_t);
                int y = MathHelper.func_76128_c((double)MutantZombieEntity.this.func_174813_aQ().field_72338_b);
                int z = MathHelper.func_76128_c((double)MutantZombieEntity.this.field_70161_v);
                y = ZombieResurrection.getSuitableGround(MutantZombieEntity.this.field_70170_p, x += (1 + MutantZombieEntity.this.field_70146_Z.nextInt(8)) * (MutantZombieEntity.this.field_70146_Z.nextBoolean() ? 1 : -1), y - 1, z += (1 + MutantZombieEntity.this.field_70146_Z.nextInt(8)) * (MutantZombieEntity.this.field_70146_Z.nextBoolean() ? 1 : -1));
                if (y != -1) {
                    MutantZombieEntity.this.resurrections.add(new ZombieResurrection(MutantZombieEntity.this.field_70170_p, x, y, z));
                }
            }
        }

        public void func_75251_c() {
            MutantZombieEntity.this.setAttackID(0);
        }
    }

    class MeleeGoal
    extends EntityAIBase {
        private EntityLivingBase attackTarget;
        private double dirX = -1.0;
        private double dirZ = -1.0;

        public MeleeGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantZombieEntity.this.func_70638_az();
            return this.attackTarget != null && MutantZombieEntity.this.attackID == 1;
        }

        public void func_75249_e() {
            MutantZombieEntity.this.setAttackID(1);
            MutantZombieEntity.this.field_70757_a = -MutantZombieEntity.this.func_70627_aG();
            MutantZombieEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ZOMBIE_ATTACK, 0.3f, 0.8f + MutantZombieEntity.this.field_70146_Z.nextFloat() * 0.4f);
        }

        public boolean func_75253_b() {
            return MutantZombieEntity.this.attackTick < 25;
        }

        public void func_75246_d() {
            MutantZombieEntity.this.func_70661_as().func_75499_g();
            if (MutantZombieEntity.this.attackTick < 8) {
                MutantZombieEntity.this.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (MutantZombieEntity.this.attackTick == 8) {
                double x = this.attackTarget.field_70165_t - MutantZombieEntity.this.field_70165_t;
                double z = this.attackTarget.field_70161_v - MutantZombieEntity.this.field_70161_v;
                double d = Math.max(Math.sqrt(x * x + z * z), 0.001);
                this.dirX = x / d;
                this.dirZ = z / d;
            }
            if (MutantZombieEntity.this.attackTick == 12) {
                int x = MathHelper.func_76128_c((double)(MutantZombieEntity.this.field_70165_t + this.dirX * 2.0));
                int y = MathHelper.func_76128_c((double)MutantZombieEntity.this.func_174813_aQ().field_72338_b);
                int z = MathHelper.func_76128_c((double)(MutantZombieEntity.this.field_70161_v + this.dirZ * 2.0));
                int x1 = MathHelper.func_76128_c((double)(MutantZombieEntity.this.field_70165_t + this.dirX * 8.0));
                int z1 = MathHelper.func_76128_c((double)(MutantZombieEntity.this.field_70161_v + this.dirZ * 8.0));
                SeismicWave.createWaves(MutantZombieEntity.this.field_70170_p, MutantZombieEntity.this.seismicWavesList, x, z, x1, z1, y);
                MutantZombieEntity.this.func_184185_a(SoundEvents.field_187539_bB, 0.5f, 0.8f + MutantZombieEntity.this.field_70146_Z.nextFloat() * 0.4f);
            }
        }

        public void func_75251_c() {
            MutantZombieEntity.this.setAttackID(0);
            this.attackTarget = null;
            this.dirX = -1.0;
            this.dirZ = -1.0;
        }
    }
}

