/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.ai.EntityAIAvoidDamage;
import chumbanotz.mutantbeasts.entity.ai.EntityAIHurtByNearestTarget;
import chumbanotz.mutantbeasts.entity.ai.MBEntityAIAttackMelee;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class SpiderPigEntity
extends EntityTameable
implements IJumpingMount {
    private static final DataParameter<Boolean> CLIMBING = EntityDataManager.func_187226_a(SpiderPigEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final Set<Item> TEMPTATION_ITEMS = ImmutableSet.of((Object)Items.field_151172_bF, (Object)Items.field_151174_bG, (Object)Items.field_185164_cV, (Object)Items.field_151147_al, (Object)Items.field_151070_bp);
    private int leapCooldown;
    private int leapTick;
    private boolean isLeaping;
    private float chargePower;
    private int chargingTick;
    private int chargeExhaustion;
    private boolean chargeExhausted;
    private final List<WebPos> webList = new ArrayList<WebPos>(12);

    public SpiderPigEntity(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.4f, 0.9f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MBEntityAIAttackMelee((EntityCreature)this, 1.1).setMaxAttackTick(15));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new LeapAttackGoal());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidDamage((EntityCreature)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 5.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.1, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByNearestTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityLiving.class, true, SpiderPigEntity::isPigOrSpider));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)false);
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.field_70180_af.func_187225_a(CLIMBING);
    }

    private void setBesideClimbableBlock(boolean climbing) {
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
    }

    public boolean isSaddled() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    private void setSaddled(boolean saddled) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        this.field_70180_af.func_187227_b(field_184755_bv, (Object)(saddled ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.75f;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() != MobEffects.field_76436_u && super.func_70687_e(potioneffectIn);
    }

    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        if (!this.func_70631_g_()) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.setBesideClimbableBlock(this.field_70123_F);
        if (this.chargeExhaustion >= 120) {
            this.chargeExhausted = true;
        }
        if (this.chargeExhaustion <= 0) {
            this.chargeExhausted = false;
        }
        this.chargeExhaustion = Math.max(0, this.chargeExhaustion - 1);
        if (!this.field_70170_p.field_72995_K) {
            this.leapCooldown = Math.max(0, this.leapCooldown - 1);
            if (this.leapTick > 10 && this.field_70122_E) {
                this.isLeaping = false;
            }
            this.updateWebList(false);
            this.updateChargeState();
            if (this.func_70909_n() && this.field_70173_aa % 600 == 0) {
                this.func_70691_i(1.0f);
            }
        }
    }

    private void updateWebList(boolean onlyCheckSize) {
        WebPos first;
        if (!onlyCheckSize) {
            for (int i = 0; i < this.webList.size(); ++i) {
                WebPos coord = this.webList.get(i);
                if (this.field_70170_p.func_180495_p((BlockPos)coord).func_177230_c() != Blocks.field_150321_G) {
                    this.webList.remove(i);
                    --i;
                    continue;
                }
                --coord.timeLeft;
            }
            if (!this.webList.isEmpty() && (first = this.webList.get(0)).timeLeft < 0) {
                this.webList.remove(0);
                if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                    this.removeWeb(first);
                }
            }
        }
        while (this.webList.size() > 12) {
            first = this.webList.remove(0);
            this.removeWeb(first);
        }
    }

    private void removeWeb(BlockPos pos) {
        if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150321_G) {
            this.field_70170_p.func_175655_b(pos, false);
        }
    }

    private void updateChargeState() {
        if (this.chargingTick > 0) {
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())) {
                if (entity == this || !entity.func_70067_L() || this.func_184191_r(entity)) continue;
                this.func_70652_k(entity);
            }
        }
        this.chargingTick = Math.max(0, this.chargingTick - 1);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player)) {
            if (itemstack.func_77973_b() instanceof ItemFood && this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(((ItemFood)itemstack.func_77973_b()).func_150905_g(itemstack));
                this.func_175505_a(player, itemstack);
                return true;
            }
            if (itemstack.func_77973_b() == Items.field_151141_av) {
                if (!(player.func_70093_af() || this.isSaddled() || this.func_70631_g_())) {
                    this.setSaddled(true);
                    this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                    this.func_175505_a(player, itemstack);
                    return true;
                }
            } else if (this.isSaddled() && !this.func_184207_aI()) {
                if (!player.func_70093_af()) {
                    if (!this.field_70170_p.field_72995_K) {
                        player.func_184220_m((Entity)this);
                        this.field_70699_by.func_75499_g();
                    }
                    return true;
                }
                this.setSaddled(false);
                this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_145779_a(Items.field_151141_av, 1);
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        return EntityUtil.shouldAttackEntity(target, owner, false);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        this.isLeaping = false;
        if (this.field_70146_Z.nextInt(2) == 0 && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            double dx = entityIn.field_70165_t - entityIn.field_70169_q;
            double dz = entityIn.field_70161_v - entityIn.field_70166_s;
            BlockPos pos = new BlockPos((int)(entityIn.field_70165_t + dx * 0.5), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), (int)(entityIn.field_70161_v + dz * 0.5));
            Material material = this.field_70170_p.func_180495_p(pos).func_185904_a();
            if (!material.func_76220_a() && !material.func_76224_d() && material != Material.field_151569_G) {
                this.field_70170_p.func_175656_a(pos, Blocks.field_150321_G.func_176223_P());
                this.webList.add(new WebPos(pos, this.chargingTick > 0 ? 600 : 1200));
                this.updateWebList(true);
                this.field_70181_x = Math.max(0.25, this.field_70181_x);
                this.field_70143_R = 0.0f;
            }
        }
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (!(entityIn instanceof EntitySpider) && !(entityIn instanceof SpiderPigEntity) && this.field_70170_p.func_72875_a(entityIn.func_174813_aQ(), Material.field_151569_G)) {
            damage += 4.0f;
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage)) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_184776_b() {
        return this.isSaddled() && !this.chargeExhausted && this.field_70122_E && !this.field_70123_F;
    }

    public void func_110206_u(int jumpPowerIn) {
        this.chargeExhaustion += 50 * jumpPowerIn / 100;
        this.chargePower = 1.0f * (float)jumpPowerIn / 100.0f;
    }

    public void func_184775_b(int jumpPowerIn) {
        this.chargingTick = 8 * jumpPowerIn / 100;
    }

    public void func_184777_r_() {
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.func_184207_aI() && this.isSaddled();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase livingentity = (EntityLivingBase)this.func_184179_bs();
            this.field_70138_W = 1.0f;
            this.field_70177_z = this.field_70759_as = livingentity.field_70177_z;
            this.field_70126_B = this.field_70759_as;
            this.field_70127_C = this.field_70125_A = livingentity.field_70125_A * 0.4f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            while (this.field_70761_aq > this.field_70759_as + 180.0f) {
                this.field_70761_aq -= 360.0f;
            }
            while (this.field_70761_aq < this.field_70759_as - 180.0f) {
                this.field_70761_aq += 360.0f;
            }
            if (!this.chargeExhausted && this.chargePower > 0.0f && (this.field_70122_E || this.field_70123_F)) {
                float pitch = this.field_70125_A;
                this.field_70125_A = 0.0f;
                this.field_70125_A = pitch;
                Vec3d lookVec = this.func_70040_Z();
                double power = (double)1.6f * (double)this.chargePower;
                this.field_70159_w = lookVec.field_72450_a * power;
                this.field_70181_x = 0.3f;
                this.field_70179_y = lookVec.field_72449_c * power;
                this.chargePower = 0.0f;
            } else {
                this.chargePower = 0.0f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                strafe = livingentity.field_70702_br * 0.8f;
                forward = livingentity.field_191988_bg * 0.6f;
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(strafe, vertical, forward);
            } else if (livingentity instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            } else {
                this.field_184618_aE = this.field_70721_aZ;
                double d1 = this.field_70165_t - this.field_70169_q;
                double d0 = this.field_70161_v - this.field_70166_s;
                float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            }
        } else {
            this.field_70138_W = 0.6f;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        if (!this.field_70170_p.field_72995_K) {
            if (entityLivingIn instanceof CreeperMinionEntity && !this.func_70909_n()) {
                CreeperMinionEntity minion = (CreeperMinionEntity)entityLivingIn;
                EntityLivingBase owner = minion.func_70902_q();
                if (owner instanceof EntityPlayer && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)((EntityPlayer)owner))) {
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    this.func_193101_c((EntityPlayer)owner);
                    minion.func_70106_y();
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            if (SpiderPigEntity.isPigOrSpider(entityLivingIn)) {
                EntityUtil.convertMobWithNBT(entityLivingIn, (EntityLiving)new SpiderPigEntity(this.field_70170_p), false);
            }
        }
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n();
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        if (this.field_70146_Z.nextInt(20) == 0) {
            return new EntityPig(this.field_70170_p);
        }
        SpiderPigEntity spiderPig = new SpiderPigEntity(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            spiderPig.func_184754_b(uuid);
            spiderPig.func_70903_f(true);
        }
        return spiderPig;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        if (this.isSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
            this.setSaddled(false);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.field_70170_p.field_72995_K && !this.webList.isEmpty() && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            for (WebPos webPos : this.webList) {
                this.removeWeb(webPos);
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Saddled", this.isSaddled());
        if (!this.webList.isEmpty()) {
            NBTTagList nbtTagList = new NBTTagList();
            for (WebPos coord : this.webList) {
                NBTTagCompound compound1 = NBTUtil.func_186859_a((BlockPos)coord);
                compound1.func_74768_a("TimeLeft", coord.timeLeft);
                nbtTagList.func_74742_a((NBTBase)compound1);
            }
            compound.func_74782_a("Webs", (NBTBase)nbtTagList);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("Saddled"));
        NBTTagList listnbt = compound.func_150295_c("Webs", 10);
        for (int i = 0; i < listnbt.func_74745_c(); ++i) {
            NBTTagCompound compound1 = listnbt.func_150305_b(i);
            this.webList.add(i, new WebPos(NBTUtil.func_186861_c((NBTTagCompound)compound1), compound1.func_74762_e("TimeLeft")));
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_SPIDER_PIG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_SPIDER_PIG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_SPIDER_PIG_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public static boolean isPigOrSpider(EntityLivingBase livingEntity) {
        return livingEntity.getClass() == EntityPig.class || livingEntity.getClass() == EntitySpider.class;
    }

    protected ResourceLocation func_184647_J() {
        return EntityUtil.getLootTable((Entity)this);
    }

    static class WebPos
    extends BlockPos {
        private int timeLeft;

        public WebPos(BlockPos pos, int timeLeft) {
            super((Vec3i)pos);
            this.timeLeft = timeLeft;
        }
    }

    class LeapAttackGoal
    extends EntityAIBase {
        LeapAttackGoal() {
        }

        public boolean func_75250_a() {
            EntityLivingBase target = SpiderPigEntity.this.func_70638_az();
            return target != null && SpiderPigEntity.this.leapCooldown <= 0 && (SpiderPigEntity.this.field_70122_E || SpiderPigEntity.this.field_70123_F || SpiderPigEntity.this.func_70090_H() || SpiderPigEntity.this.func_180799_ab()) && (SpiderPigEntity.this.func_70068_e((Entity)target) < 64.0 && SpiderPigEntity.this.field_70146_Z.nextInt(8) == 0 || SpiderPigEntity.this.func_70068_e((Entity)target) < 6.25);
        }

        public void func_75249_e() {
            SpiderPigEntity.this.isLeaping = true;
            SpiderPigEntity.this.leapCooldown = 15;
            EntityLivingBase target = SpiderPigEntity.this.func_70638_az();
            double x = target.field_70165_t - SpiderPigEntity.this.field_70165_t;
            double y = target.field_70163_u - SpiderPigEntity.this.field_70163_u;
            double z = target.field_70161_v - SpiderPigEntity.this.field_70161_v;
            double d = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            double scale = 2.0f + 0.2f * SpiderPigEntity.this.field_70146_Z.nextFloat() * SpiderPigEntity.this.field_70146_Z.nextFloat();
            SpiderPigEntity.this.field_70159_w = x / d * scale;
            SpiderPigEntity.this.field_70181_x = y / d * scale * 0.5 + 0.3;
            SpiderPigEntity.this.field_70179_y = z / d * scale;
        }

        public boolean func_75253_b() {
            return SpiderPigEntity.this.isLeaping && SpiderPigEntity.this.leapTick < 40;
        }

        public void func_75246_d() {
            ++SpiderPigEntity.this.leapTick;
        }

        public void func_75251_c() {
            SpiderPigEntity.this.leapTick = 0;
        }
    }
}

