/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.projectile;

import chumbanotz.mutantbeasts.entity.mutant.MutantSkeletonEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class MutantArrowEntity
extends Entity {
    private static final DataParameter<Float> TARGET_X = EntityDataManager.func_187226_a(MutantArrowEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> TARGET_Y = EntityDataManager.func_187226_a(MutantArrowEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> TARGET_Z = EntityDataManager.func_187226_a(MutantArrowEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SPEED = EntityDataManager.func_187226_a(MutantArrowEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> CLONES = EntityDataManager.func_187226_a(MutantArrowEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private int damage;
    private final List<Entity> pointedEntities;
    private PotionEffect potionEffect;
    private EntityLivingBase shooter;

    public MutantArrowEntity(World world) {
        super(world);
        this.damage = 10 + this.field_70146_Z.nextInt(3);
        this.pointedEntities = new ArrayList<Entity>();
        this.field_70145_X = true;
    }

    public MutantArrowEntity(World world, EntityLivingBase shooter, EntityLivingBase target) {
        this(world);
        this.shooter = shooter;
        if (!world.field_72995_K) {
            this.setTargetX(target.field_70165_t);
            this.setTargetY(target.field_70163_u);
            this.setTargetZ(target.field_70161_v);
        }
        double yPos = shooter.field_70163_u + (double)shooter.func_70047_e();
        if (shooter instanceof MutantSkeletonEntity) {
            yPos = shooter.field_70163_u + 1.28;
        }
        this.func_70107_b(shooter.field_70165_t, yPos, shooter.field_70161_v);
        double x = this.getTargetX() - this.field_70165_t;
        double y = this.getTargetY() - this.field_70163_u;
        double z = this.getTargetZ() - this.field_70161_v;
        double d = Math.sqrt(x * x + z * z);
        this.field_70177_z = 180.0f + (float)Math.toDegrees(Math.atan2(x, z));
        this.field_70125_A = (float)Math.toDegrees(Math.atan2(y, d));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TARGET_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TARGET_Y, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TARGET_Z, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SPEED, (Object)Float.valueOf(2.0f));
        this.field_70180_af.func_187214_a(CLONES, (Object)10);
    }

    public double getTargetX() {
        return ((Float)this.field_70180_af.func_187225_a(TARGET_X)).floatValue();
    }

    public void setTargetX(double x) {
        this.field_70180_af.func_187227_b(TARGET_X, (Object)Float.valueOf((float)x));
    }

    public double getTargetY() {
        return ((Float)this.field_70180_af.func_187225_a(TARGET_Y)).floatValue();
    }

    public void setTargetY(double y) {
        this.field_70180_af.func_187227_b(TARGET_Y, (Object)Float.valueOf((float)y));
    }

    public double getTargetZ() {
        return ((Float)this.field_70180_af.func_187225_a(TARGET_Z)).floatValue();
    }

    public void setTargetZ(double z) {
        this.field_70180_af.func_187227_b(TARGET_Z, (Object)Float.valueOf((float)z));
    }

    public float getSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(SPEED)).floatValue();
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_187227_b(SPEED, (Object)Float.valueOf(speed));
    }

    public int getClones() {
        return (Integer)this.field_70180_af.func_187225_a(CLONES);
    }

    public void setClones(int clones) {
        this.field_70180_af.func_187227_b(CLONES, (Object)clones);
    }

    public void randomize(float scale) {
        this.setTargetX(this.getTargetX() + (double)((this.field_70146_Z.nextFloat() - 0.5f) * scale * 2.0f));
        this.setTargetY(this.getTargetY() + (double)((this.field_70146_Z.nextFloat() - 0.5f) * scale * 2.0f));
        this.setTargetZ(this.getTargetZ() + (double)((this.field_70146_Z.nextFloat() - 0.5f) * scale * 2.0f));
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public void setPotionEffect(PotionEffect effect) {
        this.potionEffect = effect;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        double x = this.getTargetX() - this.field_70165_t;
        double y = this.getTargetY() - this.field_70163_u;
        double z = this.getTargetZ() - this.field_70161_v;
        double d = Math.sqrt(x * x + z * z);
        this.field_70177_z = 180.0f + (float)Math.toDegrees(Math.atan2(x, z));
        if (this.field_70177_z > 360.0f) {
            this.field_70177_z -= 360.0f;
        }
        this.field_70125_A = (float)Math.toDegrees(Math.atan2(y, d));
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa == 2) {
                this.hitEntities(0);
            }
            if (this.field_70173_aa == 3) {
                this.hitEntities(32);
            }
            if (this.field_70173_aa == 4) {
                this.handleEntities();
            }
        }
        if (this.field_70173_aa > 10) {
            this.func_70106_y();
        }
    }

    private void hitEntities(int offset) {
        double targetX = this.getTargetX();
        double targetY = this.getTargetY();
        double targetZ = this.getTargetZ();
        double d3 = this.field_70165_t - targetX;
        double d4 = this.field_70163_u - targetY;
        double d5 = this.field_70161_v - targetZ;
        double dist = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
        double dx = (targetX - this.field_70165_t) / dist;
        double dy = (targetY - this.field_70163_u) / dist;
        double dz = (targetZ - this.field_70161_v) / dist;
        for (int i = offset; i < offset + 64; ++i) {
            double x = this.field_70165_t + dx * (double)i * 0.5;
            double y = this.field_70163_u + dy * (double)i * 0.5;
            double z = this.field_70161_v + dz * (double)i * 0.5;
            AxisAlignedBB box = new AxisAlignedBB(x, y, z, x, y, z).func_186662_g(0.3);
            this.pointedEntities.addAll(this.field_70170_p.func_72839_b((Entity)this.shooter, box));
        }
    }

    private void handleEntities() {
        this.pointedEntities.remove((Object)this);
        DamageSource damageSource = new EntityDamageSourceIndirect("arrow", this, (Entity)this.shooter){

            public Vec3d func_188404_v() {
                return null;
            }
        }.func_76349_b();
        for (Entity entity : this.pointedEntities) {
            if ((!(entity instanceof MultiPartEntityPart) || !entity.func_70097_a(DamageSource.field_76377_j.func_94540_d(), (float)this.damage)) && (!entity.func_70067_L() || !entity.func_70097_a(damageSource, (float)this.damage))) continue;
            this.func_174815_a(this.shooter, entity);
            this.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187731_t, this.func_184176_by(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.potionEffect == null || !(entity instanceof EntityLivingBase)) continue;
            ((EntityLivingBase)entity).func_70690_d(this.potionEffect);
        }
        this.pointedEntities.clear();
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }
}

