/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.pathfinding;

import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class MBWalkNodeProcessor
extends WalkNodeProcessor {
    public PathNodeType func_193577_a(IBlockAccess blockAccess, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoorsIn, boolean canEnterDoorsIn, EnumSet<PathNodeType> pathNodeTypes, PathNodeType pathNodeType, BlockPos blockPos) {
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int l = i + x;
                    int i1 = j + y;
                    int j1 = k + z;
                    PathNodeType pathnodetype = this.func_186330_a(blockAccess, l, i1, j1);
                    if (pathnodetype == PathNodeType.DOOR_WOOD_CLOSED && canOpenDoorsIn && canEnterDoorsIn) {
                        pathnodetype = PathNodeType.WALKABLE;
                    }
                    if (pathnodetype == PathNodeType.DOOR_OPEN && !canEnterDoorsIn) {
                        pathnodetype = PathNodeType.BLOCKED;
                    }
                    if (i == 0 && j == 0 && k == 0) {
                        pathNodeType = pathnodetype;
                    }
                    pathNodeTypes.add(pathnodetype);
                }
            }
        }
        return pathNodeType;
    }

    public PathNodeType func_186330_a(IBlockAccess blockaccessIn, int x, int y, int z) {
        PathNodeType pathNodeAbove = this.func_189553_b(blockaccessIn, x, y, z);
        if (pathNodeAbove == PathNodeType.OPEN && y >= 1) {
            PathNodeType pathNodeBelow = this.func_189553_b(blockaccessIn, x, y - 1, z);
            pathNodeAbove = pathNodeBelow != PathNodeType.WALKABLE && pathNodeBelow != PathNodeType.OPEN && pathNodeBelow != PathNodeType.WATER && pathNodeBelow != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            switch (pathNodeBelow) {
                case DAMAGE_FIRE: 
                case DAMAGE_CACTUS: 
                case DAMAGE_OTHER: 
                case DANGER_OTHER: {
                    pathNodeAbove = pathNodeBelow;
                    break;
                }
            }
        }
        pathNodeAbove = this.func_193578_a(blockaccessIn, x, y, z, pathNodeAbove);
        return pathNodeAbove;
    }

    public PathNodeType func_193578_a(IBlockAccess blockaccessIn, int x, int y, int z, PathNodeType pathNode) {
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (pathNode == PathNodeType.WALKABLE) {
            for (int i = -1; i <= 1; ++i) {
                block6: for (int j = -1; j <= 1; ++j) {
                    if (i == 0 && j == 0) continue;
                    BlockPos.PooledMutableBlockPos pos = blockpos$pooledmutableblockpos.func_181079_c(i + x, y, j + z);
                    PathNodeType rawType = this.func_189553_b(blockaccessIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    switch (rawType) {
                        case DAMAGE_CACTUS: {
                            pathNode = PathNodeType.DANGER_CACTUS;
                            continue block6;
                        }
                        case DAMAGE_FIRE: {
                            pathNode = PathNodeType.DANGER_FIRE;
                            continue block6;
                        }
                        case DANGER_OTHER: 
                        case LAVA: {
                            pathNode = rawType;
                            continue block6;
                        }
                    }
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return pathNode;
    }

    protected PathNodeType func_189553_b(IBlockAccess blockaccessIn, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        IBlockState iblockstate = blockaccessIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        Material material = iblockstate.func_185904_a();
        PathNodeType forgeType = block.getAiPathNodeType(iblockstate, blockaccessIn, blockpos);
        if (forgeType != null) {
            return forgeType;
        }
        if (blockaccessIn.func_175623_d(blockpos)) {
            return PathNodeType.OPEN;
        }
        if (!(block instanceof BlockTrapDoor) && !(block instanceof BlockLilyPad)) {
            if (block instanceof BlockFire || block instanceof BlockMagma) {
                return PathNodeType.DAMAGE_FIRE;
            }
            if (block instanceof BlockCactus) {
                return PathNodeType.DAMAGE_CACTUS;
            }
            if (block instanceof BlockEndPortal || block instanceof BlockPortal) {
                return PathNodeType.DAMAGE_OTHER;
            }
            if (block instanceof BlockWeb || block instanceof BlockSoulSand || block instanceof BlockBasePressurePlate || block instanceof BlockTripWire) {
                return PathNodeType.DANGER_OTHER;
            }
            if (block instanceof BlockDoor && material == Material.field_151575_d && !((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            if (block instanceof BlockDoor && material == Material.field_151573_f && !((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_IRON_CLOSED;
            }
            if (block instanceof BlockDoor && ((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
            if (block instanceof BlockRailBase) {
                return PathNodeType.RAIL;
            }
            if (!(block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate && !((Boolean)iblockstate.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue())) {
                if (material == Material.field_151586_h) {
                    return PathNodeType.WATER;
                }
                if (material == Material.field_151587_i) {
                    return PathNodeType.LAVA;
                }
                return block.func_176205_b(blockaccessIn, blockpos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
            }
            return PathNodeType.FENCE;
        }
        return PathNodeType.TRAPDOOR;
    }
}

