/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.entity.SkullSpiritEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.entity.projectile.ChemicalXEntity;
import chumbanotz.mutantbeasts.util.EntityUtil;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;

public class MutatedExplosion
extends Explosion {
    private final Entity exploder;
    private final World world;
    private final float size;

    private MutatedExplosion(World world, Entity exploder, double x, double y, double z, float size, boolean causesFire, boolean damagesTerrain) {
        super(world, exploder, x, y, z, size, causesFire, damagesTerrain);
        this.exploder = exploder;
        this.world = world;
        this.size = size;
    }

    public void func_77278_a() {
        if (this.size <= 0.0f) {
            return;
        }
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double x = this.getPosition().field_72450_a;
                    double y = this.getPosition().field_72448_b;
                    double z = this.getPosition().field_72449_c;
                    float attenuation = 0.3f;
                    for (float intensity = this.size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); intensity > 0.0f; intensity -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(x, y, z);
                        IBlockState iblockstate = this.world.func_180495_p(blockpos);
                        if (!this.world.func_175623_d(blockpos) && !iblockstate.func_185904_a().func_76224_d()) {
                            float resistance = this.exploder != null ? this.exploder.func_180428_a((Explosion)this, this.world, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.world, blockpos, this.exploder, (Explosion)this);
                            intensity -= (resistance + attenuation) * attenuation;
                        }
                        if (intensity > 0.0f && !iblockstate.func_185904_a().func_76224_d() && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, this.world, blockpos, iblockstate, intensity))) {
                            set.add(blockpos);
                        }
                        x += d0 * (double)0.3f;
                        y += d1 * (double)0.3f;
                        z += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.func_180343_e().addAll(set);
        float diameter = this.size * 2.0f;
        int minX = MathHelper.func_76128_c((double)(this.getPosition().field_72450_a - (double)diameter - 1.0));
        int maxX = MathHelper.func_76128_c((double)(this.getPosition().field_72450_a + (double)diameter + 1.0));
        int minY = MathHelper.func_76128_c((double)(this.getPosition().field_72448_b - (double)diameter - 1.0));
        int maxY = MathHelper.func_76128_c((double)(this.getPosition().field_72448_b + (double)diameter + 1.0));
        int minZ = MathHelper.func_76128_c((double)(this.getPosition().field_72449_c - (double)diameter - 1.0));
        int maxZ = MathHelper.func_76128_c((double)(this.getPosition().field_72449_c + (double)diameter + 1.0));
        List list = this.world.func_175674_a(this.exploder, new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ), entity -> {
            if (entity.func_180427_aV()) {
                return false;
            }
            if (this.exploder instanceof SkullSpiritEntity) {
                if (entity == ((SkullSpiritEntity)this.exploder).getTarget()) {
                    return !((SkullSpiritEntity)this.exploder).isAttached();
                }
                return ChemicalXEntity.IS_APPLICABLE.test(entity);
            }
            return true;
        });
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)diameter);
        DamageSource damageSource = DamageSource.func_94539_a((Explosion)this);
        for (Entity entity2 : list) {
            EntityPlayer entityplayer;
            double z;
            double y;
            double x;
            double sqrt;
            double distance = entity2.func_70011_f(this.getPosition().field_72450_a, this.getPosition().field_72448_b, this.getPosition().field_72449_c) / (double)diameter;
            if (!(distance <= 1.0) || (sqrt = (double)MathHelper.func_76133_a((double)((x = entity2.field_70165_t - this.getPosition().field_72450_a) * x + (y = entity2.field_70163_u + (double)entity2.func_70047_e() - this.getPosition().field_72448_b) * y + (z = entity2.field_70161_v - this.getPosition().field_72449_c) * z))) == 0.0) continue;
            x /= sqrt;
            y /= sqrt;
            z /= sqrt;
            double intensity = (1.0 - distance) * (double)MutatedExplosion.getBlockDensity(this.getPosition(), entity2);
            float damage = (int)((intensity * intensity + intensity) / 2.0 * 6.0 * (double)diameter + 1.0);
            if (!entity2.func_70097_a(damageSource, damage) && this.exploder instanceof MutantCreeperEntity && entity2 instanceof EntityPlayer && ((EntityPlayer)entity2).func_184585_cz()) {
                MutantCreeperEntity mutantCreeper = (MutantCreeperEntity)this.exploder;
                EntityPlayer player = (EntityPlayer)entity2;
                player.field_70133_I = true;
                if (mutantCreeper.isJumpAttacking()) {
                    EntityUtil.disableShield((EntityLivingBase)player, mutantCreeper.func_70830_n() ? 200 : 100);
                    player.func_70097_a(damageSource, damage * 0.5f);
                } else {
                    player.func_184607_cu().func_77972_a((int)damage * 2, (EntityLivingBase)player);
                    player.func_70097_a(damageSource, damage * 0.5f);
                }
            }
            double scale = intensity;
            if (entity2 instanceof EntityLivingBase) {
                scale = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity2), (double)intensity);
            }
            if (!(entity2 instanceof MutantCreeperEntity)) {
                entity2.field_70159_w += x * scale;
                entity2.field_70181_x += y * scale;
                entity2.field_70179_y += z * scale;
            }
            if (!(entity2 instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity2).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
            this.func_77277_b().put(entityplayer, new Vec3d(x * intensity, y * intensity, z * intensity));
        }
    }

    public static MutatedExplosion create(@Nonnull Entity exploder, float size, boolean causesFire, boolean damagesTerrain) {
        return MutatedExplosion.create(exploder.field_70170_p, exploder, exploder.field_70165_t, exploder.field_70163_u, exploder.field_70161_v, size, causesFire, damagesTerrain);
    }

    public static MutatedExplosion create(World world, @Nullable Entity exploder, double x, double y, double z, float size, boolean causesFire, boolean damagesTerrain) {
        MutatedExplosion explosion;
        if (damagesTerrain && exploder instanceof EntityLiving && !ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)exploder)) {
            damagesTerrain = false;
        }
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)(explosion = new MutatedExplosion(world, exploder, x, y, z, size, causesFire, damagesTerrain)))) {
            return explosion;
        }
        if (world instanceof WorldServer) {
            explosion.func_77278_a();
            explosion.func_77279_a(false);
            if (!damagesTerrain) {
                explosion.func_180342_d();
            }
            for (EntityPlayer entityplayer : world.field_73010_i) {
                if (!(entityplayer.func_70092_e(x, y, z) < 4096.0)) continue;
                ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new SPacketExplosion(x, y, z, size, explosion.func_180343_e(), (Vec3d)explosion.func_77277_b().get(entityplayer)));
            }
        }
        return explosion;
    }

    private static float getBlockDensity(Vec3d vec, Entity entity) {
        AxisAlignedBB bb = entity.func_174813_aQ();
        double d0 = 1.0 / ((bb.field_72336_d - bb.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((bb.field_72337_e - bb.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((bb.field_72334_f - bb.field_72339_c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int j2 = 0;
            int k2 = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d5 = bb.field_72340_a + (bb.field_72336_d - bb.field_72340_a) * (double)f;
                        double d6 = bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) * (double)f1;
                        double d7 = bb.field_72339_c + (bb.field_72334_f - bb.field_72339_c) * (double)f2;
                        RayTraceResult result = entity.field_70170_p.func_147447_a(new Vec3d(d5 + d3, d6, d7 + d4), vec, false, true, false);
                        if (result == null || result.field_72313_a == RayTraceResult.Type.MISS || result.field_72313_a == RayTraceResult.Type.BLOCK && entity.field_70170_p.func_180495_p(result.func_178782_a()).func_185900_c((IBlockAccess)entity.field_70170_p, result.func_178782_a()) != Block.field_185505_j) {
                            ++j2;
                        }
                        ++k2;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)j2 / (float)k2;
        }
        return 0.0f;
    }
}

