/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.util.ZombieResurrection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class SeismicWave
extends BlockPos {
    private boolean first;
    private boolean spawnParticles = true;

    public SeismicWave(int x, int y, int z) {
        super(x, y, z);
    }

    public SeismicWave(int x, int y, int z, boolean spawnParticles) {
        this(x, y, z);
        this.spawnParticles = spawnParticles;
    }

    public boolean isFirst() {
        return this.first;
    }

    public static void createWaves(World world, List<SeismicWave> list, int x1, int z1, int x2, int z2, int y) {
        int deltaX = x2 - x1;
        int deltaZ = z2 - z1;
        int xStep = deltaX < 0 ? -1 : 1;
        int zStep = deltaZ < 0 ? -1 : 1;
        deltaX = Math.abs(deltaX);
        deltaZ = Math.abs(deltaZ);
        int x = x1;
        int z = z1;
        int deltaX2 = deltaX * 2;
        int deltaZ2 = deltaZ * 2;
        SeismicWave.addWave(world, list, x1, y, z1, true);
        if (deltaX2 >= deltaZ2) {
            int error = deltaX;
            for (int i = 0; i < deltaX; ++i) {
                x += xStep;
                if ((error += deltaZ2) > deltaX2) {
                    z += zStep;
                    error -= deltaX2;
                }
                SeismicWave.addWave(world, list, x, y, z, false);
            }
        } else {
            int error = deltaZ;
            for (int i = 0; i < deltaZ; ++i) {
                z += zStep;
                if ((error += deltaX2) > deltaZ2) {
                    x += xStep;
                    error -= deltaZ2;
                }
                SeismicWave.addWave(world, list, x, y, z, false);
            }
        }
    }

    @Nullable
    public static SeismicWave addWave(World world, List<SeismicWave> list, int x, int y, int z, boolean first) {
        y = ZombieResurrection.getSuitableGround(world, x, y, z, 3, false);
        SeismicWave wave = null;
        if (y != -1 || first) {
            wave = new SeismicWave(x, y, z);
            if (first) {
                wave.first = true;
            }
            list.add(wave);
        }
        if (world.field_73012_v.nextInt(2) == 0) {
            list.add(new SeismicWave(x, y + 1, z, false));
        }
        return wave;
    }

    public void affectBlocks(World world, EntityLivingBase entity) {
        EntityPlayer player;
        if (!this.spawnParticles) {
            return;
        }
        IBlockState blockState = world.func_180495_p((BlockPos)this);
        Block block = blockState.func_177230_c();
        BlockPos posUp = new BlockPos((Vec3i)this.func_177984_a());
        EntityPlayer entityPlayer = player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        if (player != null && player.func_175142_cm() || world.func_82736_K().func_82766_b("mobGriefing")) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da || block == Blocks.field_150458_ak || block == Blocks.field_150391_bh || block instanceof BlockDirt && blockState.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.PODZOL) {
                world.func_180501_a((BlockPos)this, Blocks.field_150346_d.func_176223_P(), 2);
            }
            IBlockState blockStateUp = world.func_180495_p(posUp);
            float hardness = blockStateUp.func_185887_b(world, posUp);
            if (!blockStateUp.func_185913_b() && hardness > -1.0f && hardness <= 1.0f) {
                world.func_175655_b(posUp, player != null);
            }
            if (blockStateUp.func_177230_c() instanceof BlockDoor) {
                if (blockStateUp.func_185904_a() == Material.field_151575_d) {
                    world.func_175718_b(1019, posUp, 0);
                } else if (blockStateUp.func_185904_a() == Material.field_151573_f) {
                    world.func_175718_b(1020, posUp, 0);
                }
            }
            if (block instanceof BlockTNT) {
                ((BlockTNT)block).func_180692_a(world, (BlockPos)this, blockState.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)), (EntityLivingBase)player);
                world.func_175698_g((BlockPos)this);
            }
        }
        if (block == Blocks.field_150450_ax) {
            block.func_176199_a(world, (BlockPos)this, (Entity)entity);
        }
        world.func_175718_b(2001, posUp, Block.func_176210_f((IBlockState)blockState));
    }
}

