/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.entity.ai.EntityAICopySummonerTarget;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class ZombieResurrection
extends BlockPos {
    private int tick;
    private final World world;

    public ZombieResurrection(World world, int x, int y, int z) {
        super(x, y, z);
        this.world = world;
        this.tick = 100 + world.field_73012_v.nextInt(40);
    }

    public ZombieResurrection(World world, BlockPos pos, int tick) {
        super((Vec3i)pos);
        this.world = world;
        this.tick = tick;
    }

    public int getTick() {
        return this.tick;
    }

    public boolean update(MutantZombieEntity mutantZombie) {
        if (this.world.func_175623_d((BlockPos)this) || !this.world.func_180495_p((BlockPos)this).func_185904_a().func_76230_c()) {
            return false;
        }
        if (mutantZombie.func_70681_au().nextInt(15) == 0) {
            this.world.func_175718_b(2001, this.func_177984_a(), Block.func_176210_f((IBlockState)this.world.func_180495_p((BlockPos)this)));
        }
        if (--this.tick <= 0) {
            BlockPos posUp = this.func_177984_a();
            EntityZombie zombie = (EntityZombie)EntityList.func_191304_a(ZombieResurrection.getZombieByLocation(this.world, posUp), (World)this.world);
            IEntityLivingData entityLivingData = null;
            entityLivingData = zombie.func_180482_a(this.world.func_175649_E((BlockPos)this), entityLivingData);
            zombie.func_70606_j(zombie.func_110138_aP() * (0.6f + 0.4f * zombie.func_70681_au().nextFloat()));
            zombie.func_70642_aH();
            zombie.func_184210_p();
            this.world.func_175718_b(2001, posUp, Block.func_176210_f((IBlockState)this.world.func_180495_p((BlockPos)this)));
            if (!this.world.field_72995_K) {
                zombie.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAICopySummonerTarget((EntityCreature)zombie, mutantZombie));
                zombie.func_174828_a(posUp, mutantZombie.field_70177_z, 0.0f);
                this.world.func_72838_d((Entity)zombie);
            }
            return false;
        }
        return true;
    }

    public static int getSuitableGround(World world, int x, int y, int z) {
        return ZombieResurrection.getSuitableGround(world, x, y, z, 4, true);
    }

    public static int getSuitableGround(World world, int x, int y, int z, int range, boolean checkDay) {
        int i = y;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(x, y, z);
        BlockPos.MutableBlockPos abovePos = new BlockPos.MutableBlockPos((BlockPos)checkPos);
        while (Math.abs(y - i) <= range) {
            checkPos.func_185336_p(i);
            abovePos.func_185336_p(i + 1);
            IBlockState blockState = world.func_180495_p((BlockPos)checkPos);
            IBlockState blockStateUp = world.func_180495_p((BlockPos)abovePos);
            if (blockState.func_177230_c() != Blocks.field_150480_ab) {
                BlockPos pos1;
                float f;
                if (blockState.func_177230_c() != Blocks.field_150353_l) {
                    if (world.func_175623_d((BlockPos)checkPos)) {
                        --i;
                        continue;
                    }
                    if (!world.func_175623_d((BlockPos)checkPos) && world.func_175623_d((BlockPos)abovePos) && blockState.func_177230_c().func_176205_b((IBlockAccess)world, (BlockPos)checkPos)) {
                        --i;
                    } else if (!(world.func_175623_d((BlockPos)checkPos) || world.func_175623_d((BlockPos)abovePos) || blockStateUp.func_177230_c().func_176205_b((IBlockAccess)world, (BlockPos)abovePos))) {
                        ++i;
                        continue;
                    }
                }
                if (checkDay && world.func_72935_r() && (f = world.func_175724_o(pos1 = new BlockPos(x, y + 1, z))) > 0.5f && world.func_175678_i(pos1) && world.field_73012_v.nextInt(3) != 0) {
                    return -1;
                }
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static boolean canBeResurrected(Class<? extends Entity> entityClass) {
        return entityClass == EntityZombie.class || entityClass == EntityZombieVillager.class || entityClass == EntityHusk.class;
    }

    public static Class<? extends EntityLiving> getZombieByLocation(World world, BlockPos pos) {
        ArrayList<Biome.SpawnListEntry> zombieEntries = null;
        for (Biome.SpawnListEntry entry : world.func_180494_b(pos).func_76747_a(EnumCreatureType.MONSTER)) {
            if (!ZombieResurrection.canBeResurrected(entry.field_76300_b)) continue;
            if (zombieEntries == null) {
                zombieEntries = new ArrayList<Biome.SpawnListEntry>();
            }
            zombieEntries.add(entry);
        }
        return zombieEntries == null || zombieEntries.isEmpty() ? EntityZombie.class : ((Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, (List)zombieEntries)).field_76300_b;
    }
}

