/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantArrowRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantSkeletonModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantSkeletonEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class MutantSkeletonRenderer
extends MobRenderer<MutantSkeletonEntity, MutantSkeletonModel> {
    public static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_skeleton");
    private static final ResourceLocation CROSSBOW_TEXTURE = MutantBeasts.getEntityTexture("mutant_crossbow");

    public MutantSkeletonRenderer(EntityRendererManager manager) {
        super(manager, (EntityModel)new MutantSkeletonModel(), 0.6f);
        this.func_177094_a(new CrossbowLayer((IEntityRenderer<MutantSkeletonEntity, MutantSkeletonModel>)this));
    }

    protected float getDeathMaxRotation(MutantSkeletonEntity entityLivingBaseIn) {
        return 0.0f;
    }

    public ResourceLocation getEntityTexture(MutantSkeletonEntity entity) {
        return TEXTURE;
    }

    static class CrossbowLayer
    extends LayerRenderer<MutantSkeletonEntity, MutantSkeletonModel> {
        public CrossbowLayer(IEntityRenderer<MutantSkeletonEntity, MutantSkeletonModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantSkeletonEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            matrixStackIn.func_227860_a_();
            boolean leftHanded = entity.func_184638_cS();
            ((MutantSkeletonModel)this.func_215332_c()).translateHand(leftHanded, matrixStackIn);
            if (leftHanded) {
                matrixStackIn.func_227862_a_(-1.0f, 1.0f, -1.0f);
            }
            ((MutantSkeletonModel)this.func_215332_c()).getCrossbow().func_225598_a_(matrixStackIn, bufferIn.getBuffer(((MutantSkeletonModel)this.func_215332_c()).getCrossbow().func_228282_a_(CROSSBOW_TEXTURE)), packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.func_227865_b_();
            if (entity.getAnimation() == MutantSkeletonEntity.SHOOT_ANIMATION && entity.getAnimationTick() > 10 && entity.getAnimationTick() < 26 || entity.getAnimation() == MutantSkeletonEntity.MULTI_SHOT_ANIMATION && entity.getAnimationTick() > 16 && entity.getAnimationTick() < 24) {
                matrixStackIn.func_227860_a_();
                ((MutantSkeletonModel)this.func_215332_c()).translateHand(leftHanded, matrixStackIn);
                matrixStackIn.func_227861_a_(leftHanded ? 0.2 : -0.2, 0.4, -1.8);
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStackIn.func_227862_a_(1.2f, 1.2f, 1.2f);
                IVertexBuilder vertexBuilder = bufferIn.getBuffer(MutantArrowRenderer.MODEL.func_228282_a_(MutantArrowRenderer.TEXTURE));
                MutantArrowRenderer.MODEL.func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStackIn.func_227865_b_();
            }
        }
    }
}

