/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.AlternateMobRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantZombieModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class MutantZombieRenderer
extends AlternateMobRenderer<MutantZombieEntity, MutantZombieModel> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_zombie");

    public MutantZombieRenderer(EntityRendererManager manager) {
        super(manager, new MutantZombieModel(), 1.0f);
    }

    protected void preRenderCallback(MutantZombieEntity livingEntity, MatrixStack matrixStackIn, float partialTickTime) {
        matrixStackIn.func_227862_a_(1.3f, 1.3f, 1.3f);
    }

    protected void applyRotations(MutantZombieEntity livingEntity, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        if (livingEntity.field_70725_aQ > 0) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
            int pitch = Math.min(20, livingEntity.field_70725_aQ);
            boolean reviving = false;
            if (livingEntity.field_70725_aQ > 100) {
                pitch = 140 - livingEntity.field_70725_aQ;
                reviving = true;
            }
            if (pitch > 0) {
                float f = ((float)pitch + partialTicks - 1.0f) / 20.0f * 1.6f;
                if (reviving) {
                    f = ((float)pitch - partialTicks) / 40.0f * 1.6f;
                }
                if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                matrixStackIn.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(f * this.getDeathMaxRotation(livingEntity)));
            }
        } else {
            super.func_225621_a_((LivingEntity)livingEntity, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        }
    }

    protected float getDeathMaxRotation(MutantZombieEntity livingEntity) {
        return 80.0f;
    }

    protected RenderType func_230496_a_(MutantZombieEntity livingEntity, boolean isVisible, boolean visibleToSpectator, boolean glowing) {
        return super.func_230496_a_((LivingEntity)livingEntity, isVisible, visibleToSpectator |= livingEntity.vanishTime > 0, glowing);
    }

    @Override
    protected float getAlpha(MutantZombieEntity mob, float partialTicks) {
        return mob.vanishTime > 0 ? 1.0f - ((float)mob.vanishTime + partialTicks) / 100.0f * 0.6f : 1.0f;
    }

    @Override
    protected boolean showsHurtColor(MutantZombieEntity mob) {
        return super.showsHurtColor(mob) || mob.field_70725_aQ > 0 && mob.getLives() <= 0;
    }

    public ResourceLocation getEntityTexture(MutantZombieEntity entity) {
        return TEXTURE;
    }
}

