/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.animationapi.Animation;
import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import chumbanotz.mutantbeasts.entity.EndersoulCloneEntity;
import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.ai.goal.AnimationGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.HurtByNearestTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBMeleeAttackGoal;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.packet.HeldBlockPacket;
import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class MutantEndermanEntity
extends MonsterEntity
implements IAngerable,
IAnimatedEntity {
    private static final DataParameter<Optional<BlockPos>> TELEPORT_POSITION = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Byte> ACTIVE_ARM = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> CLONE = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Animation MELEE_ANIMATION = new Animation(10);
    public static final Animation THROW_ANIMATION = new Animation(14);
    public static final Animation STARE_ANIMATION = new Animation(100);
    public static final Animation TELEPORT_ANIMATION = new Animation(10);
    public static final Animation SCREAM_ANIMATION = new Animation(165);
    public static final Animation CLONE_ANIMATION = new Animation(600);
    public static final Animation TELESMASH_ANIMATION = new Animation(30);
    public static final Animation DEATH_ANIMATION = new Animation(280);
    private static final Animation[] ANIMATIONS = new Animation[]{MELEE_ANIMATION, THROW_ANIMATION, STARE_ANIMATION, TELEPORT_ANIMATION, SCREAM_ANIMATION, CLONE_ANIMATION, TELESMASH_ANIMATION, DEATH_ANIMATION};
    private Animation animation = Animation.NONE;
    private int animationTick;
    private int prevArmScale;
    private int armScale;
    public int hasTarget;
    private int screamDelayTick;
    private int[] heldBlock = new int[4];
    private int[] heldBlockTick = new int[4];
    private boolean triggerThrowBlock;
    private int blockFrenzy;
    @Nullable
    private List<Entity> capturedEntities;
    private DamageSource deathCause;
    private static final RangedInteger ANGER_TIME_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public MutantEndermanEntity(EntityType<? extends MutantEndermanEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 40;
        this.field_70138_W = 1.4f;
    }

    public MutantEndermanEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        this(MBEntityType.MUTANT_ENDERMAN, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ThrowBlockGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new StareGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TeleportGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ScreamGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CloneGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TeleSmashGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MBMeleeAttackGoal((CreatureEntity)this, 1.2).setMaxAttackTick(15));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByNearestTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new FindTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MutantEndermanEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 96.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TELEPORT_POSITION, Optional.empty());
        this.field_70180_af.func_187214_a(ACTIVE_ARM, (Object)0);
        this.field_70180_af.func_187214_a(CLONE, (Object)false);
    }

    public Optional<BlockPos> getTeleportPosition() {
        return (Optional)this.field_70180_af.func_187225_a(TELEPORT_POSITION);
    }

    private void setTeleportPosition(@Nullable BlockPos pos) {
        this.field_70180_af.func_187227_b(TELEPORT_POSITION, Optional.ofNullable(pos));
    }

    public int getHeldBlock(int index) {
        return this.heldBlock[index];
    }

    public void setHeldBlock(int index, int blockId, int tick) {
        this.heldBlock[index] = blockId;
        this.heldBlockTick[index] = tick;
        if (!this.field_70170_p.field_72995_K) {
            MBPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new HeldBlockPacket(this, blockId, index));
        }
    }

    public int getHeldBlockTick(int arm) {
        return this.heldBlockTick[arm];
    }

    public int getActiveArm() {
        return ((Byte)this.field_70180_af.func_187225_a(ACTIVE_ARM)).byteValue();
    }

    private void setActiveArm(int armId) {
        this.field_70180_af.func_187227_b(ACTIVE_ARM, (Object)((byte)armId));
    }

    public boolean isClone() {
        return (Boolean)this.field_70180_af.func_187225_a(CLONE);
    }

    private void setClone(boolean isClone) {
        this.field_70180_af.func_187227_b(CLONE, (Object)isClone);
        this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_MORPH, 2.0f, this.func_70647_i());
        this.field_70170_p.func_72960_a((Entity)this, (byte)0);
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230260_a__(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public void func_230259_a_(@Nullable UUID angerTarget) {
        this.angerTarget = angerTarget;
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_TIME_RANGE.func_233018_a_(this.field_70146_Z));
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.isClone() ? 2.55f : 3.9f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isClone() ? MBEntityType.ENDERSOUL_CLONE.func_220334_j() : super.func_213305_a(poseIn);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn);
    }

    protected float func_110146_f(float renderYawOffset, float distance) {
        return this.field_70725_aQ > 0 ? distance : super.func_110146_f(renderYawOffset, distance);
    }

    public int func_70641_bl() {
        return 1;
    }

    public int func_82143_as() {
        return this.isClone() ? 3 : super.func_82143_as();
    }

    public boolean func_70067_L() {
        return super.func_70067_L() && this.animation != TELEPORT_ANIMATION;
    }

    protected void func_213623_ec() {
    }

    public boolean func_230270_dK_() {
        return this.field_70173_aa % 100 == 0 && !this.isClone();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (CLONE.equals(key)) {
            this.func_213323_x_();
        }
        if (TELEPORT_POSITION.equals(key) && this.getTeleportPosition().isPresent() && this.field_70170_p.field_72995_K) {
            this.animation = TELEPORT_ANIMATION;
            this.animationTick = 0;
            this.spawnTeleportParticles();
        }
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        this.func_213395_q(entitylivingbaseIn != null);
    }

    public float getArmScale(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevArmScale, (float)this.armScale) / 10.0f;
    }

    private void updateTargetTick() {
        this.prevArmScale = this.armScale;
        if (this.func_213398_dR()) {
            this.hasTarget = 20;
        }
        boolean emptyHanded = true;
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] > 0) {
                emptyHanded = false;
            }
            if (this.hasTarget > 0) {
                if (this.heldBlock[i] <= 0) continue;
                this.heldBlockTick[i] = Math.min(10, this.heldBlockTick[i] + 1);
                continue;
            }
            this.heldBlockTick[i] = Math.max(0, this.heldBlockTick[i] - 1);
        }
        if (this.hasTarget > 0) {
            this.armScale = Math.min(10, this.armScale + 1);
        } else if (emptyHanded) {
            this.armScale = Math.max(0, this.armScale - 1);
        } else if (!this.field_70170_p.field_72995_K) {
            boolean mobGriefing = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
            for (int i = 0; i < this.heldBlock.length; ++i) {
                if (this.heldBlock[i] <= 0 || this.heldBlockTick[i] != 0) continue;
                BlockPos startPos = new BlockPos(this.func_226277_ct_() - 1.5 + this.field_70146_Z.nextDouble() * 4.0, this.func_226278_cu_() - 0.5 + this.field_70146_Z.nextDouble() * 2.5, this.func_226281_cx_() - 1.5 + this.field_70146_Z.nextDouble() * 4.0);
                BlockState heldState = Block.func_199770_b((BlockState)Block.func_196257_b((int)this.heldBlock[i]), (IWorld)this.field_70170_p, (BlockPos)startPos);
                if (mobGriefing && this.canPlaceBlock(this.field_70170_p, startPos, heldState, startPos.func_177977_b())) {
                    this.field_70170_p.func_175656_a(startPos, heldState);
                    SoundType soundType = heldState.getSoundType((IWorldReader)this.field_70170_p, startPos, (Entity)this);
                    this.field_70170_p.func_184133_a(null, startPos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                    this.setHeldBlock(i, 0, 0);
                    continue;
                }
                if (mobGriefing && this.field_70146_Z.nextInt(50) != 0) continue;
                this.triggerThrowBlock = true;
            }
        }
        this.hasTarget = Math.max(0, this.hasTarget - 1);
    }

    private boolean canPlaceBlock(World world, BlockPos startPos, BlockState heldState, BlockPos belowPos) {
        return world.func_175623_d(startPos) && !world.func_175623_d(belowPos) && world.func_180495_p(belowPos).func_235785_r_((IBlockReader)world, belowPos) && heldState.func_196955_c((IWorldReader)world, startPos) && world.func_72839_b((Entity)this, new AxisAlignedBB(startPos)).isEmpty();
    }

    private void updateScreamEntities() {
        this.screamDelayTick = Math.max(0, this.screamDelayTick - 1);
        if (this.animation == SCREAM_ANIMATION && this.animationTick >= 40 && this.animationTick <= 160) {
            if (this.animationTick == 160) {
                this.capturedEntities = null;
            } else if (this.capturedEntities == null) {
                this.capturedEntities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(20.0, 12.0, 20.0), EndersoulFragmentEntity.IS_VALID_TARGET);
            } else {
                Iterator<Entity> iterator = this.capturedEntities.iterator();
                while (iterator.hasNext()) {
                    Entity entity = iterator.next();
                    if (this.func_70068_e(entity) > 400.0 || entity.func_175149_v() || !entity.isAddedToWorld()) {
                        iterator.remove();
                        continue;
                    }
                    entity.field_70125_A += (this.field_70146_Z.nextFloat() - 0.3f) * 6.0f;
                }
            }
        }
    }

    public void func_70103_a(byte id) {
        if (id == 0) {
            this.spawnTeleportParticles();
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70636_d() {
        this.field_70703_bu = false;
        super.func_70636_d();
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.animation == DEATH_ANIMATION) {
            this.field_70725_aQ = this.animationTick;
        }
        this.updateTargetTick();
        this.updateScreamEntities();
        if (this.field_70170_p.field_72995_K && !this.isClone()) {
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_() + (double)(this.field_70725_aQ > 0 ? 1.0f : 0.0f) - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    private void updateBlockFrenzy() {
        this.blockFrenzy = Math.max(0, this.blockFrenzy - 1);
        if (this.func_70638_az() != null && !this.isAnimationPlaying() && !MutantBeasts.MUTANT_ENDERMAN_HOLABLE.func_230236_b_().isEmpty()) {
            if (this.blockFrenzy == 0 && (this.func_189748_bU() instanceof IndirectEntityDamageSource || this.field_70146_Z.nextInt(!this.func_70781_l() ? 300 : 600) == 0)) {
                this.blockFrenzy = 200 + this.field_70146_Z.nextInt(80);
            }
            if (this.blockFrenzy > 0 && this.field_70146_Z.nextInt(8) == 0) {
                int index = this.getFavorableHand();
                BlockPos pos = new BlockPos(this.func_226277_ct_() - 2.5 + this.field_70146_Z.nextDouble() * 5.0, this.func_226278_cu_() - 0.5 + this.field_70146_Z.nextDouble() * 3.0, this.func_226281_cx_() - 2.5 + this.field_70146_Z.nextDouble() * 5.0);
                BlockState blockState = this.field_70170_p.func_180495_p(pos);
                if (index != -1 && blockState.func_235714_a_(MutantBeasts.MUTANT_ENDERMAN_HOLABLE)) {
                    this.setHeldBlock(index, Block.func_196246_j((BlockState)blockState), 0);
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                        this.field_70170_p.func_217377_a(pos, false);
                    }
                }
            }
        }
    }

    private void updateTeleport() {
        LivingEntity entity = this.func_70638_az();
        this.teleportByChance(entity == null ? 1600 : 800, (Entity)entity);
        if (this.func_70090_H() || this.field_70143_R > 3.0f || entity != null && (this.func_184223_x((Entity)entity) || this.func_70068_e((Entity)entity) > 1024.0 || !this.func_70781_l())) {
            this.teleportByChance(10, (Entity)entity);
        }
    }

    protected void func_70619_bc() {
        this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        this.updateBlockFrenzy();
        this.updateTeleport();
    }

    private int getAvailableHand() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            list.add(i);
        }
        if (list.isEmpty()) {
            return -1;
        }
        return (Integer)list.get(this.field_70146_Z.nextInt(list.size()));
    }

    private int getFavorableHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            if (i <= 1) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!outer.isEmpty()) {
            return (Integer)outer.get(this.field_70146_Z.nextInt(outer.size()));
        }
        return (Integer)inner.get(this.field_70146_Z.nextInt(inner.size()));
    }

    private int getThrowingHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] <= 0) continue;
            if (i <= 1) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!inner.isEmpty()) {
            return (Integer)inner.get(this.field_70146_Z.nextInt(inner.size()));
        }
        return (Integer)outer.get(this.field_70146_Z.nextInt(outer.size()));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && !this.isAnimationPlaying()) {
            int arm = this.getAvailableHand();
            if (!this.teleportByChance(6, entityIn)) {
                if (arm != -1) {
                    boolean allHandsFree;
                    boolean bl = allHandsFree = this.heldBlock[0] == 0 && this.heldBlock[1] == 0;
                    if (allHandsFree && entityIn.func_200600_R() != EntityType.field_200760_az && this.field_70146_Z.nextInt(10) == 0) {
                        this.animation = CLONE_ANIMATION;
                    } else if (allHandsFree && this.field_70146_Z.nextInt(7) == 0) {
                        this.animation = TELESMASH_ANIMATION;
                    } else {
                        this.setActiveArm(arm);
                        this.animation = MELEE_ANIMATION;
                    }
                } else {
                    this.triggerThrowBlock = true;
                }
            }
        }
        if (this.isClone()) {
            boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(2) == 0) {
                double x = entityIn.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
                double y = entityIn.func_226278_cu_() + (double)this.field_70146_Z.nextInt(5) + 4.0;
                double z = entityIn.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
                this.teleportTo(x, y, z);
            }
            if (flag) {
                this.func_70691_i(2.0f);
                this.func_174815_a((LivingEntity)this, entityIn);
            }
            this.func_184609_a(Hand.MAIN_HAND);
            return flag;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76346_g() instanceof EnderDragonEntity || source.func_76346_g() instanceof MutantEndermanEntity) {
            return false;
        }
        if ((this.animation == TELEPORT_ANIMATION || this.animation == SCREAM_ANIMATION) && source != DamageSource.field_76380_i) {
            return false;
        }
        boolean damaged = super.func_70097_a(source, amount);
        if (damaged && this.animation == STARE_ANIMATION) {
            this.animation = Animation.NONE;
            return damaged;
        }
        if (!this.field_70170_p.field_72995_K && !this.isAnimationPlaying() && this.func_70089_S()) {
            boolean betterDodge;
            Entity entity = source.func_76346_g();
            boolean bl = betterDodge = entity == null;
            if (source.func_76352_a() || source.func_94541_c() || source == DamageSource.field_76379_h) {
                betterDodge = true;
            }
            if (this.teleportByChance(betterDodge ? 3 : 6, entity) && source != DamageSource.field_76380_i) {
                if (entity instanceof LivingEntity) {
                    this.func_70604_c((LivingEntity)entity);
                }
                return false;
            }
            boolean betterTeleport = source == DamageSource.field_76369_e || source == DamageSource.field_76368_d;
            this.teleportByChance(betterTeleport ? 3 : 5, entity);
        }
        return damaged;
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        return !this.isClone() && super.func_195064_c(effectInstanceIn);
    }

    private boolean teleportByChance(int chance, @Nullable Entity entity) {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        if (this.field_70146_Z.nextInt(Math.max(1, chance)) == 0) {
            return entity == null ? this.teleportRandomly() : this.teleportToEntity(entity);
        }
        return false;
    }

    private boolean teleportRandomly() {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double radius = 24.0;
        double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        double y = this.func_226278_cu_() + (double)this.field_70146_Z.nextInt((int)radius * 2) - radius;
        double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        return this.teleportTo(x, y, z);
    }

    private boolean teleportToEntity(Entity entity) {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double radius = 16.0;
        if (this.func_70068_e(entity) < 100.0) {
            x = entity.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
            y = entity.func_226278_cu_() + this.field_70146_Z.nextDouble() * radius;
            z = entity.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        } else {
            Vector3d vec = new Vector3d(this.func_226277_ct_() - entity.func_226277_ct_(), this.func_226283_e_(0.5) - entity.func_226280_cw_(), this.func_226281_cx_() - entity.func_226281_cx_());
            vec = vec.func_72432_b();
            x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72450_a * radius;
            y = this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(8) - vec.field_72448_b * radius;
            z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72449_c * radius;
        }
        return this.teleportTo(x, y, z);
    }

    private boolean teleportTo(double x, double y, double z) {
        if (!this.func_70613_aW()) {
            return false;
        }
        if (this.isClone()) {
            boolean flag = EntityUtil.teleportTo((MobEntity)this, x, y, z);
            if (flag) {
                this.func_184210_p();
                if (!this.func_174814_R()) {
                    this.field_70170_p.func_184134_a(this.field_70169_q, this.field_70167_r, this.field_70166_s, MBSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT, this.func_184176_by(), 1.0f, 1.0f, false);
                    this.func_184185_a(MBSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT, 1.0f, 1.0f);
                }
            }
            return flag;
        }
        if (!this.isAnimationPlaying()) {
            this.animation = TELEPORT_ANIMATION;
            BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
            boolean success = false;
            if (this.field_70170_p.func_195588_v((BlockPos)pos)) {
                do {
                    pos.func_189536_c(Direction.DOWN);
                } while (pos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76230_c());
                pos.func_189536_c(Direction.UP);
                AxisAlignedBB bb = this.func_200600_R().func_220328_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                if (this.field_70170_p.func_226665_a__((Entity)this, bb) && !this.field_70170_p.func_72953_d(bb)) {
                    success = true;
                }
            }
            if (!success) {
                this.animation = Animation.NONE;
                return false;
            }
            this.setTeleportPosition((BlockPos)pos);
            return true;
        }
        return false;
    }

    public static void teleportAttack(LivingEntity attacker) {
        double radius = 3.0;
        int duration = 140 + attacker.func_70681_au().nextInt(60);
        DamageSource damageSource = DamageSource.func_76358_a((LivingEntity)attacker);
        if (attacker instanceof PlayerEntity) {
            radius = 2.0;
            duration = 100;
            damageSource = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker));
        }
        for (Entity entity : attacker.field_70170_p.func_175674_a((Entity)attacker, attacker.func_174813_aQ().func_186662_g(radius), EndersoulFragmentEntity.IS_VALID_TARGET)) {
            if (entity instanceof LivingEntity && entity.func_70097_a(damageSource, 4.0f) && attacker.func_70681_au().nextInt(3) == 0) {
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76440_q, duration));
            }
            double x = entity.func_226277_ct_() - attacker.func_226277_ct_();
            double z = entity.func_226281_cx_() - attacker.func_226281_cx_();
            double signX = x / Math.abs(x);
            double signZ = z / Math.abs(z);
            entity.func_213293_j((radius * signX * 2.0 - x) * (double)0.2f, (double)0.2f, (radius * signZ * 2.0 - z) * (double)0.2f);
            EntityUtil.sendPlayerVelocityPacket(entity);
        }
    }

    private void spawnTeleportParticles() {
        BlockPos teleportPos = this.getTeleportPosition().orElse(null);
        int amount = teleportPos != null ? 512 : 256;
        for (int i = 0; i < amount; ++i) {
            boolean useCurrentPos = teleportPos == null || i < amount / 2;
            double tempX = (useCurrentPos ? this.func_226277_ct_() : (double)teleportPos.func_177958_n()) + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf();
            double tempY = (useCurrentPos ? this.func_226278_cu_() : (double)teleportPos.func_177956_o()) + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213302_cg() + 1.5;
            double tempZ = (useCurrentPos ? this.func_226281_cx_() : (double)teleportPos.func_177952_p()) + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf();
            this.field_70170_p.func_195594_a((IParticleData)MBParticleTypes.ENDERSOUL, tempX, tempY, tempZ, (this.field_70146_Z.nextDouble() - 0.5) * 1.8, (this.field_70146_Z.nextDouble() - 0.5) * 1.8, (this.field_70146_Z.nextDouble() - 0.5) * 1.8);
        }
    }

    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(3.0);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_213371_e(LivingEntity livingEntity) {
        if (this.isClone()) {
            super.func_213371_e(livingEntity);
        } else {
            livingEntity.field_70133_I = true;
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.capturedEntities = null;
        if (!this.field_70170_p.field_72995_K) {
            this.deathCause = cause;
            this.field_70714_bg.func_220888_c().forEach(PrioritizedGoal::func_75251_c);
            IAnimatedEntity.sendAnimationPacket(this, DEATH_ANIMATION);
            if (this.field_70718_bc > 0) {
                this.field_70718_bc += DEATH_ANIMATION.getDuration();
            }
        }
    }

    protected void func_70609_aI() {
        this.func_213293_j(0.0, Math.min(this.func_213322_ci().field_72448_b, 0.0), 0.0);
        if (this.field_70725_aQ == 80) {
            this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_DEATH, 5.0f, this.func_70647_i());
        }
        if (this.field_70725_aQ >= 60) {
            if (this.field_70725_aQ < 80 && this.capturedEntities == null) {
                this.capturedEntities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(10.0, 8.0, 10.0), EndersoulFragmentEntity.IS_VALID_TARGET);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(3) != 0) {
                EndersoulFragmentEntity orb = new EndersoulFragmentEntity(this.field_70170_p, this);
                orb.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 3.8, this.func_226281_cx_());
                orb.func_213293_j((this.field_70146_Z.nextDouble() - 0.5) * 1.5, (this.field_70146_Z.nextDouble() - 0.5) * 1.5, (this.field_70146_Z.nextDouble() - 0.5) * 1.5);
                this.field_70170_p.func_217376_c((Entity)orb);
            }
        }
        if (this.field_70725_aQ >= 80 && this.field_70725_aQ < DEATH_ANIMATION.getDuration() - 20 && this.capturedEntities != null) {
            Iterator<Entity> iterator = this.capturedEntities.iterator();
            while (iterator.hasNext()) {
                Entity entity = iterator.next();
                if (entity.field_70143_R > 4.5f) {
                    entity.field_70143_R = 4.5f;
                }
                if (!(this.func_70068_e(entity) > 64.0)) continue;
                if (EndersoulFragmentEntity.isProtected(entity) || entity.func_175149_v() || !entity.isAddedToWorld()) {
                    iterator.remove();
                    continue;
                }
                double x = this.func_226277_ct_() - entity.func_226277_ct_();
                double y = entity.func_213322_ci().field_72448_b;
                double z = this.func_226281_cx_() - entity.func_226281_cx_();
                double d = Math.sqrt(x * x + z * z);
                if (this.func_226278_cu_() + 4.0 > entity.func_226278_cu_()) {
                    y = Math.max(entity.func_213322_ci().field_72448_b, (double)0.4f);
                }
                entity.func_213293_j((double)0.8f * x / d, y, (double)0.8f * z / d);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70725_aQ >= 100 && this.field_70725_aQ < 150 && this.field_70725_aQ % 6 == 0 && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            super.func_213354_a(this.deathCause != null ? this.deathCause : DamageSource.field_76377_j, this.field_70718_bc > 0);
        }
        if (this.field_70725_aQ >= DEATH_ANIMATION.getDuration()) {
            this.func_226294_cV_();
            this.func_70106_y();
        }
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
    }

    protected boolean func_146066_aG() {
        return this.field_70725_aQ > 0;
    }

    public ItemEntity func_199701_a_(ItemStack stack) {
        return this.field_70725_aQ > 0 ? this.func_70099_a(stack, 3.84f) : super.func_199701_a_(stack);
    }

    public static boolean canSpawn(EntityType<MutantEndermanEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return randomIn.nextInt(3) == 0 && MutantEndermanEntity.func_223325_c(type, (IServerWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected ITextComponent func_225513_by_() {
        return this.isClone() ? MBEntityType.ENDERSOUL_CLONE.func_212546_e() : super.func_225513_by_();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.func_233682_c_(compound);
        compound.func_74768_a("BlockFrenzy", this.blockFrenzy);
        compound.func_74768_a("ScreamDelay", this.screamDelayTick);
        ListNBT listNBT = new ListNBT();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] <= 0) continue;
            CompoundNBT compoundNBT = NBTUtil.func_190009_a((BlockState)Block.func_196257_b((int)this.heldBlock[i]));
            compound.func_74774_a("Index", (byte)i);
            compoundNBT.func_74768_a("Tick", this.heldBlockTick[i]);
            listNBT.add((Object)compoundNBT);
        }
        if (!listNBT.isEmpty()) {
            compound.func_218657_a("HeldBlocks", (INBT)listNBT);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.field_70170_p instanceof ServerWorld) {
            this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
        }
        this.blockFrenzy = compound.func_74762_e("BlockFrenzy");
        this.screamDelayTick = compound.func_74762_e("ScreamDelay");
        if (compound.func_150297_b("HeldBlocks", 9)) {
            ListNBT listNBT = compound.func_150295_c("HeldBlocks", 9);
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundNBT compoundNBT = listNBT.func_150305_b(i);
                BlockState blockState = NBTUtil.func_190008_d((CompoundNBT)compoundNBT);
                this.setHeldBlock(compoundNBT.func_74771_c("Index"), Block.func_196246_j((BlockState)blockState), compound.func_74762_e("Tick"));
            }
        }
        if (this.field_70725_aQ > 0) {
            this.animation = DEATH_ANIMATION;
            this.animationTick = this.field_70725_aQ;
        }
    }

    public int func_70627_aG() {
        return 200;
    }

    public void func_70642_aH() {
        if (!this.isClone()) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_ENDERMAN_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_ENDERMAN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_ENDERMAN_HURT;
    }

    private boolean isBeingLookedAtBy(LivingEntity target) {
        if (target instanceof MobEntity) {
            return ((MobEntity)target).func_70638_az() == this && target.func_70685_l((Entity)this);
        }
        Vector3d lookVec = target.func_70676_i(1.0f).func_72432_b();
        Vector3d targetVec = new Vector3d(this.func_226277_ct_() - target.func_226277_ct_(), this.func_226280_cw_() - target.func_226280_cw_(), this.func_226281_cx_() - target.func_226281_cx_());
        double length = targetVec.func_72433_c();
        double d = lookVec.func_72430_b(targetVec = targetVec.func_72432_b());
        return d > 1.0 - 0.08 / length ? target.func_70685_l((Entity)this) : false;
    }

    @Override
    public void writeSpawnData(PacketBuffer buffer) {
        IAnimatedEntity.super.writeSpawnData(buffer);
        buffer.func_150787_b(this.hasTarget);
        buffer.func_150787_b(this.armScale);
        buffer.func_186875_a(this.heldBlock);
        buffer.func_186875_a(this.heldBlockTick);
    }

    @Override
    public void readSpawnData(PacketBuffer additionalData) {
        IAnimatedEntity.super.readSpawnData(additionalData);
        this.hasTarget = additionalData.func_150792_a();
        this.armScale = additionalData.func_150792_a();
        this.heldBlock = additionalData.func_186863_b();
        this.heldBlockTick = additionalData.func_186863_b();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static class ThrowBlockGoal
    extends AnimationGoal<MutantEndermanEntity> {
        public ThrowBlockGoal(MutantEndermanEntity mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            if (((MutantEndermanEntity)this.mob).isAnimationPlaying()) {
                return false;
            }
            if (!((MutantEndermanEntity)this.mob).triggerThrowBlock && ((MutantEndermanEntity)this.mob).func_70681_au().nextInt(28) != 0) {
                return false;
            }
            if (((MutantEndermanEntity)this.mob).func_70638_az() != null && !((MutantEndermanEntity)this.mob).func_70685_l((Entity)((MutantEndermanEntity)this.mob).func_70638_az())) {
                return false;
            }
            int id = ((MutantEndermanEntity)this.mob).getThrowingHand();
            if (id == -1) {
                return false;
            }
            ((MutantEndermanEntity)this.mob).setActiveArm(id);
            return true;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            int id = ((MutantEndermanEntity)this.mob).getActiveArm();
            ((MutantEndermanEntity)this.mob).field_70170_p.func_217376_c((Entity)new ThrowableBlockEntity((MutantEndermanEntity)this.mob, id));
            ((MutantEndermanEntity)this.mob).setHeldBlock(id, 0, 0);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            ((MutantEndermanEntity)this.mob).triggerThrowBlock = false;
        }
    }

    static class TeleSmashGoal
    extends AnimationGoal<MutantEndermanEntity> {
        private LivingEntity attackTarget;

        public TeleSmashGoal(MutantEndermanEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return TELESMASH_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantEndermanEntity)this.mob).func_70638_az();
            return this.attackTarget != null && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.attackTarget.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 5));
            this.attackTarget.func_195064_c(new EffectInstance(Effects.field_76431_k, 160 + this.attackTarget.func_70681_au().nextInt(160)));
        }

        public void func_75246_d() {
            ((MutantEndermanEntity)this.mob).func_70661_as().func_75499_g();
            if (((MutantEndermanEntity)this.mob).animationTick < 20) {
                ((MutantEndermanEntity)this.mob).field_70749_g.func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (((MutantEndermanEntity)this.mob).animationTick == 17) {
                this.attackTarget.func_184210_p();
            }
            if (((MutantEndermanEntity)this.mob).animationTick == 18) {
                double x = this.attackTarget.func_226277_ct_() + (this.attackTarget.func_70681_au().nextDouble() - 0.5) * 14.0;
                double y = this.attackTarget.func_226278_cu_() + this.attackTarget.func_70681_au().nextDouble() + (this.attackTarget instanceof PlayerEntity ? 13.0 : 7.0);
                double z = this.attackTarget.func_226281_cx_() + (this.attackTarget.func_70681_au().nextDouble() - 0.5) * 14.0;
                EntityUtil.stunRavager(this.attackTarget);
                EntityUtil.sendParticlePacket((Entity)this.attackTarget, (IParticleData)MBParticleTypes.ENDERSOUL, 256);
                this.attackTarget.func_70634_a(x, y, z);
                ((MutantEndermanEntity)this.mob).field_70170_p.func_184148_a(null, x, y, z, SoundEvents.field_187539_bB, this.attackTarget.func_184176_by(), 1.2f, 0.9f + this.attackTarget.func_70681_au().nextFloat() * 0.2f);
                this.attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob).func_76348_h().func_151518_m(), 6.0f);
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.attackTarget = null;
        }
    }

    static class TeleportGoal
    extends AnimationGoal<MutantEndermanEntity> {
        public TeleportGoal(MutantEndermanEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return TELEPORT_ANIMATION;
        }

        @Override
        public void func_75249_e() {
            ((MutantEndermanEntity)this.mob).animation = TELEPORT_ANIMATION;
            ((MutantEndermanEntity)this.mob).animationTick = 0;
            MutantEndermanEntity.teleportAttack((LivingEntity)this.mob);
            ((MutantEndermanEntity)this.mob).getTeleportPosition().ifPresent(pos -> ((MutantEndermanEntity)this.mob).func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5));
            if (!((MutantEndermanEntity)this.mob).func_174814_R()) {
                ((MutantEndermanEntity)this.mob).field_70170_p.func_184148_a(null, ((MutantEndermanEntity)this.mob).field_70169_q, ((MutantEndermanEntity)this.mob).field_70167_r, ((MutantEndermanEntity)this.mob).field_70166_s, MBSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT, ((MutantEndermanEntity)this.mob).func_184176_by(), 1.0f, 1.0f);
                ((MutantEndermanEntity)this.mob).func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            }
            MutantEndermanEntity.teleportAttack((LivingEntity)this.mob);
            ((MutantEndermanEntity)this.mob).func_70107_b(((MutantEndermanEntity)this.mob).field_70169_q, ((MutantEndermanEntity)this.mob).field_70167_r, ((MutantEndermanEntity)this.mob).field_70166_s);
        }

        public void func_75246_d() {
            ((MutantEndermanEntity)this.mob).func_70661_as().func_75499_g();
        }

        @Override
        public void func_75251_c() {
            ((MutantEndermanEntity)this.mob).func_184210_p();
            ((MutantEndermanEntity)this.mob).field_70143_R = 0.0f;
            ((MutantEndermanEntity)this.mob).getTeleportPosition().ifPresent(pos -> ((MutantEndermanEntity)this.mob).func_70634_a((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5));
            super.func_75251_c();
            ((MutantEndermanEntity)this.mob).setTeleportPosition(null);
        }
    }

    static class ScreamGoal
    extends AnimationGoal<MutantEndermanEntity> {
        public ScreamGoal(MutantEndermanEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return SCREAM_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            if (((MutantEndermanEntity)this.mob).func_70638_az() != null && !((MutantEndermanEntity)this.mob).isAnimationPlaying()) {
                return ((MutantEndermanEntity)this.mob).screamDelayTick > 0 ? false : ((MutantEndermanEntity)this.mob).func_70068_e((Entity)((MutantEndermanEntity)this.mob).func_70638_az()) < 400.0 && ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(((MutantEndermanEntity)this.mob).func_70026_G() ? 400 : 1200) == 0;
            }
            return false;
        }

        public void func_75246_d() {
            ((MutantEndermanEntity)this.mob).func_70661_as().func_75499_g();
            if (((MutantEndermanEntity)this.mob).animationTick == 40) {
                ((MutantEndermanEntity)this.mob).field_70757_a = -((MutantEndermanEntity)this.mob).func_70627_aG();
                ((MutantEndermanEntity)this.mob).field_70170_p.func_72912_H().func_76084_b(false);
                ((MutantEndermanEntity)this.mob).field_70170_p.func_72960_a((Entity)this.mob, (byte)0);
                ((MutantEndermanEntity)this.mob).func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_SCREAM, 5.0f, 0.7f + ((MutantEndermanEntity)this.mob).field_70146_Z.nextFloat() * 0.2f);
                for (Entity entity : ((MutantEndermanEntity)this.mob).field_70170_p.func_175674_a((Entity)this.mob, ((MutantEndermanEntity)this.mob).func_174813_aQ().func_72314_b(20.0, 12.0, 20.0), EndersoulFragmentEntity.IS_VALID_TARGET)) {
                    if (!(((MutantEndermanEntity)this.mob).func_70068_e(entity) < 400.0)) continue;
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob).func_76348_h().func_151518_m(), 4.0f);
                    if (!(entity instanceof MobEntity)) continue;
                    MobEntity mobEntity = (MobEntity)entity;
                    mobEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 120, 3));
                    if (((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(2) != 0) {
                        mobEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, 120 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(180), ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(2)));
                    }
                    if (((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(4) != 0) {
                        mobEntity.func_195064_c(new EffectInstance(Effects.field_76437_t, 300 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(300), ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(2)));
                    }
                    if (((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(3) != 0) {
                        mobEntity.func_195064_c(new EffectInstance(Effects.field_76438_s, 120 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(60), 10 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(2)));
                    }
                    if (((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(4) == 0) continue;
                    mobEntity.func_195064_c(new EffectInstance(Effects.field_76431_k, 120 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(400)));
                }
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            ((MutantEndermanEntity)this.mob).screamDelayTick = 600;
        }
    }

    static class CloneGoal
    extends AnimationGoal<MutantEndermanEntity> {
        private final List<EndersoulCloneEntity> cloneList = new ArrayList<EndersoulCloneEntity>();
        private LivingEntity attackTarget;

        public CloneGoal(MutantEndermanEntity mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return CLONE_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantEndermanEntity)this.mob).func_70638_az();
            if (this.attackTarget == null) {
                return false;
            }
            if (this.attackTarget.func_200600_R() != EntityType.field_200760_az && ((MutantEndermanEntity)this.mob).heldBlock[0] == 0 && ((MutantEndermanEntity)this.mob).heldBlock[1] == 0) {
                return ((MutantEndermanEntity)this.mob).field_70737_aN == 0 && (super.func_75250_a() || !((MutantEndermanEntity)this.mob).isAnimationPlaying() && ((MutantEndermanEntity)this.mob).field_70173_aa % 3 == 0 && ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(300) == 0);
            }
            return false;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ((MutantEndermanEntity)this.mob).field_70172_ad = 20;
            ((MutantEndermanEntity)this.mob).field_70138_W = 1.0f;
            ((MutantEndermanEntity)this.mob).setClone(true);
            ((MutantEndermanEntity)this.mob).func_70066_B();
            ((MutantEndermanEntity)this.mob).func_195061_cb();
            for (int i = 0; i < 7; ++i) {
                double x = this.attackTarget.func_226277_ct_() + (((MutantEndermanEntity)this.mob).field_70146_Z.nextDouble() - 0.5) * 24.0;
                double y = this.attackTarget.func_226278_cu_() + 8.0;
                double z = this.attackTarget.func_226281_cx_() + (((MutantEndermanEntity)this.mob).field_70146_Z.nextDouble() - 0.5) * 24.0;
                this.createClone(x, y, z);
            }
            this.createClone(((MutantEndermanEntity)this.mob).field_70169_q, ((MutantEndermanEntity)this.mob).field_70167_r, ((MutantEndermanEntity)this.mob).field_70166_s);
            double x = this.attackTarget.func_226277_ct_() + (((MutantEndermanEntity)this.mob).field_70146_Z.nextDouble() - 0.5) * 24.0;
            double y = this.attackTarget.func_226278_cu_() + 8.0;
            double z = this.attackTarget.func_226281_cx_() + (((MutantEndermanEntity)this.mob).field_70146_Z.nextDouble() - 0.5) * 24.0;
            ((MutantEndermanEntity)this.mob).teleportTo(x, y, z);
            EntityUtil.divertAttackers(this.mob, (LivingEntity)this.getRandomClone());
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && ((MutantEndermanEntity)this.mob).func_70638_az() != null && !this.cloneList.isEmpty() && ((MutantEndermanEntity)this.mob).field_70737_aN == 0;
        }

        public void func_75246_d() {
            for (int i = this.cloneList.size() - 1; i >= 0; --i) {
                EndersoulCloneEntity clone = this.cloneList.get(i);
                if (clone.func_70089_S() && clone.field_70170_p == ((MutantEndermanEntity)this.mob).field_70170_p) continue;
                this.cloneList.remove(i);
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            ((MutantEndermanEntity)this.mob).setClone(false);
            ((MutantEndermanEntity)this.mob).field_70138_W = 1.4f;
            for (EndersoulCloneEntity clone : this.cloneList) {
                if (!clone.func_70089_S()) continue;
                clone.func_70106_y();
                EntityUtil.divertAttackers((MobEntity)clone, (LivingEntity)this.mob);
            }
            this.cloneList.clear();
            ((MutantEndermanEntity)this.mob).func_70661_as().func_75499_g();
            this.attackTarget.func_70604_c((LivingEntity)this.mob);
            this.attackTarget = null;
        }

        private void createClone(double x, double y, double z) {
            EndersoulCloneEntity clone = (EndersoulCloneEntity)MBEntityType.ENDERSOUL_CLONE.func_200721_a(((MutantEndermanEntity)this.mob).field_70170_p);
            clone.setCloner((MutantEndermanEntity)this.mob);
            this.cloneList.add(clone);
            if (!EntityUtil.teleportTo((MobEntity)clone, x, y, z)) {
                clone.func_82149_j((Entity)this.mob);
            }
            ((MutantEndermanEntity)this.mob).field_70170_p.func_217376_c((Entity)clone);
        }

        private MobEntity getRandomClone() {
            return this.cloneList.isEmpty() ? this.mob : (MobEntity)this.cloneList.get(((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(this.cloneList.size()));
        }
    }

    static class MeleeGoal
    extends AnimationGoal<MutantEndermanEntity> {
        public MeleeGoal(MutantEndermanEntity mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return MELEE_ANIMATION;
        }

        public void func_75246_d() {
            if (((MutantEndermanEntity)this.mob).animationTick == 3) {
                ((MutantEndermanEntity)this.mob).func_184185_a(SoundEvents.field_187727_dV, 1.0f, ((MutantEndermanEntity)this.mob).func_70647_i());
                boolean lower = ((MutantEndermanEntity)this.mob).getActiveArm() >= 2;
                float attackDamage = (float)((MutantEndermanEntity)this.mob).func_233637_b_(Attributes.field_233823_f_);
                for (LivingEntity livingEntity : ((MutantEndermanEntity)this.mob).field_70170_p.func_217357_a(LivingEntity.class, ((MutantEndermanEntity)this.mob).func_174813_aQ().func_186662_g(4.0))) {
                    if (livingEntity instanceof MutantEndermanEntity || livingEntity instanceof EndersoulCloneEntity) continue;
                    double dist = ((MutantEndermanEntity)this.mob).func_70032_d((Entity)livingEntity);
                    double x = ((MutantEndermanEntity)this.mob).func_226277_ct_() - livingEntity.func_226277_ct_();
                    double z = ((MutantEndermanEntity)this.mob).func_226281_cx_() - livingEntity.func_226281_cx_();
                    if (!(((MutantEndermanEntity)this.mob).func_174813_aQ().field_72338_b <= livingEntity.func_174813_aQ().field_72337_e) || !(dist <= 4.0) || !(EntityUtil.getHeadAngle((LivingEntity)this.mob, x, z) < 3.0f + (1.0f - (float)dist / 4.0f) * 40.0f)) continue;
                    livingEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob), attackDamage > 0.0f ? attackDamage + (lower ? 1.0f : 3.0f) : 0.0f);
                    float power = 0.4f + ((MutantEndermanEntity)this.mob).field_70146_Z.nextFloat() * 0.2f;
                    if (!lower) {
                        power += 0.2f;
                    }
                    livingEntity.func_213293_j(-x / dist * (double)power, (double)(power * 0.6f), -z / dist * (double)power);
                    EntityUtil.sendPlayerVelocityPacket((Entity)livingEntity);
                }
            }
        }
    }

    static class StareGoal
    extends AnimationGoal<MutantEndermanEntity> {
        private LivingEntity attackTarget;

        public StareGoal(MutantEndermanEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return STARE_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantEndermanEntity)this.mob).func_70638_az();
            return this.attackTarget != null && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ((MutantEndermanEntity)this.mob).field_70757_a = -((MutantEndermanEntity)this.mob).func_70627_aG();
            ((MutantEndermanEntity)this.mob).field_70170_p.func_217384_a(null, (Entity)this.mob, MBSoundEvents.ENTITY_MUTANT_ENDERMAN_STARE, ((MutantEndermanEntity)this.mob).func_184176_by(), 2.5f, 0.7f + ((MutantEndermanEntity)this.mob).field_70146_Z.nextFloat() * 0.2f);
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && this.attackTarget.func_70089_S() && ((MutantEndermanEntity)this.mob).isBeingLookedAtBy(this.attackTarget);
        }

        public void func_75246_d() {
            ((MutantEndermanEntity)this.mob).func_70661_as().func_75499_g();
            ((MutantEndermanEntity)this.mob).field_70749_g.func_75651_a((Entity)this.attackTarget, 45.0f, 45.0f);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.attackTarget.func_184210_p();
            this.attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob).func_76348_h().func_151518_m(), 2.0f);
            this.attackTarget.func_195064_c(new EffectInstance(Effects.field_76440_q, 160 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(140)));
            double x = ((MutantEndermanEntity)this.mob).func_226277_ct_() - this.attackTarget.func_226277_ct_();
            double z = ((MutantEndermanEntity)this.mob).func_226281_cx_() - this.attackTarget.func_226281_cx_();
            this.attackTarget.func_213293_j(x * (double)0.1f, (double)0.3f, z * (double)0.1f);
            EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
            this.attackTarget = null;
        }
    }

    static class FindTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public FindTargetGoal(MutantEndermanEntity mutantEnderman) {
            super((MobEntity)mutantEnderman, LivingEntity.class, 10, false, false, target -> (mutantEnderman.func_233680_b_((LivingEntity)target) || mutantEnderman.isBeingLookedAtBy(target) || EndersoulFragmentEntity.isProtected((Entity)target)) && target.func_190631_cK());
        }

        public boolean func_75250_a() {
            boolean flag;
            boolean bl = flag = !((MutantEndermanEntity)this.field_75299_d).isAnimationPlaying() && super.func_75250_a();
            if (flag && ((MutantEndermanEntity)this.field_75299_d).isBeingLookedAtBy(this.field_75309_a)) {
                ((MutantEndermanEntity)this.field_75299_d).animation = STARE_ANIMATION;
            }
            return flag;
        }

        protected AxisAlignedBB func_188511_a(double targetDistance) {
            return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, targetDistance / 2.0, targetDistance);
        }
    }
}

