/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.HurtByNearestTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBMeleeAttackGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.OwnerTargetGoal;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class SpiderPigEntity
extends TameableEntity
implements IJumpingMount,
IEquipable,
IAngerable {
    private static final DataParameter<Boolean> CLIMBING = EntityDataManager.func_187226_a(SpiderPigEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV, Items.field_151147_al, Items.field_151070_bp});
    private int leapCooldown;
    private int leapTick;
    private boolean isLeaping;
    private float chargePower;
    private int chargingTick;
    private int chargeExhaustion;
    private boolean chargeExhausted;
    private final List<WebPos> webList = new ArrayList<WebPos>(12);
    private static final RangedInteger field_234230_bG_ = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public SpiderPigEntity(EntityType<? extends SpiderPigEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MBMeleeAttackGoal((CreatureEntity)this, 1.1).setMaxAttackTick(16));
        this.field_70714_bg.func_75776_a(2, (Goal)new LeapAttackGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.1, () -> ((SpiderPigEntity)this).func_70631_g_()));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 5.0f, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new TemptGoal((CreatureEntity)this, 1.1, false, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151146_bM})));
        this.field_70714_bg.func_75776_a(6, (Goal)new TemptGoal((CreatureEntity)this, 1.1, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerTargetGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByNearestTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((SpiderPigEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(3, (Goal)new NonTamedTargetGoal((TameableEntity)this, MobEntity.class, true, SpiderPigEntity::isPigOrSpider));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return SpiderPigEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)false);
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.field_70180_af.func_187225_a(CLIMBING);
    }

    private void setBesideClimbableBlock(boolean climbing) {
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.75f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        return potioneffectIn.func_188419_a() != Effects.field_76436_u && super.func_70687_e(potioneffectIn);
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.setBesideClimbableBlock(this.field_70123_F);
        if (this.chargeExhaustion >= 120) {
            this.chargeExhausted = true;
        }
        if (this.chargeExhaustion <= 0) {
            this.chargeExhausted = false;
        }
        this.chargeExhaustion = Math.max(0, this.chargeExhaustion - 1);
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
            this.leapCooldown = Math.max(0, this.leapCooldown - 1);
            if (this.leapTick > 10 && this.field_70122_E) {
                this.isLeaping = false;
            }
            this.updateWebList(false);
            this.updateChargeState();
            if (this.func_70089_S() && this.func_70909_n() && this.field_70173_aa % 600 == 0) {
                this.func_70691_i(1.0f);
            }
        }
    }

    private void updateWebList(boolean onlyCheckSize) {
        WebPos first;
        if (!onlyCheckSize) {
            for (int i = 0; i < this.webList.size(); ++i) {
                WebPos coord = this.webList.get(i);
                if (this.field_70170_p.func_180495_p((BlockPos)coord) != Blocks.field_196553_aF.func_176223_P()) {
                    this.webList.remove(i);
                    --i;
                    continue;
                }
                --coord.timeLeft;
            }
            if (!this.webList.isEmpty() && (first = this.webList.get(0)).timeLeft < 0) {
                this.webList.remove(0);
                this.removeWeb(first);
            }
        }
        while (this.webList.size() > 12) {
            first = this.webList.remove(0);
            this.removeWeb(first);
        }
    }

    private void removeWeb(BlockPos pos) {
        if (this.field_70170_p.func_180495_p(pos).func_203425_a(Blocks.field_196553_aF) && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            this.field_70170_p.func_225521_a_(pos, false, (Entity)this);
        }
    }

    private void updateChargeState() {
        if (this.chargingTick > 0) {
            for (LivingEntity livingEntity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ(), EntityPredicates.func_200820_b((Entity)this))) {
                if (livingEntity == this || livingEntity == this.func_70902_q() || !livingEntity.func_190631_cK()) continue;
                this.func_70652_k((Entity)livingEntity);
            }
        }
        this.chargingTick = Math.max(0, this.chargingTick - 1);
    }

    public ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand hand) {
        ActionResultType actionresulttype = super.func_230254_b_(playerEntity, hand);
        if (!actionresulttype.func_226246_a_() && this.func_152114_e((LivingEntity)playerEntity)) {
            ItemStack itemstack = playerEntity.func_184586_b(hand);
            boolean isBreedingItem = this.func_70877_b(itemstack);
            if (!isBreedingItem && this.func_110257_ck() && !this.func_184207_aI() && !playerEntity.func_226563_dT_()) {
                if (!this.field_70170_p.field_72995_K) {
                    playerEntity.func_184220_m((Entity)this);
                }
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (itemstack.func_77973_b() == Items.field_151141_av) {
                return itemstack.func_111282_a_(playerEntity, (LivingEntity)this, hand);
            }
            if (itemstack.func_222117_E() && isBreedingItem && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_175505_a(playerEntity, itemstack);
                this.func_70691_i(itemstack.func_77973_b().func_219967_s().func_221466_a());
                return ActionResultType.CONSUME;
            }
            return ActionResultType.PASS;
        }
        return actionresulttype;
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        return EntityUtil.shouldAttackEntity(this, target, owner, false);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        this.isLeaping = false;
        if (this.field_70146_Z.nextInt(2) == 0 && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            double dx = entityIn.func_226277_ct_() - entityIn.field_70169_q;
            double dz = entityIn.func_226281_cx_() - entityIn.field_70166_s;
            BlockPos pos = new BlockPos((int)(entityIn.func_226277_ct_() + dx * 0.5), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), (int)(entityIn.func_226281_cx_() + dz * 0.5));
            Material material = this.field_70170_p.func_180495_p(pos).func_185904_a();
            if (!material.func_76220_a() && !material.func_76224_d() && material != Material.field_151569_G) {
                this.field_70170_p.func_175656_a(pos, Blocks.field_196553_aF.func_176223_P());
                this.webList.add(new WebPos(pos, this.chargingTick > 0 ? 600 : 1200));
                this.updateWebList(true);
                this.func_213293_j(0.0, Math.max(0.25, this.func_213322_ci().field_72448_b), 0.0);
                this.field_70143_R = 0.0f;
            }
        }
        float damage = (float)this.func_233637_b_(Attributes.field_233823_f_);
        if (!(entityIn instanceof SpiderEntity) && !(entityIn instanceof SpiderPigEntity)) {
            if (this.field_70170_p.func_234853_a_(entityIn.func_174813_aQ()).anyMatch(Blocks.field_196553_aF.func_176223_P()::equals)) {
                damage += 4.0f;
            }
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage)) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean func_184776_b() {
        return this.func_110257_ck() && !this.chargeExhausted && !this.field_70123_F;
    }

    public void func_110206_u(int jumpPowerIn) {
        this.chargeExhaustion += 50 * jumpPowerIn / 100;
        this.chargePower = 1.0f * (float)jumpPowerIn / 100.0f;
    }

    public void func_184775_b(int jumpPowerIn) {
        this.chargingTick = 8 * jumpPowerIn / 100;
    }

    public void func_184777_r_() {
    }

    public boolean func_230264_L__() {
        return this.func_70089_S() && this.func_70909_n() && !this.func_70631_g_();
    }

    public void func_230266_a_(@Nullable SoundCategory soundCategory) {
        this.setSaddled(true);
        if (soundCategory != null) {
            this.field_70170_p.func_217384_a(null, (Entity)this, SoundEvents.field_187706_dO, soundCategory, 0.5f, 1.0f);
        }
    }

    public boolean func_110257_ck() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    private void setSaddled(boolean saddled) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        this.field_70180_af.func_187227_b(field_184755_bv, (Object)(saddled ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230260_a__(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public void func_230259_a_(@Nullable UUID angerTarget) {
        this.angerTarget = angerTarget;
    }

    public void func_230258_H__() {
        this.func_230260_a__(field_234230_bG_.func_233018_a_(this.field_70146_Z));
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.func_184207_aI() && this.func_110257_ck();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return false;
    }

    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        Direction direction = this.func_184172_bi();
        if (direction.func_176740_k() == Direction.Axis.Y) {
            return super.func_230268_c_(livingEntity);
        }
        int[][] aint = TransportationHelper.func_234632_a_((Direction)direction);
        BlockPos blockpos = this.func_233580_cy_();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Pose pose : livingEntity.func_230297_ef_()) {
            AxisAlignedBB axisalignedbb = livingEntity.func_233648_f_(pose);
            for (int[] aint1 : aint) {
                Vector3d vector3d;
                blockpos$mutable.func_181079_c(blockpos.func_177958_n() + aint1[0], blockpos.func_177956_o(), blockpos.func_177952_p() + aint1[1]);
                double d0 = this.field_70170_p.func_242403_h((BlockPos)blockpos$mutable);
                if (!TransportationHelper.func_234630_a_((double)d0) || !TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)livingEntity, (AxisAlignedBB)axisalignedbb.func_191194_a(vector3d = Vector3d.func_237490_a_((Vector3i)blockpos$mutable, (double)d0)))) continue;
                livingEntity.func_213301_b(pose);
                return vector3d;
            }
        }
        return super.func_230268_c_(livingEntity);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_184207_aI() && this.func_82171_bF() && this.func_110257_ck()) {
            LivingEntity passenger = (LivingEntity)this.func_184179_bs();
            this.field_70138_W = 1.0f;
            this.field_70126_B = this.field_70177_z = passenger.field_70177_z;
            this.field_70125_A = passenger.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            if (!this.chargeExhausted && this.chargePower > 0.0f && (this.field_70122_E || !this.func_213339_cH().func_204520_s().func_206888_e())) {
                double power = (double)1.6f * (double)this.chargePower;
                Vector3d lookVector = this.func_70040_Z();
                this.func_213293_j(lookVector.field_72450_a * power, (double)0.3f * (double)this.func_226269_ah_(), lookVector.field_72449_c * power);
                this.chargePower = 0.0f;
            } else {
                this.chargePower = 0.0f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                float strafe = passenger.field_70702_br * 0.8f;
                float forward = passenger.field_191988_bg * 0.6f;
                this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_));
                super.func_213352_e(new Vector3d((double)strafe, travelVector.field_72448_b, (double)forward));
            } else if (passenger instanceof PlayerEntity) {
                this.func_213317_d(Vector3d.field_186680_a);
            } else {
                this.func_233629_a_((LivingEntity)this, false);
            }
        } else {
            this.field_70138_W = 0.6f;
            this.field_70747_aH = 0.02f;
            super.func_213352_e(travelVector);
        }
    }

    public void func_241847_a(ServerWorld serverWorld, LivingEntity livingEntity) {
        if (livingEntity instanceof CreeperMinionEntity && !this.func_70909_n()) {
            CreeperMinionEntity minion = (CreeperMinionEntity)livingEntity;
            LivingEntity owner = minion.func_70902_q();
            if (owner instanceof PlayerEntity && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)((PlayerEntity)owner))) {
                serverWorld.func_72960_a((Entity)this, (byte)7);
                this.func_193101_c((PlayerEntity)owner);
                minion.func_70106_y();
            } else {
                serverWorld.func_72960_a((Entity)this, (byte)6);
            }
        }
        if (SpiderPigEntity.isPigOrSpider(livingEntity)) {
            EntityUtil.convertMobWithNBT(livingEntity, MBEntityType.SPIDER_PIG, false);
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n();
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_213295_a(BlockState blockState, Vector3d motionMultiplier) {
        if (!blockState.func_203425_a(Blocks.field_196553_aF)) {
            super.func_213295_a(blockState, motionMultiplier);
        }
    }

    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        if (this.field_70146_Z.nextInt(20) == 0) {
            return (AgeableEntity)EntityType.field_200784_X.func_200721_a((World)serverWorld);
        }
        SpiderPigEntity spiderPig = (SpiderPigEntity)MBEntityType.SPIDER_PIG.func_200721_a((World)serverWorld);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            spiderPig.func_184754_b(uuid);
            spiderPig.func_70903_f(true);
        }
        return spiderPig;
    }

    protected void func_213337_cE() {
        if (this.func_110257_ck()) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
            this.setSaddled(false);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.field_70170_p.field_72995_K && !this.webList.isEmpty()) {
            for (WebPos webPos : this.webList) {
                this.removeWeb(webPos);
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.func_233682_c_(compound);
        compound.func_74757_a("Saddle", this.func_110257_ck());
        if (!this.webList.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (WebPos coord : this.webList) {
                CompoundNBT compound1 = NBTUtil.func_186859_a((BlockPos)coord);
                compound1.func_74768_a("TimeLeft", coord.timeLeft);
                listnbt.add((Object)compound1);
            }
            compound.func_218657_a("Webs", (INBT)listnbt);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.field_70170_p instanceof ServerWorld) {
            this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
        }
        this.setSaddled(compound.func_74767_n("Saddle") || compound.func_74767_n("Saddled"));
        ListNBT listnbt = compound.func_150295_c("Webs", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compound1 = listnbt.func_150305_b(i);
            this.webList.add(i, new WebPos(NBTUtil.func_186861_c((CompoundNBT)compound1), compound1.func_74762_e("TimeLeft")));
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_SPIDER_PIG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_SPIDER_PIG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_SPIDER_PIG_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public static boolean isPigOrSpider(LivingEntity livingEntity) {
        return livingEntity.func_200600_R() == EntityType.field_200784_X || livingEntity.func_200600_R() == EntityType.field_200748_an;
    }

    static class WebPos
    extends BlockPos {
        private int timeLeft;

        public WebPos(BlockPos pos, int timeLeft) {
            super((Vector3i)pos);
            this.timeLeft = timeLeft;
        }
    }

    class LeapAttackGoal
    extends Goal {
        LeapAttackGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity target = SpiderPigEntity.this.func_70638_az();
            return target != null && SpiderPigEntity.this.leapCooldown <= 0 && (SpiderPigEntity.this.field_70122_E || !SpiderPigEntity.this.func_213339_cH().func_204520_s().func_206888_e()) && (SpiderPigEntity.this.func_70068_e((Entity)target) < 64.0 && SpiderPigEntity.this.field_70146_Z.nextInt(8) == 0 || SpiderPigEntity.this.func_70068_e((Entity)target) < 6.25);
        }

        public void func_75249_e() {
            SpiderPigEntity.this.isLeaping = true;
            SpiderPigEntity.this.leapCooldown = 15;
            LivingEntity target = SpiderPigEntity.this.func_70638_az();
            double x = target.func_226277_ct_() - SpiderPigEntity.this.func_226277_ct_();
            double y = target.func_226278_cu_() - SpiderPigEntity.this.func_226278_cu_();
            double z = target.func_226281_cx_() - SpiderPigEntity.this.func_226281_cx_();
            double d = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            double scale = 2.0f + 0.2f * SpiderPigEntity.this.field_70146_Z.nextFloat() * SpiderPigEntity.this.field_70146_Z.nextFloat();
            SpiderPigEntity.this.func_213293_j(x / d * scale, (y / d * scale * 0.5 + 0.3) * (double)SpiderPigEntity.this.func_226269_ah_(), z / d * scale);
        }

        public boolean func_75253_b() {
            return SpiderPigEntity.this.isLeaping && SpiderPigEntity.this.leapTick < 40;
        }

        public void func_75246_d() {
            ++SpiderPigEntity.this.leapTick;
        }

        public void func_75251_c() {
            SpiderPigEntity.this.leapTick = 0;
        }
    }
}

